/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.system.windows;

import java.nio.ByteBuffer;
import java.util.concurrent.atomic.AtomicInteger;
import org.lwjgl.Pointer;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.windows.WINDOWPOS;
import org.lwjgl.system.windows.WNDCLASSEX;
import org.lwjgl.system.windows.WinBase;
import org.lwjgl.system.windows.WinUser;
import org.lwjgl.system.windows.WindowProc;
import org.lwjgl.system.windows.WindowsLibrary;
import org.lwjgl.system.windows.WindowsPlatform;

public class WindowsDisplay {
    public static final long DEF_WINDOW_PROC = WinBase.GetProcAddress(WinBase.GetModuleHandle("User32.dll"), "DefWindowProcW");
    private static final AtomicInteger WINDOW_ID;
    private final int id = WINDOW_ID.incrementAndGet();
    private final WindowProc wndProc = new WindowProcImpl();
    private final short classAtom;
    private final long hwnd;
    private final long hdc;
    private final ByteBuffer windowPos = WINDOWPOS.malloc();
    private boolean closeRequested;

    public WindowsDisplay() {
        this("LWJGL");
    }

    public WindowsDisplay(String title) {
        this(title, 640, 480);
    }

    public WindowsDisplay(String title, int width, int height) {
        WINDOWPOS.cx(this.windowPos, width);
        WINDOWPOS.cy(this.windowPos, height);
        String className = "LWJGL" + this.id;
        ByteBuffer classNameEncoded = MemoryUtil.memEncodeUTF16(className);
        ByteBuffer in = WNDCLASSEX.malloc(WNDCLASSEX.SIZEOF, 32, this.wndProc.getPointer(), 0, Pointer.POINTER_SIZE + 4, WindowsLibrary.HINSTANCE, WinUser.nLoadIcon(0L, 32512L), WinUser.nLoadCursor(0L, 32512L), 0L, null, classNameEncoded, 0L);
        this.classAtom = WinUser.RegisterClassEx(in);
        WindowsPlatform.windowsCheckHandle(this.classAtom, "Failed to register window class");
        this.hwnd = WinUser.CreateWindowEx(262144, className, title, 114229248, 0, 0, width, height, 0L, 0L, WindowsLibrary.HINSTANCE, this.wndProc.getPointer());
        WindowsPlatform.windowsCheckHandle(this.hwnd, "Failed to create window");
        this.hdc = WinUser.GetDC(this.hwnd);
        WindowsPlatform.windowsCheckHandle(this.hdc, "Failed to get device context handle.");
    }

    public long getHwnd() {
        return this.hwnd;
    }

    public long getHdc() {
        return this.hdc;
    }

    public int getX() {
        return WINDOWPOS.x(this.windowPos);
    }

    public int getY() {
        return WINDOWPOS.y(this.windowPos);
    }

    public int getWidth() {
        return WINDOWPOS.cx(this.windowPos);
    }

    public int getHeight() {
        return WINDOWPOS.cy(this.windowPos);
    }

    public void setLocation(int x, int y) {
        WindowsPlatform.windowsCheckResult(WinUser.SetWindowPos(this.hwnd, 0L, x, y, WINDOWPOS.cx(this.windowPos), WINDOWPOS.cy(this.windowPos), 513), "SetWindowPos");
    }

    public void setSize(int width, int height) {
        WindowsPlatform.windowsCheckResult(WinUser.SetWindowPos(this.hwnd, 0L, WINDOWPOS.x(this.windowPos), WINDOWPOS.y(this.windowPos), width, height, 514), "SetWindowPos");
    }

    public void setVisible(boolean visible) {
        WinUser.ShowWindow(this.hwnd, visible ? 5 : 0);
    }

    public void destroy() {
        WindowsPlatform.windowsCheckResult(WinUser.DestroyWindow(this.hwnd), "DestroyWindow");
        WindowsPlatform.windowsCheckResult(WinUser.UnregisterClass("LWJGL" + this.id, WindowsLibrary.HINSTANCE), "UnregisterClass");
        this.wndProc.release();
    }

    public boolean isCloseRequested() {
        return this.closeRequested;
    }

    static {
        if (DEF_WINDOW_PROC == 0L) {
            throw new RuntimeException("Failed to retrieve the default window proc.");
        }
        WINDOW_ID = new AtomicInteger(0);
    }

    private class WindowProcImpl
    extends WindowProc {
        private WindowProcImpl() {
        }

        @Override
        public long invoke(long hWnd, int msg, long wParam, long lParam) {
            switch (msg) {
                case 18: {
                    System.out.println("\tQUIT!");
                    WindowsDisplay.this.closeRequested = true;
                    return 0L;
                }
                case 274: {
                    switch ((int)(wParam & 0xFFF0L)) {
                        case 61584: 
                        case 61696: 
                        case 61760: 
                        case 61808: {
                            return 0L;
                        }
                        case 61536: {
                            System.out.println("\tSC_CLOSE!");
                            WindowsDisplay.this.closeRequested = true;
                            return 0L;
                        }
                    }
                    break;
                }
                case 71: {
                    MemoryUtil.memCopy(lParam, MemoryUtil.memAddress(WindowsDisplay.this.windowPos), WINDOWPOS.SIZEOF);
                }
            }
            return WinUser.nDefWindowProc(hWnd, msg, wParam, lParam);
        }
    }
}

