/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.system.windows;

import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import org.lwjgl.BufferUtils;
import org.lwjgl.LWJGLUtil;
import org.lwjgl.Pointer;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.windows.POINTFLOAT;

public final class GLYPHMETRICSFLOAT
implements Pointer {
    public static final int SIZEOF;
    public static final int BLACKBOXX;
    public static final int BLOCKBOXY;
    public static final int GLYPHORIGIN;
    public static final int CELLINCX;
    public static final int CELLINCY;
    private final ByteBuffer struct;

    public GLYPHMETRICSFLOAT() {
        this(GLYPHMETRICSFLOAT.malloc());
    }

    public GLYPHMETRICSFLOAT(ByteBuffer struct) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkBuffer((Buffer)struct, SIZEOF);
        }
        this.struct = struct;
    }

    public ByteBuffer buffer() {
        return this.struct;
    }

    @Override
    public long getPointer() {
        return MemoryUtil.memAddress(this.struct);
    }

    public void setBlackBoxX(float blackBoxX) {
        GLYPHMETRICSFLOAT.blackBoxX(this.struct, blackBoxX);
    }

    public void setBlockBoxY(float blockBoxY) {
        GLYPHMETRICSFLOAT.blockBoxY(this.struct, blockBoxY);
    }

    public void setGlyphOrigin(ByteBuffer glyphOrigin) {
        GLYPHMETRICSFLOAT.glyphOriginSet(this.struct, glyphOrigin);
    }

    public void setGlyphOriginX(float x) {
        GLYPHMETRICSFLOAT.glyphOriginX(this.struct, x);
    }

    public void setGlyphOriginY(float y) {
        GLYPHMETRICSFLOAT.glyphOriginY(this.struct, y);
    }

    public void setCellIncX(float cellIncX) {
        GLYPHMETRICSFLOAT.cellIncX(this.struct, cellIncX);
    }

    public void setCellIncY(float cellIncY) {
        GLYPHMETRICSFLOAT.cellIncY(this.struct, cellIncY);
    }

    public float getBlackBoxX() {
        return GLYPHMETRICSFLOAT.blackBoxX(this.struct);
    }

    public float getBlockBoxY() {
        return GLYPHMETRICSFLOAT.blockBoxY(this.struct);
    }

    public void getGlyphOrigin(ByteBuffer glyphOrigin) {
        GLYPHMETRICSFLOAT.glyphOriginGet(this.struct, glyphOrigin);
    }

    public float getGlyphOriginX() {
        return GLYPHMETRICSFLOAT.glyphOriginX(this.struct);
    }

    public float getGlyphOriginY() {
        return GLYPHMETRICSFLOAT.glyphOriginY(this.struct);
    }

    public float getCellIncX() {
        return GLYPHMETRICSFLOAT.cellIncX(this.struct);
    }

    public float getCellIncY() {
        return GLYPHMETRICSFLOAT.cellIncY(this.struct);
    }

    private static native int offsets(long var0);

    public static ByteBuffer malloc() {
        return BufferUtils.createByteBuffer(SIZEOF);
    }

    public static ByteBuffer malloc(float blackBoxX, float blockBoxY, ByteBuffer glyphOrigin, float cellIncX, float cellIncY) {
        ByteBuffer glyphmetricsfloat = GLYPHMETRICSFLOAT.malloc();
        GLYPHMETRICSFLOAT.blackBoxX(glyphmetricsfloat, blackBoxX);
        GLYPHMETRICSFLOAT.blockBoxY(glyphmetricsfloat, blockBoxY);
        GLYPHMETRICSFLOAT.glyphOriginSet(glyphmetricsfloat, glyphOrigin);
        GLYPHMETRICSFLOAT.cellIncX(glyphmetricsfloat, cellIncX);
        GLYPHMETRICSFLOAT.cellIncY(glyphmetricsfloat, cellIncY);
        return glyphmetricsfloat;
    }

    public static void blackBoxX(ByteBuffer glyphmetricsfloat, float blackBoxX) {
        glyphmetricsfloat.putFloat(glyphmetricsfloat.position() + BLACKBOXX, blackBoxX);
    }

    public static void blockBoxY(ByteBuffer glyphmetricsfloat, float blockBoxY) {
        glyphmetricsfloat.putFloat(glyphmetricsfloat.position() + BLOCKBOXY, blockBoxY);
    }

    public static void glyphOriginSet(ByteBuffer glyphmetricsfloat, ByteBuffer glyphOrigin) {
        if (glyphOrigin != null) {
            MemoryUtil.memCopy(MemoryUtil.memAddress(glyphOrigin), MemoryUtil.memAddress(glyphmetricsfloat) + (long)GLYPHORIGIN, POINTFLOAT.SIZEOF);
        }
    }

    public static void glyphOriginX(ByteBuffer glyphmetricsfloat, float x) {
        glyphmetricsfloat.putFloat(glyphmetricsfloat.position() + GLYPHORIGIN + POINTFLOAT.X, x);
    }

    public static void glyphOriginY(ByteBuffer glyphmetricsfloat, float y) {
        glyphmetricsfloat.putFloat(glyphmetricsfloat.position() + GLYPHORIGIN + POINTFLOAT.Y, y);
    }

    public static void cellIncX(ByteBuffer glyphmetricsfloat, float cellIncX) {
        glyphmetricsfloat.putFloat(glyphmetricsfloat.position() + CELLINCX, cellIncX);
    }

    public static void cellIncY(ByteBuffer glyphmetricsfloat, float cellIncY) {
        glyphmetricsfloat.putFloat(glyphmetricsfloat.position() + CELLINCY, cellIncY);
    }

    public static float blackBoxX(ByteBuffer glyphmetricsfloat) {
        return glyphmetricsfloat.getFloat(glyphmetricsfloat.position() + BLACKBOXX);
    }

    public static float blockBoxY(ByteBuffer glyphmetricsfloat) {
        return glyphmetricsfloat.getFloat(glyphmetricsfloat.position() + BLOCKBOXY);
    }

    public static void glyphOriginGet(ByteBuffer glyphmetricsfloat, ByteBuffer glyphOrigin) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkBuffer((Buffer)glyphOrigin, POINTFLOAT.SIZEOF);
        }
        MemoryUtil.memCopy(MemoryUtil.memAddress(glyphmetricsfloat) + (long)GLYPHORIGIN, MemoryUtil.memAddress(glyphOrigin), POINTFLOAT.SIZEOF);
    }

    public static float glyphOriginX(ByteBuffer glyphmetricsfloat) {
        return glyphmetricsfloat.getFloat(glyphmetricsfloat.position() + GLYPHORIGIN + POINTFLOAT.X);
    }

    public static float glyphOriginY(ByteBuffer glyphmetricsfloat) {
        return glyphmetricsfloat.getFloat(glyphmetricsfloat.position() + GLYPHORIGIN + POINTFLOAT.Y);
    }

    public static float cellIncX(ByteBuffer glyphmetricsfloat) {
        return glyphmetricsfloat.getFloat(glyphmetricsfloat.position() + CELLINCX);
    }

    public static float cellIncY(ByteBuffer glyphmetricsfloat) {
        return glyphmetricsfloat.getFloat(glyphmetricsfloat.position() + CELLINCY);
    }

    static {
        IntBuffer offsets = BufferUtils.createIntBuffer(5);
        SIZEOF = GLYPHMETRICSFLOAT.offsets(MemoryUtil.memAddress(offsets));
        BLACKBOXX = offsets.get(0);
        BLOCKBOXY = offsets.get(1);
        GLYPHORIGIN = offsets.get(2);
        CELLINCX = offsets.get(3);
        CELLINCY = offsets.get(4);
    }
}

