/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.system.macosx;

import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import org.lwjgl.BufferUtils;
import org.lwjgl.LWJGLUtil;
import org.lwjgl.Pointer;
import org.lwjgl.PointerBuffer;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryUtil;

public final class ObjCPropertyAttribute
implements Pointer {
    public static final int SIZEOF;
    public static final int NAME;
    public static final int VALUE;
    private final ByteBuffer struct;

    public ObjCPropertyAttribute() {
        this(ObjCPropertyAttribute.malloc());
    }

    public ObjCPropertyAttribute(ByteBuffer struct) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkBuffer((Buffer)struct, SIZEOF);
        }
        this.struct = struct;
    }

    public ByteBuffer buffer() {
        return this.struct;
    }

    @Override
    public long getPointer() {
        return MemoryUtil.memAddress(this.struct);
    }

    public void setName(long name) {
        ObjCPropertyAttribute.name(this.struct, name);
    }

    public void setName(ByteBuffer name) {
        ObjCPropertyAttribute.name(this.struct, name);
    }

    public void setValue(long value) {
        ObjCPropertyAttribute.value(this.struct, value);
    }

    public void setValue(ByteBuffer value) {
        ObjCPropertyAttribute.value(this.struct, value);
    }

    public long getName() {
        return ObjCPropertyAttribute.name(this.struct);
    }

    public ByteBuffer getNameBuffer() {
        return ObjCPropertyAttribute.nameBuffer(this.struct);
    }

    public String getNameString() {
        return ObjCPropertyAttribute.nameString(this.struct);
    }

    public long getValue() {
        return ObjCPropertyAttribute.value(this.struct);
    }

    public ByteBuffer getValueBuffer() {
        return ObjCPropertyAttribute.valueBuffer(this.struct);
    }

    public String getValueString() {
        return ObjCPropertyAttribute.valueString(this.struct);
    }

    private static native int offsets(long var0);

    public static ByteBuffer malloc() {
        return BufferUtils.createByteBuffer(SIZEOF);
    }

    public static ByteBuffer malloc(ByteBuffer name, ByteBuffer value) {
        ByteBuffer objc_property_attribute_t = ObjCPropertyAttribute.malloc();
        ObjCPropertyAttribute.name(objc_property_attribute_t, name);
        ObjCPropertyAttribute.value(objc_property_attribute_t, value);
        return objc_property_attribute_t;
    }

    public static void name(ByteBuffer objc_property_attribute_t, long name) {
        PointerBuffer.put(objc_property_attribute_t, objc_property_attribute_t.position() + NAME, name);
    }

    public static void name(ByteBuffer objc_property_attribute_t, ByteBuffer name) {
        if (LWJGLUtil.CHECKS && name != null) {
            Checks.checkNT1(name);
        }
        ObjCPropertyAttribute.name(objc_property_attribute_t, MemoryUtil.memAddressSafe(name));
    }

    public static void value(ByteBuffer objc_property_attribute_t, long value) {
        PointerBuffer.put(objc_property_attribute_t, objc_property_attribute_t.position() + VALUE, value);
    }

    public static void value(ByteBuffer objc_property_attribute_t, ByteBuffer value) {
        if (LWJGLUtil.CHECKS && value != null) {
            Checks.checkNT1(value);
        }
        ObjCPropertyAttribute.value(objc_property_attribute_t, MemoryUtil.memAddressSafe(value));
    }

    public static long name(ByteBuffer objc_property_attribute_t) {
        return PointerBuffer.get(objc_property_attribute_t, objc_property_attribute_t.position() + NAME);
    }

    public static ByteBuffer nameBuffer(ByteBuffer objc_property_attribute_t) {
        return MemoryUtil.memByteBufferNT1(ObjCPropertyAttribute.name(objc_property_attribute_t));
    }

    public static String nameString(ByteBuffer objc_property_attribute_t) {
        return MemoryUtil.memDecodeUTF8(ObjCPropertyAttribute.name(objc_property_attribute_t));
    }

    public static long value(ByteBuffer objc_property_attribute_t) {
        return PointerBuffer.get(objc_property_attribute_t, objc_property_attribute_t.position() + VALUE);
    }

    public static ByteBuffer valueBuffer(ByteBuffer objc_property_attribute_t) {
        return MemoryUtil.memByteBufferNT1(ObjCPropertyAttribute.value(objc_property_attribute_t));
    }

    public static String valueString(ByteBuffer objc_property_attribute_t) {
        return MemoryUtil.memDecodeUTF8(ObjCPropertyAttribute.value(objc_property_attribute_t));
    }

    static {
        IntBuffer offsets = BufferUtils.createIntBuffer(2);
        SIZEOF = ObjCPropertyAttribute.offsets(MemoryUtil.memAddress(offsets));
        NAME = offsets.get(0);
        VALUE = offsets.get(1);
    }
}

