/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.system.linux;

import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import org.lwjgl.BufferUtils;
import org.lwjgl.LWJGLUtil;
import org.lwjgl.Pointer;
import org.lwjgl.PointerBuffer;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.linux.XkbKeyAliasRec;
import org.lwjgl.system.linux.XkbKeyNameRec;

public final class XkbNamesRec
implements Pointer {
    public static final int SIZEOF;
    public static final int KEYCODES;
    public static final int GEOMETRY;
    public static final int SYMBOLS;
    public static final int TYPES;
    public static final int COMPAT;
    public static final int VMODS;
    public static final int INDICATORS;
    public static final int GROUPS;
    public static final int KEYS;
    public static final int KEY_ALIASES;
    public static final int RADIO_GROUPS;
    public static final int PHYS_SYMBOLS;
    public static final int NUM_KEYS;
    public static final int NUM_KEY_ALIASES;
    public static final int NUM_RG;
    private final ByteBuffer struct;

    public XkbNamesRec() {
        this(XkbNamesRec.malloc());
    }

    public XkbNamesRec(ByteBuffer struct) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkBuffer((Buffer)struct, SIZEOF);
        }
        this.struct = struct;
    }

    public ByteBuffer buffer() {
        return this.struct;
    }

    @Override
    public long getPointer() {
        return MemoryUtil.memAddress(this.struct);
    }

    public void setKeycodes(long keycodes) {
        XkbNamesRec.keycodes(this.struct, keycodes);
    }

    public void setGeometry(long geometry) {
        XkbNamesRec.geometry(this.struct, geometry);
    }

    public void setSymbols(long symbols) {
        XkbNamesRec.symbols(this.struct, symbols);
    }

    public void setTypes(long types) {
        XkbNamesRec.types(this.struct, types);
    }

    public void setCompat(long compat) {
        XkbNamesRec.compat(this.struct, compat);
    }

    public void setVmods(ByteBuffer vmods) {
        XkbNamesRec.vmodsSet(this.struct, vmods);
    }

    public void setVmods(int index, long vmods) {
        XkbNamesRec.vmods(this.struct, index, vmods);
    }

    public void setIndicators(ByteBuffer indicators) {
        XkbNamesRec.indicatorsSet(this.struct, indicators);
    }

    public void setIndicators(int index, long indicators) {
        XkbNamesRec.indicators(this.struct, index, indicators);
    }

    public void setGroups(ByteBuffer groups) {
        XkbNamesRec.groupsSet(this.struct, groups);
    }

    public void setGroups(int index, long groups) {
        XkbNamesRec.groups(this.struct, index, groups);
    }

    public void setKeys(long keys) {
        XkbNamesRec.keys(this.struct, keys);
    }

    public void setKeys(ByteBuffer keys) {
        XkbNamesRec.keys(this.struct, keys);
    }

    public void setKeyAliases(long key_aliases) {
        XkbNamesRec.key_aliases(this.struct, key_aliases);
    }

    public void setKeyAliases(ByteBuffer key_aliases) {
        XkbNamesRec.key_aliases(this.struct, key_aliases);
    }

    public void setRadioGroups(long radio_groups) {
        XkbNamesRec.radio_groups(this.struct, radio_groups);
    }

    public void setRadioGroups(ByteBuffer radio_groups) {
        XkbNamesRec.radio_groups(this.struct, radio_groups);
    }

    public void setPhysSymbols(long phys_symbols) {
        XkbNamesRec.phys_symbols(this.struct, phys_symbols);
    }

    public void setNumKeys(int num_keys) {
        XkbNamesRec.num_keys(this.struct, num_keys);
    }

    public void setNumKeyAliases(int num_key_aliases) {
        XkbNamesRec.num_key_aliases(this.struct, num_key_aliases);
    }

    public void setNumRg(int num_rg) {
        XkbNamesRec.num_rg(this.struct, num_rg);
    }

    public long getKeycodes() {
        return XkbNamesRec.keycodes(this.struct);
    }

    public long getGeometry() {
        return XkbNamesRec.geometry(this.struct);
    }

    public long getSymbols() {
        return XkbNamesRec.symbols(this.struct);
    }

    public long getTypes() {
        return XkbNamesRec.types(this.struct);
    }

    public long getCompat() {
        return XkbNamesRec.compat(this.struct);
    }

    public void getVmods(ByteBuffer vmods) {
        XkbNamesRec.vmodsGet(this.struct, vmods);
    }

    public void getIndicators(ByteBuffer indicators) {
        XkbNamesRec.indicatorsGet(this.struct, indicators);
    }

    public void getGroups(ByteBuffer groups) {
        XkbNamesRec.groupsGet(this.struct, groups);
    }

    public long getKeys() {
        return XkbNamesRec.keys(this.struct);
    }

    public ByteBuffer getKeysBuffer() {
        return XkbNamesRec.keysBuffer(this.struct);
    }

    public long getKeyAliases() {
        return XkbNamesRec.key_aliases(this.struct);
    }

    public ByteBuffer getKeyAliasesBuffer() {
        return XkbNamesRec.key_aliasesBuffer(this.struct);
    }

    public long getRadioGroups() {
        return XkbNamesRec.radio_groups(this.struct);
    }

    public ByteBuffer getRadioGroups(int byteLen) {
        return XkbNamesRec.radio_groups(this.struct, byteLen);
    }

    public long getPhysSymbols() {
        return XkbNamesRec.phys_symbols(this.struct);
    }

    public int getNumKeys() {
        return XkbNamesRec.num_keys(this.struct);
    }

    public int getNumKeyAliases() {
        return XkbNamesRec.num_key_aliases(this.struct);
    }

    public int getNumRg() {
        return XkbNamesRec.num_rg(this.struct);
    }

    private static native int offsets(long var0);

    public static ByteBuffer malloc() {
        return BufferUtils.createByteBuffer(SIZEOF);
    }

    public static ByteBuffer malloc(long keycodes, long geometry, long symbols, long types, long compat, ByteBuffer vmods, ByteBuffer indicators, ByteBuffer groups, ByteBuffer keys, ByteBuffer key_aliases, ByteBuffer radio_groups, long phys_symbols, int num_keys, int num_key_aliases, int num_rg) {
        ByteBuffer xkbnamesrec = XkbNamesRec.malloc();
        XkbNamesRec.keycodes(xkbnamesrec, keycodes);
        XkbNamesRec.geometry(xkbnamesrec, geometry);
        XkbNamesRec.symbols(xkbnamesrec, symbols);
        XkbNamesRec.types(xkbnamesrec, types);
        XkbNamesRec.compat(xkbnamesrec, compat);
        XkbNamesRec.vmodsSet(xkbnamesrec, vmods);
        XkbNamesRec.indicatorsSet(xkbnamesrec, indicators);
        XkbNamesRec.groupsSet(xkbnamesrec, groups);
        XkbNamesRec.keys(xkbnamesrec, keys);
        XkbNamesRec.key_aliases(xkbnamesrec, key_aliases);
        XkbNamesRec.radio_groups(xkbnamesrec, radio_groups);
        XkbNamesRec.phys_symbols(xkbnamesrec, phys_symbols);
        XkbNamesRec.num_keys(xkbnamesrec, num_keys);
        XkbNamesRec.num_key_aliases(xkbnamesrec, num_key_aliases);
        XkbNamesRec.num_rg(xkbnamesrec, num_rg);
        return xkbnamesrec;
    }

    public static void keycodes(ByteBuffer xkbnamesrec, long keycodes) {
        PointerBuffer.put(xkbnamesrec, xkbnamesrec.position() + KEYCODES, keycodes);
    }

    public static void geometry(ByteBuffer xkbnamesrec, long geometry) {
        PointerBuffer.put(xkbnamesrec, xkbnamesrec.position() + GEOMETRY, geometry);
    }

    public static void symbols(ByteBuffer xkbnamesrec, long symbols) {
        PointerBuffer.put(xkbnamesrec, xkbnamesrec.position() + SYMBOLS, symbols);
    }

    public static void types(ByteBuffer xkbnamesrec, long types) {
        PointerBuffer.put(xkbnamesrec, xkbnamesrec.position() + TYPES, types);
    }

    public static void compat(ByteBuffer xkbnamesrec, long compat) {
        PointerBuffer.put(xkbnamesrec, xkbnamesrec.position() + COMPAT, compat);
    }

    public static void vmodsSet(ByteBuffer xkbnamesrec, ByteBuffer vmods) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkBufferGT(vmods, 16 * POINTER_SIZE);
        }
        MemoryUtil.memCopy(MemoryUtil.memAddress(vmods), MemoryUtil.memAddress(xkbnamesrec) + (long)VMODS, vmods.remaining());
    }

    public static void vmods(ByteBuffer xkbnamesrec, int index, long vmods) {
        PointerBuffer.put(xkbnamesrec, VMODS + index * POINTER_SIZE, vmods);
    }

    public static void indicatorsSet(ByteBuffer xkbnamesrec, ByteBuffer indicators) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkBufferGT(indicators, 32 * POINTER_SIZE);
        }
        MemoryUtil.memCopy(MemoryUtil.memAddress(indicators), MemoryUtil.memAddress(xkbnamesrec) + (long)INDICATORS, indicators.remaining());
    }

    public static void indicators(ByteBuffer xkbnamesrec, int index, long indicators) {
        PointerBuffer.put(xkbnamesrec, INDICATORS + index * POINTER_SIZE, indicators);
    }

    public static void groupsSet(ByteBuffer xkbnamesrec, ByteBuffer groups) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkBufferGT(groups, 4 * POINTER_SIZE);
        }
        MemoryUtil.memCopy(MemoryUtil.memAddress(groups), MemoryUtil.memAddress(xkbnamesrec) + (long)GROUPS, groups.remaining());
    }

    public static void groups(ByteBuffer xkbnamesrec, int index, long groups) {
        PointerBuffer.put(xkbnamesrec, GROUPS + index * POINTER_SIZE, groups);
    }

    public static void keys(ByteBuffer xkbnamesrec, long keys) {
        PointerBuffer.put(xkbnamesrec, xkbnamesrec.position() + KEYS, keys);
    }

    public static void keys(ByteBuffer xkbnamesrec, ByteBuffer keys) {
        XkbNamesRec.keys(xkbnamesrec, MemoryUtil.memAddressSafe(keys));
    }

    public static void key_aliases(ByteBuffer xkbnamesrec, long key_aliases) {
        PointerBuffer.put(xkbnamesrec, xkbnamesrec.position() + KEY_ALIASES, key_aliases);
    }

    public static void key_aliases(ByteBuffer xkbnamesrec, ByteBuffer key_aliases) {
        XkbNamesRec.key_aliases(xkbnamesrec, MemoryUtil.memAddressSafe(key_aliases));
    }

    public static void radio_groups(ByteBuffer xkbnamesrec, long radio_groups) {
        PointerBuffer.put(xkbnamesrec, xkbnamesrec.position() + RADIO_GROUPS, radio_groups);
    }

    public static void radio_groups(ByteBuffer xkbnamesrec, ByteBuffer radio_groups) {
        XkbNamesRec.radio_groups(xkbnamesrec, MemoryUtil.memAddressSafe(radio_groups));
    }

    public static void phys_symbols(ByteBuffer xkbnamesrec, long phys_symbols) {
        PointerBuffer.put(xkbnamesrec, xkbnamesrec.position() + PHYS_SYMBOLS, phys_symbols);
    }

    public static void num_keys(ByteBuffer xkbnamesrec, int num_keys) {
        xkbnamesrec.put(xkbnamesrec.position() + NUM_KEYS, (byte)num_keys);
    }

    public static void num_key_aliases(ByteBuffer xkbnamesrec, int num_key_aliases) {
        xkbnamesrec.put(xkbnamesrec.position() + NUM_KEY_ALIASES, (byte)num_key_aliases);
    }

    public static void num_rg(ByteBuffer xkbnamesrec, int num_rg) {
        xkbnamesrec.putShort(xkbnamesrec.position() + NUM_RG, (short)num_rg);
    }

    public static long keycodes(ByteBuffer xkbnamesrec) {
        return PointerBuffer.get(xkbnamesrec, xkbnamesrec.position() + KEYCODES);
    }

    public static long geometry(ByteBuffer xkbnamesrec) {
        return PointerBuffer.get(xkbnamesrec, xkbnamesrec.position() + GEOMETRY);
    }

    public static long symbols(ByteBuffer xkbnamesrec) {
        return PointerBuffer.get(xkbnamesrec, xkbnamesrec.position() + SYMBOLS);
    }

    public static long types(ByteBuffer xkbnamesrec) {
        return PointerBuffer.get(xkbnamesrec, xkbnamesrec.position() + TYPES);
    }

    public static long compat(ByteBuffer xkbnamesrec) {
        return PointerBuffer.get(xkbnamesrec, xkbnamesrec.position() + COMPAT);
    }

    public static void vmodsGet(ByteBuffer xkbnamesrec, ByteBuffer vmods) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkBufferGT(vmods, 128);
        }
        MemoryUtil.memCopy(MemoryUtil.memAddress(xkbnamesrec) + (long)VMODS, MemoryUtil.memAddress(vmods), vmods.remaining());
    }

    public static long vmods(ByteBuffer xkbnamesrec, int index) {
        return xkbnamesrec.getLong(VMODS + index * 8);
    }

    public static void indicatorsGet(ByteBuffer xkbnamesrec, ByteBuffer indicators) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkBufferGT(indicators, 256);
        }
        MemoryUtil.memCopy(MemoryUtil.memAddress(xkbnamesrec) + (long)INDICATORS, MemoryUtil.memAddress(indicators), indicators.remaining());
    }

    public static long indicators(ByteBuffer xkbnamesrec, int index) {
        return xkbnamesrec.getLong(INDICATORS + index * 8);
    }

    public static void groupsGet(ByteBuffer xkbnamesrec, ByteBuffer groups) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkBufferGT(groups, 32);
        }
        MemoryUtil.memCopy(MemoryUtil.memAddress(xkbnamesrec) + (long)GROUPS, MemoryUtil.memAddress(groups), groups.remaining());
    }

    public static long groups(ByteBuffer xkbnamesrec, int index) {
        return xkbnamesrec.getLong(GROUPS + index * 8);
    }

    public static long keys(ByteBuffer xkbnamesrec) {
        return PointerBuffer.get(xkbnamesrec, xkbnamesrec.position() + KEYS);
    }

    public static ByteBuffer keysBuffer(ByteBuffer xkbnamesrec) {
        return MemoryUtil.memByteBuffer(XkbNamesRec.keys(xkbnamesrec), XkbKeyNameRec.SIZEOF);
    }

    public static long key_aliases(ByteBuffer xkbnamesrec) {
        return PointerBuffer.get(xkbnamesrec, xkbnamesrec.position() + KEY_ALIASES);
    }

    public static ByteBuffer key_aliasesBuffer(ByteBuffer xkbnamesrec) {
        return MemoryUtil.memByteBuffer(XkbNamesRec.key_aliases(xkbnamesrec), XkbKeyAliasRec.SIZEOF);
    }

    public static long radio_groups(ByteBuffer xkbnamesrec) {
        return PointerBuffer.get(xkbnamesrec, xkbnamesrec.position() + RADIO_GROUPS);
    }

    public static ByteBuffer radio_groups(ByteBuffer xkbnamesrec, int byteLen) {
        return MemoryUtil.memByteBuffer(XkbNamesRec.radio_groups(xkbnamesrec), byteLen);
    }

    public static long phys_symbols(ByteBuffer xkbnamesrec) {
        return PointerBuffer.get(xkbnamesrec, xkbnamesrec.position() + PHYS_SYMBOLS);
    }

    public static int num_keys(ByteBuffer xkbnamesrec) {
        return xkbnamesrec.get(xkbnamesrec.position() + NUM_KEYS) & 0xFF;
    }

    public static int num_key_aliases(ByteBuffer xkbnamesrec) {
        return xkbnamesrec.get(xkbnamesrec.position() + NUM_KEY_ALIASES) & 0xFF;
    }

    public static int num_rg(ByteBuffer xkbnamesrec) {
        return xkbnamesrec.getShort(xkbnamesrec.position() + NUM_RG) & 0xFFFF;
    }

    static {
        IntBuffer offsets = BufferUtils.createIntBuffer(15);
        SIZEOF = XkbNamesRec.offsets(MemoryUtil.memAddress(offsets));
        KEYCODES = offsets.get(0);
        GEOMETRY = offsets.get(1);
        SYMBOLS = offsets.get(2);
        TYPES = offsets.get(3);
        COMPAT = offsets.get(4);
        VMODS = offsets.get(5);
        INDICATORS = offsets.get(6);
        GROUPS = offsets.get(7);
        KEYS = offsets.get(8);
        KEY_ALIASES = offsets.get(9);
        RADIO_GROUPS = offsets.get(10);
        PHYS_SYMBOLS = offsets.get(11);
        NUM_KEYS = offsets.get(12);
        NUM_KEY_ALIASES = offsets.get(13);
        NUM_RG = offsets.get(14);
    }
}

