/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.system.linux;

import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import org.lwjgl.BufferUtils;
import org.lwjgl.LWJGLUtil;
import org.lwjgl.Pointer;
import org.lwjgl.PointerBuffer;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryUtil;

public final class XSizeHints
implements Pointer {
    public static final int SIZEOF;
    public static final int FLAGS;
    public static final int X;
    public static final int Y;
    public static final int WIDTH;
    public static final int HEIGHT;
    public static final int MIN_WIDTH;
    public static final int MIN_HEIGHT;
    public static final int MAX_WIDTH;
    public static final int MAX_HEIGHT;
    public static final int WIDTH_INC;
    public static final int HEIGHT_INC;
    public static final int MIN_ASPECT;
    public static final int MIN_ASPECT_X;
    public static final int MIN_ASPECT_Y;
    public static final int MAX_ASPECT;
    public static final int MAX_ASPECT_X;
    public static final int MAX_ASPECT_Y;
    public static final int BASE_WIDTH;
    public static final int BASE_HEIGHT;
    public static final int WIN_GRAVITY;
    private final ByteBuffer struct;

    public XSizeHints() {
        this(XSizeHints.malloc());
    }

    public XSizeHints(ByteBuffer struct) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkBuffer((Buffer)struct, SIZEOF);
        }
        this.struct = struct;
    }

    public ByteBuffer buffer() {
        return this.struct;
    }

    @Override
    public long getPointer() {
        return MemoryUtil.memAddress(this.struct);
    }

    public void setFlags(long flags) {
        XSizeHints.flags(this.struct, flags);
    }

    public void setX(int x) {
        XSizeHints.x(this.struct, x);
    }

    public void setY(int y) {
        XSizeHints.y(this.struct, y);
    }

    public void setWidth(int width) {
        XSizeHints.width(this.struct, width);
    }

    public void setHeight(int height) {
        XSizeHints.height(this.struct, height);
    }

    public void setMinWidth(int min_width) {
        XSizeHints.min_width(this.struct, min_width);
    }

    public void setMinHeight(int min_height) {
        XSizeHints.min_height(this.struct, min_height);
    }

    public void setMaxWidth(int max_width) {
        XSizeHints.max_width(this.struct, max_width);
    }

    public void setMaxHeight(int max_height) {
        XSizeHints.max_height(this.struct, max_height);
    }

    public void setWidthInc(int width_inc) {
        XSizeHints.width_inc(this.struct, width_inc);
    }

    public void setHeightInc(int height_inc) {
        XSizeHints.height_inc(this.struct, height_inc);
    }

    public void setMinAspectX(int x) {
        XSizeHints.min_aspectX(this.struct, x);
    }

    public void setMinAspectY(int y) {
        XSizeHints.min_aspectY(this.struct, y);
    }

    public void setMaxAspectX(int x) {
        XSizeHints.max_aspectX(this.struct, x);
    }

    public void setMaxAspectY(int y) {
        XSizeHints.max_aspectY(this.struct, y);
    }

    public void setBaseWidth(int base_width) {
        XSizeHints.base_width(this.struct, base_width);
    }

    public void setBaseHeight(int base_height) {
        XSizeHints.base_height(this.struct, base_height);
    }

    public void setWinGravity(int win_gravity) {
        XSizeHints.win_gravity(this.struct, win_gravity);
    }

    public long getFlags() {
        return XSizeHints.flags(this.struct);
    }

    public int getX() {
        return XSizeHints.x(this.struct);
    }

    public int getY() {
        return XSizeHints.y(this.struct);
    }

    public int getWidth() {
        return XSizeHints.width(this.struct);
    }

    public int getHeight() {
        return XSizeHints.height(this.struct);
    }

    public int getMinWidth() {
        return XSizeHints.min_width(this.struct);
    }

    public int getMinHeight() {
        return XSizeHints.min_height(this.struct);
    }

    public int getMaxWidth() {
        return XSizeHints.max_width(this.struct);
    }

    public int getMaxHeight() {
        return XSizeHints.max_height(this.struct);
    }

    public int getWidthInc() {
        return XSizeHints.width_inc(this.struct);
    }

    public int getHeightInc() {
        return XSizeHints.height_inc(this.struct);
    }

    public int getMinAspectX() {
        return XSizeHints.min_aspectX(this.struct);
    }

    public int getMinAspectY() {
        return XSizeHints.min_aspectY(this.struct);
    }

    public int getMaxAspectX() {
        return XSizeHints.max_aspectX(this.struct);
    }

    public int getMaxAspectY() {
        return XSizeHints.max_aspectY(this.struct);
    }

    public int getBaseWidth() {
        return XSizeHints.base_width(this.struct);
    }

    public int getBaseHeight() {
        return XSizeHints.base_height(this.struct);
    }

    public int getWinGravity() {
        return XSizeHints.win_gravity(this.struct);
    }

    private static native int offsets(long var0);

    public static ByteBuffer malloc() {
        return BufferUtils.createByteBuffer(SIZEOF);
    }

    public static ByteBuffer malloc(long flags, int x, int y, int width, int height, int min_width, int min_height, int max_width, int max_height, int width_inc, int height_inc, int min_aspect_x, int min_aspect_y, int max_aspect_x, int max_aspect_y, int base_width, int base_height, int win_gravity) {
        ByteBuffer xsizehints = XSizeHints.malloc();
        XSizeHints.flags(xsizehints, flags);
        XSizeHints.x(xsizehints, x);
        XSizeHints.y(xsizehints, y);
        XSizeHints.width(xsizehints, width);
        XSizeHints.height(xsizehints, height);
        XSizeHints.min_width(xsizehints, min_width);
        XSizeHints.min_height(xsizehints, min_height);
        XSizeHints.max_width(xsizehints, max_width);
        XSizeHints.max_height(xsizehints, max_height);
        XSizeHints.width_inc(xsizehints, width_inc);
        XSizeHints.height_inc(xsizehints, height_inc);
        XSizeHints.min_aspectX(xsizehints, min_aspect_x);
        XSizeHints.min_aspectY(xsizehints, min_aspect_y);
        XSizeHints.max_aspectX(xsizehints, max_aspect_x);
        XSizeHints.max_aspectY(xsizehints, max_aspect_y);
        XSizeHints.base_width(xsizehints, base_width);
        XSizeHints.base_height(xsizehints, base_height);
        XSizeHints.win_gravity(xsizehints, win_gravity);
        return xsizehints;
    }

    public static void flags(ByteBuffer xsizehints, long flags) {
        PointerBuffer.put(xsizehints, xsizehints.position() + FLAGS, flags);
    }

    public static void x(ByteBuffer xsizehints, int x) {
        xsizehints.putInt(xsizehints.position() + X, x);
    }

    public static void y(ByteBuffer xsizehints, int y) {
        xsizehints.putInt(xsizehints.position() + Y, y);
    }

    public static void width(ByteBuffer xsizehints, int width) {
        xsizehints.putInt(xsizehints.position() + WIDTH, width);
    }

    public static void height(ByteBuffer xsizehints, int height) {
        xsizehints.putInt(xsizehints.position() + HEIGHT, height);
    }

    public static void min_width(ByteBuffer xsizehints, int min_width) {
        xsizehints.putInt(xsizehints.position() + MIN_WIDTH, min_width);
    }

    public static void min_height(ByteBuffer xsizehints, int min_height) {
        xsizehints.putInt(xsizehints.position() + MIN_HEIGHT, min_height);
    }

    public static void max_width(ByteBuffer xsizehints, int max_width) {
        xsizehints.putInt(xsizehints.position() + MAX_WIDTH, max_width);
    }

    public static void max_height(ByteBuffer xsizehints, int max_height) {
        xsizehints.putInt(xsizehints.position() + MAX_HEIGHT, max_height);
    }

    public static void width_inc(ByteBuffer xsizehints, int width_inc) {
        xsizehints.putInt(xsizehints.position() + WIDTH_INC, width_inc);
    }

    public static void height_inc(ByteBuffer xsizehints, int height_inc) {
        xsizehints.putInt(xsizehints.position() + HEIGHT_INC, height_inc);
    }

    public static void min_aspectX(ByteBuffer xsizehints, int x) {
        xsizehints.putInt(xsizehints.position() + MIN_ASPECT_X, x);
    }

    public static void min_aspectY(ByteBuffer xsizehints, int y) {
        xsizehints.putInt(xsizehints.position() + MIN_ASPECT_Y, y);
    }

    public static void max_aspectX(ByteBuffer xsizehints, int x) {
        xsizehints.putInt(xsizehints.position() + MAX_ASPECT_X, x);
    }

    public static void max_aspectY(ByteBuffer xsizehints, int y) {
        xsizehints.putInt(xsizehints.position() + MAX_ASPECT_Y, y);
    }

    public static void base_width(ByteBuffer xsizehints, int base_width) {
        xsizehints.putInt(xsizehints.position() + BASE_WIDTH, base_width);
    }

    public static void base_height(ByteBuffer xsizehints, int base_height) {
        xsizehints.putInt(xsizehints.position() + BASE_HEIGHT, base_height);
    }

    public static void win_gravity(ByteBuffer xsizehints, int win_gravity) {
        xsizehints.putInt(xsizehints.position() + WIN_GRAVITY, win_gravity);
    }

    public static long flags(ByteBuffer xsizehints) {
        return PointerBuffer.get(xsizehints, xsizehints.position() + FLAGS);
    }

    public static int x(ByteBuffer xsizehints) {
        return xsizehints.getInt(xsizehints.position() + X);
    }

    public static int y(ByteBuffer xsizehints) {
        return xsizehints.getInt(xsizehints.position() + Y);
    }

    public static int width(ByteBuffer xsizehints) {
        return xsizehints.getInt(xsizehints.position() + WIDTH);
    }

    public static int height(ByteBuffer xsizehints) {
        return xsizehints.getInt(xsizehints.position() + HEIGHT);
    }

    public static int min_width(ByteBuffer xsizehints) {
        return xsizehints.getInt(xsizehints.position() + MIN_WIDTH);
    }

    public static int min_height(ByteBuffer xsizehints) {
        return xsizehints.getInt(xsizehints.position() + MIN_HEIGHT);
    }

    public static int max_width(ByteBuffer xsizehints) {
        return xsizehints.getInt(xsizehints.position() + MAX_WIDTH);
    }

    public static int max_height(ByteBuffer xsizehints) {
        return xsizehints.getInt(xsizehints.position() + MAX_HEIGHT);
    }

    public static int width_inc(ByteBuffer xsizehints) {
        return xsizehints.getInt(xsizehints.position() + WIDTH_INC);
    }

    public static int height_inc(ByteBuffer xsizehints) {
        return xsizehints.getInt(xsizehints.position() + HEIGHT_INC);
    }

    public static int min_aspectX(ByteBuffer xsizehints) {
        return xsizehints.getInt(xsizehints.position() + MIN_ASPECT_X);
    }

    public static int min_aspectY(ByteBuffer xsizehints) {
        return xsizehints.getInt(xsizehints.position() + MIN_ASPECT_Y);
    }

    public static int max_aspectX(ByteBuffer xsizehints) {
        return xsizehints.getInt(xsizehints.position() + MAX_ASPECT_X);
    }

    public static int max_aspectY(ByteBuffer xsizehints) {
        return xsizehints.getInt(xsizehints.position() + MAX_ASPECT_Y);
    }

    public static int base_width(ByteBuffer xsizehints) {
        return xsizehints.getInt(xsizehints.position() + BASE_WIDTH);
    }

    public static int base_height(ByteBuffer xsizehints) {
        return xsizehints.getInt(xsizehints.position() + BASE_HEIGHT);
    }

    public static int win_gravity(ByteBuffer xsizehints) {
        return xsizehints.getInt(xsizehints.position() + WIN_GRAVITY);
    }

    static {
        IntBuffer offsets = BufferUtils.createIntBuffer(20);
        SIZEOF = XSizeHints.offsets(MemoryUtil.memAddress(offsets));
        FLAGS = offsets.get(0);
        X = offsets.get(1);
        Y = offsets.get(2);
        WIDTH = offsets.get(3);
        HEIGHT = offsets.get(4);
        MIN_WIDTH = offsets.get(5);
        MIN_HEIGHT = offsets.get(6);
        MAX_WIDTH = offsets.get(7);
        MAX_HEIGHT = offsets.get(8);
        WIDTH_INC = offsets.get(9);
        HEIGHT_INC = offsets.get(10);
        MIN_ASPECT = offsets.get(11);
        MIN_ASPECT_X = offsets.get(12);
        MIN_ASPECT_Y = offsets.get(13);
        MAX_ASPECT = offsets.get(14);
        MAX_ASPECT_X = offsets.get(15);
        MAX_ASPECT_Y = offsets.get(16);
        BASE_WIDTH = offsets.get(17);
        BASE_HEIGHT = offsets.get(18);
        WIN_GRAVITY = offsets.get(19);
    }
}

