/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.system.linux;

import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import org.lwjgl.BufferUtils;
import org.lwjgl.LWJGLUtil;
import org.lwjgl.Pointer;
import org.lwjgl.PointerBuffer;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryUtil;

public final class XSetWindowAttributes
implements Pointer {
    public static final int SIZEOF;
    public static final int BACKGROUND_PIXMAP;
    public static final int BACKGROUND_PIXEL;
    public static final int BORDER_PIXMAP;
    public static final int BORDER_PIXEL;
    public static final int BIT_GRAVITY;
    public static final int WIN_GRAVITY;
    public static final int BACKING_STORE;
    public static final int BACKING_PLANES;
    public static final int BACKING_PIXEL;
    public static final int SAVE_UNDER;
    public static final int EVENT_MASK;
    public static final int DO_NOT_PROPAGATE_MASK;
    public static final int OVERRIDE_REDIRECT;
    public static final int COLORMAP;
    public static final int CURSOR;
    private final ByteBuffer struct;

    public XSetWindowAttributes() {
        this(XSetWindowAttributes.malloc());
    }

    public XSetWindowAttributes(ByteBuffer struct) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkBuffer((Buffer)struct, SIZEOF);
        }
        this.struct = struct;
    }

    public ByteBuffer buffer() {
        return this.struct;
    }

    @Override
    public long getPointer() {
        return MemoryUtil.memAddress(this.struct);
    }

    public void setBackgroundPixmap(long background_pixmap) {
        XSetWindowAttributes.background_pixmap(this.struct, background_pixmap);
    }

    public void setBackgroundPixel(long background_pixel) {
        XSetWindowAttributes.background_pixel(this.struct, background_pixel);
    }

    public void setBorderPixmap(long border_pixmap) {
        XSetWindowAttributes.border_pixmap(this.struct, border_pixmap);
    }

    public void setBorderPixel(long border_pixel) {
        XSetWindowAttributes.border_pixel(this.struct, border_pixel);
    }

    public void setBitGravity(int bit_gravity) {
        XSetWindowAttributes.bit_gravity(this.struct, bit_gravity);
    }

    public void setWinGravity(int win_gravity) {
        XSetWindowAttributes.win_gravity(this.struct, win_gravity);
    }

    public void setBackingStore(int backing_store) {
        XSetWindowAttributes.backing_store(this.struct, backing_store);
    }

    public void setBackingPlanes(long backing_planes) {
        XSetWindowAttributes.backing_planes(this.struct, backing_planes);
    }

    public void setBackingPixel(long backing_pixel) {
        XSetWindowAttributes.backing_pixel(this.struct, backing_pixel);
    }

    public void setSaveUnder(int save_under) {
        XSetWindowAttributes.save_under(this.struct, save_under);
    }

    public void setEventMask(long event_mask) {
        XSetWindowAttributes.event_mask(this.struct, event_mask);
    }

    public void setDoNotPropagateMask(long do_not_propagate_mask) {
        XSetWindowAttributes.do_not_propagate_mask(this.struct, do_not_propagate_mask);
    }

    public void setOverrideRedirect(int override_redirect) {
        XSetWindowAttributes.override_redirect(this.struct, override_redirect);
    }

    public void setColormap(long colormap) {
        XSetWindowAttributes.colormap(this.struct, colormap);
    }

    public void setCursor(long cursor) {
        XSetWindowAttributes.cursor(this.struct, cursor);
    }

    public long getBackgroundPixmap() {
        return XSetWindowAttributes.background_pixmap(this.struct);
    }

    public long getBackgroundPixel() {
        return XSetWindowAttributes.background_pixel(this.struct);
    }

    public long getBorderPixmap() {
        return XSetWindowAttributes.border_pixmap(this.struct);
    }

    public long getBorderPixel() {
        return XSetWindowAttributes.border_pixel(this.struct);
    }

    public int getBitGravity() {
        return XSetWindowAttributes.bit_gravity(this.struct);
    }

    public int getWinGravity() {
        return XSetWindowAttributes.win_gravity(this.struct);
    }

    public int getBackingStore() {
        return XSetWindowAttributes.backing_store(this.struct);
    }

    public long getBackingPlanes() {
        return XSetWindowAttributes.backing_planes(this.struct);
    }

    public long getBackingPixel() {
        return XSetWindowAttributes.backing_pixel(this.struct);
    }

    public int getSaveUnder() {
        return XSetWindowAttributes.save_under(this.struct);
    }

    public long getEventMask() {
        return XSetWindowAttributes.event_mask(this.struct);
    }

    public long getDoNotPropagateMask() {
        return XSetWindowAttributes.do_not_propagate_mask(this.struct);
    }

    public int getOverrideRedirect() {
        return XSetWindowAttributes.override_redirect(this.struct);
    }

    public long getColormap() {
        return XSetWindowAttributes.colormap(this.struct);
    }

    public long getCursor() {
        return XSetWindowAttributes.cursor(this.struct);
    }

    private static native int offsets(long var0);

    public static ByteBuffer malloc() {
        return BufferUtils.createByteBuffer(SIZEOF);
    }

    public static ByteBuffer malloc(long background_pixmap, long background_pixel, long border_pixmap, long border_pixel, int bit_gravity, int win_gravity, int backing_store, long backing_planes, long backing_pixel, int save_under, long event_mask, long do_not_propagate_mask, int override_redirect, long colormap, long cursor) {
        ByteBuffer xsetwindowattributes = XSetWindowAttributes.malloc();
        XSetWindowAttributes.background_pixmap(xsetwindowattributes, background_pixmap);
        XSetWindowAttributes.background_pixel(xsetwindowattributes, background_pixel);
        XSetWindowAttributes.border_pixmap(xsetwindowattributes, border_pixmap);
        XSetWindowAttributes.border_pixel(xsetwindowattributes, border_pixel);
        XSetWindowAttributes.bit_gravity(xsetwindowattributes, bit_gravity);
        XSetWindowAttributes.win_gravity(xsetwindowattributes, win_gravity);
        XSetWindowAttributes.backing_store(xsetwindowattributes, backing_store);
        XSetWindowAttributes.backing_planes(xsetwindowattributes, backing_planes);
        XSetWindowAttributes.backing_pixel(xsetwindowattributes, backing_pixel);
        XSetWindowAttributes.save_under(xsetwindowattributes, save_under);
        XSetWindowAttributes.event_mask(xsetwindowattributes, event_mask);
        XSetWindowAttributes.do_not_propagate_mask(xsetwindowattributes, do_not_propagate_mask);
        XSetWindowAttributes.override_redirect(xsetwindowattributes, override_redirect);
        XSetWindowAttributes.colormap(xsetwindowattributes, colormap);
        XSetWindowAttributes.cursor(xsetwindowattributes, cursor);
        return xsetwindowattributes;
    }

    public static void background_pixmap(ByteBuffer xsetwindowattributes, long background_pixmap) {
        PointerBuffer.put(xsetwindowattributes, xsetwindowattributes.position() + BACKGROUND_PIXMAP, background_pixmap);
    }

    public static void background_pixel(ByteBuffer xsetwindowattributes, long background_pixel) {
        PointerBuffer.put(xsetwindowattributes, xsetwindowattributes.position() + BACKGROUND_PIXEL, background_pixel);
    }

    public static void border_pixmap(ByteBuffer xsetwindowattributes, long border_pixmap) {
        PointerBuffer.put(xsetwindowattributes, xsetwindowattributes.position() + BORDER_PIXMAP, border_pixmap);
    }

    public static void border_pixel(ByteBuffer xsetwindowattributes, long border_pixel) {
        PointerBuffer.put(xsetwindowattributes, xsetwindowattributes.position() + BORDER_PIXEL, border_pixel);
    }

    public static void bit_gravity(ByteBuffer xsetwindowattributes, int bit_gravity) {
        xsetwindowattributes.putInt(xsetwindowattributes.position() + BIT_GRAVITY, bit_gravity);
    }

    public static void win_gravity(ByteBuffer xsetwindowattributes, int win_gravity) {
        xsetwindowattributes.putInt(xsetwindowattributes.position() + WIN_GRAVITY, win_gravity);
    }

    public static void backing_store(ByteBuffer xsetwindowattributes, int backing_store) {
        xsetwindowattributes.putInt(xsetwindowattributes.position() + BACKING_STORE, backing_store);
    }

    public static void backing_planes(ByteBuffer xsetwindowattributes, long backing_planes) {
        PointerBuffer.put(xsetwindowattributes, xsetwindowattributes.position() + BACKING_PLANES, backing_planes);
    }

    public static void backing_pixel(ByteBuffer xsetwindowattributes, long backing_pixel) {
        PointerBuffer.put(xsetwindowattributes, xsetwindowattributes.position() + BACKING_PIXEL, backing_pixel);
    }

    public static void save_under(ByteBuffer xsetwindowattributes, int save_under) {
        xsetwindowattributes.putInt(xsetwindowattributes.position() + SAVE_UNDER, save_under);
    }

    public static void event_mask(ByteBuffer xsetwindowattributes, long event_mask) {
        PointerBuffer.put(xsetwindowattributes, xsetwindowattributes.position() + EVENT_MASK, event_mask);
    }

    public static void do_not_propagate_mask(ByteBuffer xsetwindowattributes, long do_not_propagate_mask) {
        PointerBuffer.put(xsetwindowattributes, xsetwindowattributes.position() + DO_NOT_PROPAGATE_MASK, do_not_propagate_mask);
    }

    public static void override_redirect(ByteBuffer xsetwindowattributes, int override_redirect) {
        xsetwindowattributes.putInt(xsetwindowattributes.position() + OVERRIDE_REDIRECT, override_redirect);
    }

    public static void colormap(ByteBuffer xsetwindowattributes, long colormap) {
        PointerBuffer.put(xsetwindowattributes, xsetwindowattributes.position() + COLORMAP, colormap);
    }

    public static void cursor(ByteBuffer xsetwindowattributes, long cursor) {
        PointerBuffer.put(xsetwindowattributes, xsetwindowattributes.position() + CURSOR, cursor);
    }

    public static long background_pixmap(ByteBuffer xsetwindowattributes) {
        return PointerBuffer.get(xsetwindowattributes, xsetwindowattributes.position() + BACKGROUND_PIXMAP);
    }

    public static long background_pixel(ByteBuffer xsetwindowattributes) {
        return PointerBuffer.get(xsetwindowattributes, xsetwindowattributes.position() + BACKGROUND_PIXEL);
    }

    public static long border_pixmap(ByteBuffer xsetwindowattributes) {
        return PointerBuffer.get(xsetwindowattributes, xsetwindowattributes.position() + BORDER_PIXMAP);
    }

    public static long border_pixel(ByteBuffer xsetwindowattributes) {
        return PointerBuffer.get(xsetwindowattributes, xsetwindowattributes.position() + BORDER_PIXEL);
    }

    public static int bit_gravity(ByteBuffer xsetwindowattributes) {
        return xsetwindowattributes.getInt(xsetwindowattributes.position() + BIT_GRAVITY);
    }

    public static int win_gravity(ByteBuffer xsetwindowattributes) {
        return xsetwindowattributes.getInt(xsetwindowattributes.position() + WIN_GRAVITY);
    }

    public static int backing_store(ByteBuffer xsetwindowattributes) {
        return xsetwindowattributes.getInt(xsetwindowattributes.position() + BACKING_STORE);
    }

    public static long backing_planes(ByteBuffer xsetwindowattributes) {
        return PointerBuffer.get(xsetwindowattributes, xsetwindowattributes.position() + BACKING_PLANES);
    }

    public static long backing_pixel(ByteBuffer xsetwindowattributes) {
        return PointerBuffer.get(xsetwindowattributes, xsetwindowattributes.position() + BACKING_PIXEL);
    }

    public static int save_under(ByteBuffer xsetwindowattributes) {
        return xsetwindowattributes.getInt(xsetwindowattributes.position() + SAVE_UNDER);
    }

    public static long event_mask(ByteBuffer xsetwindowattributes) {
        return PointerBuffer.get(xsetwindowattributes, xsetwindowattributes.position() + EVENT_MASK);
    }

    public static long do_not_propagate_mask(ByteBuffer xsetwindowattributes) {
        return PointerBuffer.get(xsetwindowattributes, xsetwindowattributes.position() + DO_NOT_PROPAGATE_MASK);
    }

    public static int override_redirect(ByteBuffer xsetwindowattributes) {
        return xsetwindowattributes.getInt(xsetwindowattributes.position() + OVERRIDE_REDIRECT);
    }

    public static long colormap(ByteBuffer xsetwindowattributes) {
        return PointerBuffer.get(xsetwindowattributes, xsetwindowattributes.position() + COLORMAP);
    }

    public static long cursor(ByteBuffer xsetwindowattributes) {
        return PointerBuffer.get(xsetwindowattributes, xsetwindowattributes.position() + CURSOR);
    }

    static {
        IntBuffer offsets = BufferUtils.createIntBuffer(15);
        SIZEOF = XSetWindowAttributes.offsets(MemoryUtil.memAddress(offsets));
        BACKGROUND_PIXMAP = offsets.get(0);
        BACKGROUND_PIXEL = offsets.get(1);
        BORDER_PIXMAP = offsets.get(2);
        BORDER_PIXEL = offsets.get(3);
        BIT_GRAVITY = offsets.get(4);
        WIN_GRAVITY = offsets.get(5);
        BACKING_STORE = offsets.get(6);
        BACKING_PLANES = offsets.get(7);
        BACKING_PIXEL = offsets.get(8);
        SAVE_UNDER = offsets.get(9);
        EVENT_MASK = offsets.get(10);
        DO_NOT_PROPAGATE_MASK = offsets.get(11);
        OVERRIDE_REDIRECT = offsets.get(12);
        COLORMAP = offsets.get(13);
        CURSOR = offsets.get(14);
    }
}

