/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.system.linux;

import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import org.lwjgl.BufferUtils;
import org.lwjgl.LWJGLUtil;
import org.lwjgl.Pointer;
import org.lwjgl.PointerBuffer;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryUtil;

public final class XRRCrtcInfo
implements Pointer {
    public static final int SIZEOF;
    public static final int TIMESTAMP;
    public static final int X;
    public static final int Y;
    public static final int WIDTH;
    public static final int HEIGHT;
    public static final int MODE;
    public static final int ROTATION;
    public static final int NOUTPUT;
    public static final int OUTPUTS;
    public static final int ROTATIONS;
    public static final int NPOSSIBLE;
    public static final int POSSIBLE;
    private final ByteBuffer struct;

    public XRRCrtcInfo() {
        this(XRRCrtcInfo.malloc());
    }

    public XRRCrtcInfo(ByteBuffer struct) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkBuffer((Buffer)struct, SIZEOF);
        }
        this.struct = struct;
    }

    public ByteBuffer buffer() {
        return this.struct;
    }

    @Override
    public long getPointer() {
        return MemoryUtil.memAddress(this.struct);
    }

    public void setTimestamp(long timestamp) {
        XRRCrtcInfo.timestamp(this.struct, timestamp);
    }

    public void setX(int x) {
        XRRCrtcInfo.x(this.struct, x);
    }

    public void setY(int y) {
        XRRCrtcInfo.y(this.struct, y);
    }

    public void setWidth(int width) {
        XRRCrtcInfo.width(this.struct, width);
    }

    public void setHeight(int height) {
        XRRCrtcInfo.height(this.struct, height);
    }

    public void setMode(long mode) {
        XRRCrtcInfo.mode(this.struct, mode);
    }

    public void setRotation(int rotation) {
        XRRCrtcInfo.rotation(this.struct, rotation);
    }

    public void setNoutput(int noutput) {
        XRRCrtcInfo.noutput(this.struct, noutput);
    }

    public void setOutputs(long outputs) {
        XRRCrtcInfo.outputs(this.struct, outputs);
    }

    public void setOutputs(ByteBuffer outputs) {
        XRRCrtcInfo.outputs(this.struct, outputs);
    }

    public void setRotations(int rotations) {
        XRRCrtcInfo.rotations(this.struct, rotations);
    }

    public void setNpossible(int npossible) {
        XRRCrtcInfo.npossible(this.struct, npossible);
    }

    public void setPossible(long possible) {
        XRRCrtcInfo.possible(this.struct, possible);
    }

    public void setPossible(ByteBuffer possible) {
        XRRCrtcInfo.possible(this.struct, possible);
    }

    public long getTimestamp() {
        return XRRCrtcInfo.timestamp(this.struct);
    }

    public int getX() {
        return XRRCrtcInfo.x(this.struct);
    }

    public int getY() {
        return XRRCrtcInfo.y(this.struct);
    }

    public int getWidth() {
        return XRRCrtcInfo.width(this.struct);
    }

    public int getHeight() {
        return XRRCrtcInfo.height(this.struct);
    }

    public long getMode() {
        return XRRCrtcInfo.mode(this.struct);
    }

    public int getRotation() {
        return XRRCrtcInfo.rotation(this.struct);
    }

    public int getNoutput() {
        return XRRCrtcInfo.noutput(this.struct);
    }

    public long getOutputs() {
        return XRRCrtcInfo.outputs(this.struct);
    }

    public ByteBuffer getOutputs(int byteLen) {
        return XRRCrtcInfo.outputs(this.struct, byteLen);
    }

    public int getRotations() {
        return XRRCrtcInfo.rotations(this.struct);
    }

    public int getNpossible() {
        return XRRCrtcInfo.npossible(this.struct);
    }

    public long getPossible() {
        return XRRCrtcInfo.possible(this.struct);
    }

    public ByteBuffer getPossible(int byteLen) {
        return XRRCrtcInfo.possible(this.struct, byteLen);
    }

    private static native int offsets(long var0);

    public static ByteBuffer malloc() {
        return BufferUtils.createByteBuffer(SIZEOF);
    }

    public static ByteBuffer malloc(long timestamp, int x, int y, int width, int height, long mode, int rotation, int noutput, ByteBuffer outputs, int rotations, int npossible, ByteBuffer possible) {
        ByteBuffer xrrcrtcinfo = XRRCrtcInfo.malloc();
        XRRCrtcInfo.timestamp(xrrcrtcinfo, timestamp);
        XRRCrtcInfo.x(xrrcrtcinfo, x);
        XRRCrtcInfo.y(xrrcrtcinfo, y);
        XRRCrtcInfo.width(xrrcrtcinfo, width);
        XRRCrtcInfo.height(xrrcrtcinfo, height);
        XRRCrtcInfo.mode(xrrcrtcinfo, mode);
        XRRCrtcInfo.rotation(xrrcrtcinfo, rotation);
        XRRCrtcInfo.noutput(xrrcrtcinfo, noutput);
        XRRCrtcInfo.outputs(xrrcrtcinfo, outputs);
        XRRCrtcInfo.rotations(xrrcrtcinfo, rotations);
        XRRCrtcInfo.npossible(xrrcrtcinfo, npossible);
        XRRCrtcInfo.possible(xrrcrtcinfo, possible);
        return xrrcrtcinfo;
    }

    public static void timestamp(ByteBuffer xrrcrtcinfo, long timestamp) {
        PointerBuffer.put(xrrcrtcinfo, xrrcrtcinfo.position() + TIMESTAMP, timestamp);
    }

    public static void x(ByteBuffer xrrcrtcinfo, int x) {
        xrrcrtcinfo.putInt(xrrcrtcinfo.position() + X, x);
    }

    public static void y(ByteBuffer xrrcrtcinfo, int y) {
        xrrcrtcinfo.putInt(xrrcrtcinfo.position() + Y, y);
    }

    public static void width(ByteBuffer xrrcrtcinfo, int width) {
        xrrcrtcinfo.putInt(xrrcrtcinfo.position() + WIDTH, width);
    }

    public static void height(ByteBuffer xrrcrtcinfo, int height) {
        xrrcrtcinfo.putInt(xrrcrtcinfo.position() + HEIGHT, height);
    }

    public static void mode(ByteBuffer xrrcrtcinfo, long mode) {
        PointerBuffer.put(xrrcrtcinfo, xrrcrtcinfo.position() + MODE, mode);
    }

    public static void rotation(ByteBuffer xrrcrtcinfo, int rotation) {
        xrrcrtcinfo.putShort(xrrcrtcinfo.position() + ROTATION, (short)rotation);
    }

    public static void noutput(ByteBuffer xrrcrtcinfo, int noutput) {
        xrrcrtcinfo.putInt(xrrcrtcinfo.position() + NOUTPUT, noutput);
    }

    public static void outputs(ByteBuffer xrrcrtcinfo, long outputs) {
        PointerBuffer.put(xrrcrtcinfo, xrrcrtcinfo.position() + OUTPUTS, outputs);
    }

    public static void outputs(ByteBuffer xrrcrtcinfo, ByteBuffer outputs) {
        XRRCrtcInfo.outputs(xrrcrtcinfo, MemoryUtil.memAddressSafe(outputs));
    }

    public static void rotations(ByteBuffer xrrcrtcinfo, int rotations) {
        xrrcrtcinfo.putShort(xrrcrtcinfo.position() + ROTATIONS, (short)rotations);
    }

    public static void npossible(ByteBuffer xrrcrtcinfo, int npossible) {
        xrrcrtcinfo.putInt(xrrcrtcinfo.position() + NPOSSIBLE, npossible);
    }

    public static void possible(ByteBuffer xrrcrtcinfo, long possible) {
        PointerBuffer.put(xrrcrtcinfo, xrrcrtcinfo.position() + POSSIBLE, possible);
    }

    public static void possible(ByteBuffer xrrcrtcinfo, ByteBuffer possible) {
        XRRCrtcInfo.possible(xrrcrtcinfo, MemoryUtil.memAddressSafe(possible));
    }

    public static long timestamp(ByteBuffer xrrcrtcinfo) {
        return PointerBuffer.get(xrrcrtcinfo, xrrcrtcinfo.position() + TIMESTAMP);
    }

    public static int x(ByteBuffer xrrcrtcinfo) {
        return xrrcrtcinfo.getInt(xrrcrtcinfo.position() + X);
    }

    public static int y(ByteBuffer xrrcrtcinfo) {
        return xrrcrtcinfo.getInt(xrrcrtcinfo.position() + Y);
    }

    public static int width(ByteBuffer xrrcrtcinfo) {
        return xrrcrtcinfo.getInt(xrrcrtcinfo.position() + WIDTH);
    }

    public static int height(ByteBuffer xrrcrtcinfo) {
        return xrrcrtcinfo.getInt(xrrcrtcinfo.position() + HEIGHT);
    }

    public static long mode(ByteBuffer xrrcrtcinfo) {
        return PointerBuffer.get(xrrcrtcinfo, xrrcrtcinfo.position() + MODE);
    }

    public static int rotation(ByteBuffer xrrcrtcinfo) {
        return xrrcrtcinfo.getShort(xrrcrtcinfo.position() + ROTATION) & 0xFFFF;
    }

    public static int noutput(ByteBuffer xrrcrtcinfo) {
        return xrrcrtcinfo.getInt(xrrcrtcinfo.position() + NOUTPUT);
    }

    public static long outputs(ByteBuffer xrrcrtcinfo) {
        return PointerBuffer.get(xrrcrtcinfo, xrrcrtcinfo.position() + OUTPUTS);
    }

    public static ByteBuffer outputs(ByteBuffer xrrcrtcinfo, int byteLen) {
        return MemoryUtil.memByteBuffer(XRRCrtcInfo.outputs(xrrcrtcinfo), byteLen);
    }

    public static int rotations(ByteBuffer xrrcrtcinfo) {
        return xrrcrtcinfo.getShort(xrrcrtcinfo.position() + ROTATIONS) & 0xFFFF;
    }

    public static int npossible(ByteBuffer xrrcrtcinfo) {
        return xrrcrtcinfo.getInt(xrrcrtcinfo.position() + NPOSSIBLE);
    }

    public static long possible(ByteBuffer xrrcrtcinfo) {
        return PointerBuffer.get(xrrcrtcinfo, xrrcrtcinfo.position() + POSSIBLE);
    }

    public static ByteBuffer possible(ByteBuffer xrrcrtcinfo, int byteLen) {
        return MemoryUtil.memByteBuffer(XRRCrtcInfo.possible(xrrcrtcinfo), byteLen);
    }

    static {
        IntBuffer offsets = BufferUtils.createIntBuffer(12);
        SIZEOF = XRRCrtcInfo.offsets(MemoryUtil.memAddress(offsets));
        TIMESTAMP = offsets.get(0);
        X = offsets.get(1);
        Y = offsets.get(2);
        WIDTH = offsets.get(3);
        HEIGHT = offsets.get(4);
        MODE = offsets.get(5);
        ROTATION = offsets.get(6);
        NOUTPUT = offsets.get(7);
        OUTPUTS = offsets.get(8);
        ROTATIONS = offsets.get(9);
        NPOSSIBLE = offsets.get(10);
        POSSIBLE = offsets.get(11);
    }
}

