/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.system.linux;

import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import org.lwjgl.BufferUtils;
import org.lwjgl.LWJGLUtil;
import org.lwjgl.Pointer;
import org.lwjgl.PointerBuffer;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.linux.XAnyEvent;
import org.lwjgl.system.linux.XButtonEvent;
import org.lwjgl.system.linux.XClientMessageEvent;
import org.lwjgl.system.linux.XConfigureEvent;
import org.lwjgl.system.linux.XErrorEvent;
import org.lwjgl.system.linux.XGenericEventCookie;
import org.lwjgl.system.linux.XKeyEvent;
import org.lwjgl.system.linux.XMotionEvent;
import org.lwjgl.system.linux.XPropertyEvent;
import org.lwjgl.system.linux.XSelectionEvent;
import org.lwjgl.system.linux.XSelectionRequestEvent;

public final class XEvent
implements Pointer {
    public static final int SIZEOF;
    public static final int TYPE;
    public static final int XANY;
    public static final int XKEY;
    public static final int XBUTTON;
    public static final int XMOTION;
    public static final int XCONFIGURE;
    public static final int XPROPERTY;
    public static final int XSELECTIONREQUEST;
    public static final int XSELECTION;
    public static final int XCLIENT;
    public static final int XERROR;
    public static final int XCOOKIE;
    private final ByteBuffer struct;

    public XEvent() {
        this(XEvent.malloc());
    }

    public XEvent(ByteBuffer struct) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkBuffer((Buffer)struct, SIZEOF);
        }
        this.struct = struct;
    }

    public ByteBuffer buffer() {
        return this.struct;
    }

    @Override
    public long getPointer() {
        return MemoryUtil.memAddress(this.struct);
    }

    public void setType(int type) {
        XEvent.type(this.struct, type);
    }

    public void setXany(ByteBuffer xany) {
        XEvent.xanySet(this.struct, xany);
    }

    public void setXanyType(int type) {
        XEvent.xanyType(this.struct, type);
    }

    public void setXanySerial(long serial) {
        XEvent.xanySerial(this.struct, serial);
    }

    public void setXanySendEvent(int send_event) {
        XEvent.xanySend_event(this.struct, send_event);
    }

    public void setXanyDisplay(long display) {
        XEvent.xanyDisplay(this.struct, display);
    }

    public void setXanyWindow(long window) {
        XEvent.xanyWindow(this.struct, window);
    }

    public void setXkey(ByteBuffer xkey) {
        XEvent.xkeySet(this.struct, xkey);
    }

    public void setXkeyType(int type) {
        XEvent.xkeyType(this.struct, type);
    }

    public void setXkeySerial(long serial) {
        XEvent.xkeySerial(this.struct, serial);
    }

    public void setXkeySendEvent(int send_event) {
        XEvent.xkeySend_event(this.struct, send_event);
    }

    public void setXkeyDisplay(long display) {
        XEvent.xkeyDisplay(this.struct, display);
    }

    public void setXkeyWindow(long window) {
        XEvent.xkeyWindow(this.struct, window);
    }

    public void setXkeyRoot(long root) {
        XEvent.xkeyRoot(this.struct, root);
    }

    public void setXkeySubwindow(long subwindow) {
        XEvent.xkeySubwindow(this.struct, subwindow);
    }

    public void setXkeyTime(long time) {
        XEvent.xkeyTime(this.struct, time);
    }

    public void setXkeyX(int x) {
        XEvent.xkeyX(this.struct, x);
    }

    public void setXkeyY(int y) {
        XEvent.xkeyY(this.struct, y);
    }

    public void setXkeyXRoot(int x_root) {
        XEvent.xkeyX_root(this.struct, x_root);
    }

    public void setXkeyYRoot(int y_root) {
        XEvent.xkeyY_root(this.struct, y_root);
    }

    public void setXkeyState(int state) {
        XEvent.xkeyState(this.struct, state);
    }

    public void setXkeyKeycode(int keycode) {
        XEvent.xkeyKeycode(this.struct, keycode);
    }

    public void setXkeySameScreen(int same_screen) {
        XEvent.xkeySame_screen(this.struct, same_screen);
    }

    public void setXbutton(ByteBuffer xbutton) {
        XEvent.xbuttonSet(this.struct, xbutton);
    }

    public void setXbuttonType(int type) {
        XEvent.xbuttonType(this.struct, type);
    }

    public void setXbuttonSerial(long serial) {
        XEvent.xbuttonSerial(this.struct, serial);
    }

    public void setXbuttonSendEvent(int send_event) {
        XEvent.xbuttonSend_event(this.struct, send_event);
    }

    public void setXbuttonDisplay(long display) {
        XEvent.xbuttonDisplay(this.struct, display);
    }

    public void setXbuttonWindow(long window) {
        XEvent.xbuttonWindow(this.struct, window);
    }

    public void setXbuttonRoot(long root) {
        XEvent.xbuttonRoot(this.struct, root);
    }

    public void setXbuttonSubwindow(long subwindow) {
        XEvent.xbuttonSubwindow(this.struct, subwindow);
    }

    public void setXbuttonTime(long time) {
        XEvent.xbuttonTime(this.struct, time);
    }

    public void setXbuttonX(int x) {
        XEvent.xbuttonX(this.struct, x);
    }

    public void setXbuttonY(int y) {
        XEvent.xbuttonY(this.struct, y);
    }

    public void setXbuttonXRoot(int x_root) {
        XEvent.xbuttonX_root(this.struct, x_root);
    }

    public void setXbuttonYRoot(int y_root) {
        XEvent.xbuttonY_root(this.struct, y_root);
    }

    public void setXbuttonState(int state) {
        XEvent.xbuttonState(this.struct, state);
    }

    public void setXbuttonButton(int button) {
        XEvent.xbuttonButton(this.struct, button);
    }

    public void setXbuttonSameScreen(int same_screen) {
        XEvent.xbuttonSame_screen(this.struct, same_screen);
    }

    public void setXmotion(ByteBuffer xmotion) {
        XEvent.xmotionSet(this.struct, xmotion);
    }

    public void setXmotionType(int type) {
        XEvent.xmotionType(this.struct, type);
    }

    public void setXmotionSerial(long serial) {
        XEvent.xmotionSerial(this.struct, serial);
    }

    public void setXmotionSendEvent(int send_event) {
        XEvent.xmotionSend_event(this.struct, send_event);
    }

    public void setXmotionDisplay(long display) {
        XEvent.xmotionDisplay(this.struct, display);
    }

    public void setXmotionWindow(long window) {
        XEvent.xmotionWindow(this.struct, window);
    }

    public void setXmotionRoot(long root) {
        XEvent.xmotionRoot(this.struct, root);
    }

    public void setXmotionSubwindow(long subwindow) {
        XEvent.xmotionSubwindow(this.struct, subwindow);
    }

    public void setXmotionTime(long time) {
        XEvent.xmotionTime(this.struct, time);
    }

    public void setXmotionX(int x) {
        XEvent.xmotionX(this.struct, x);
    }

    public void setXmotionY(int y) {
        XEvent.xmotionY(this.struct, y);
    }

    public void setXmotionXRoot(int x_root) {
        XEvent.xmotionX_root(this.struct, x_root);
    }

    public void setXmotionYRoot(int y_root) {
        XEvent.xmotionY_root(this.struct, y_root);
    }

    public void setXmotionState(int state) {
        XEvent.xmotionState(this.struct, state);
    }

    public void setXmotionIsHint(int is_hint) {
        XEvent.xmotionIs_hint(this.struct, is_hint);
    }

    public void setXmotionSameScreen(int same_screen) {
        XEvent.xmotionSame_screen(this.struct, same_screen);
    }

    public void setXconfigure(ByteBuffer xconfigure) {
        XEvent.xconfigureSet(this.struct, xconfigure);
    }

    public void setXconfigureType(int type) {
        XEvent.xconfigureType(this.struct, type);
    }

    public void setXconfigureSerial(long serial) {
        XEvent.xconfigureSerial(this.struct, serial);
    }

    public void setXconfigureSendEvent(int send_event) {
        XEvent.xconfigureSend_event(this.struct, send_event);
    }

    public void setXconfigureDisplay(long display) {
        XEvent.xconfigureDisplay(this.struct, display);
    }

    public void setXconfigureEvent(long event) {
        XEvent.xconfigureEvent(this.struct, event);
    }

    public void setXconfigureWindow(long window) {
        XEvent.xconfigureWindow(this.struct, window);
    }

    public void setXconfigureX(int x) {
        XEvent.xconfigureX(this.struct, x);
    }

    public void setXconfigureY(int y) {
        XEvent.xconfigureY(this.struct, y);
    }

    public void setXconfigureWidth(int width) {
        XEvent.xconfigureWidth(this.struct, width);
    }

    public void setXconfigureHeight(int height) {
        XEvent.xconfigureHeight(this.struct, height);
    }

    public void setXconfigureBorderWidth(int border_width) {
        XEvent.xconfigureBorder_width(this.struct, border_width);
    }

    public void setXconfigureAbove(long above) {
        XEvent.xconfigureAbove(this.struct, above);
    }

    public void setXconfigureOverrideRedirect(int override_redirect) {
        XEvent.xconfigureOverride_redirect(this.struct, override_redirect);
    }

    public void setXproperty(ByteBuffer xproperty) {
        XEvent.xpropertySet(this.struct, xproperty);
    }

    public void setXpropertyType(int type) {
        XEvent.xpropertyType(this.struct, type);
    }

    public void setXpropertySerial(long serial) {
        XEvent.xpropertySerial(this.struct, serial);
    }

    public void setXpropertySendEvent(int send_event) {
        XEvent.xpropertySend_event(this.struct, send_event);
    }

    public void setXpropertyDisplay(long display) {
        XEvent.xpropertyDisplay(this.struct, display);
    }

    public void setXpropertyWindow(long window) {
        XEvent.xpropertyWindow(this.struct, window);
    }

    public void setXpropertyAtom(long atom) {
        XEvent.xpropertyAtom(this.struct, atom);
    }

    public void setXpropertyTime(long time) {
        XEvent.xpropertyTime(this.struct, time);
    }

    public void setXpropertyState(int state) {
        XEvent.xpropertyState(this.struct, state);
    }

    public void setXselectionrequest(ByteBuffer xselectionrequest) {
        XEvent.xselectionrequestSet(this.struct, xselectionrequest);
    }

    public void setXselectionrequestType(int type) {
        XEvent.xselectionrequestType(this.struct, type);
    }

    public void setXselectionrequestSerial(long serial) {
        XEvent.xselectionrequestSerial(this.struct, serial);
    }

    public void setXselectionrequestSendEvent(int send_event) {
        XEvent.xselectionrequestSend_event(this.struct, send_event);
    }

    public void setXselectionrequestDisplay(long display) {
        XEvent.xselectionrequestDisplay(this.struct, display);
    }

    public void setXselectionrequestOwner(long owner) {
        XEvent.xselectionrequestOwner(this.struct, owner);
    }

    public void setXselectionrequestRequestor(long requestor) {
        XEvent.xselectionrequestRequestor(this.struct, requestor);
    }

    public void setXselectionrequestSelection(long selection) {
        XEvent.xselectionrequestSelection(this.struct, selection);
    }

    public void setXselectionrequestTarget(long target) {
        XEvent.xselectionrequestTarget(this.struct, target);
    }

    public void setXselectionrequestProperty(long property) {
        XEvent.xselectionrequestProperty(this.struct, property);
    }

    public void setXselectionrequestTime(long time) {
        XEvent.xselectionrequestTime(this.struct, time);
    }

    public void setXselection(ByteBuffer xselection) {
        XEvent.xselectionSet(this.struct, xselection);
    }

    public void setXselectionType(int type) {
        XEvent.xselectionType(this.struct, type);
    }

    public void setXselectionSerial(long serial) {
        XEvent.xselectionSerial(this.struct, serial);
    }

    public void setXselectionSendEvent(int send_event) {
        XEvent.xselectionSend_event(this.struct, send_event);
    }

    public void setXselectionDisplay(long display) {
        XEvent.xselectionDisplay(this.struct, display);
    }

    public void setXselectionRequestor(long requestor) {
        XEvent.xselectionRequestor(this.struct, requestor);
    }

    public void setXselectionSelection(long selection) {
        XEvent.xselectionSelection(this.struct, selection);
    }

    public void setXselectionTarget(long target) {
        XEvent.xselectionTarget(this.struct, target);
    }

    public void setXselectionProperty(long property) {
        XEvent.xselectionProperty(this.struct, property);
    }

    public void setXselectionTime(long time) {
        XEvent.xselectionTime(this.struct, time);
    }

    public void setXclient(ByteBuffer xclient) {
        XEvent.xclientSet(this.struct, xclient);
    }

    public void setXclientType(int type) {
        XEvent.xclientType(this.struct, type);
    }

    public void setXclientSerial(long serial) {
        XEvent.xclientSerial(this.struct, serial);
    }

    public void setXclientSendEvent(int send_event) {
        XEvent.xclientSend_event(this.struct, send_event);
    }

    public void setXclientDisplay(long display) {
        XEvent.xclientDisplay(this.struct, display);
    }

    public void setXclientWindow(long window) {
        XEvent.xclientWindow(this.struct, window);
    }

    public void setXclientMessageType(long message_type) {
        XEvent.xclientMessage_type(this.struct, message_type);
    }

    public void setXclientFormat(int format) {
        XEvent.xclientFormat(this.struct, format);
    }

    public void setXclientDataB(ByteBuffer b) {
        XEvent.xclientDataBSet(this.struct, b);
    }

    public void setXclientDataB(int index, byte b) {
        XEvent.xclientDataB(this.struct, index, b);
    }

    public void setXclientDataS(ByteBuffer s) {
        XEvent.xclientDataSSet(this.struct, s);
    }

    public void setXclientDataS(int index, short s) {
        XEvent.xclientDataS(this.struct, index, s);
    }

    public void setXclientDataL(ByteBuffer l) {
        XEvent.xclientDataLSet(this.struct, l);
    }

    public void setXclientDataL(int index, long l) {
        XEvent.xclientDataL(this.struct, index, l);
    }

    public void setXerror(ByteBuffer xerror) {
        XEvent.xerrorSet(this.struct, xerror);
    }

    public void setXerrorType(int type) {
        XEvent.xerrorType(this.struct, type);
    }

    public void setXerrorDisplay(long display) {
        XEvent.xerrorDisplay(this.struct, display);
    }

    public void setXerrorSerial(long serial) {
        XEvent.xerrorSerial(this.struct, serial);
    }

    public void setXerrorErrorCode(int error_code) {
        XEvent.xerrorError_code(this.struct, error_code);
    }

    public void setXerrorRequestCode(int request_code) {
        XEvent.xerrorRequest_code(this.struct, request_code);
    }

    public void setXerrorMinorCode(int minor_code) {
        XEvent.xerrorMinor_code(this.struct, minor_code);
    }

    public void setXerrorResourceid(long resourceid) {
        XEvent.xerrorResourceid(this.struct, resourceid);
    }

    public void setXcookie(ByteBuffer xcookie) {
        XEvent.xcookieSet(this.struct, xcookie);
    }

    public void setXcookieType(int type) {
        XEvent.xcookieType(this.struct, type);
    }

    public void setXcookieSerial(long serial) {
        XEvent.xcookieSerial(this.struct, serial);
    }

    public void setXcookieSendEvent(int send_event) {
        XEvent.xcookieSend_event(this.struct, send_event);
    }

    public void setXcookieDisplay(long display) {
        XEvent.xcookieDisplay(this.struct, display);
    }

    public void setXcookieExtension(int extension) {
        XEvent.xcookieExtension(this.struct, extension);
    }

    public void setXcookieEvtype(int evtype) {
        XEvent.xcookieEvtype(this.struct, evtype);
    }

    public void setXcookieCookie(int cookie) {
        XEvent.xcookieCookie(this.struct, cookie);
    }

    public void setXcookieData(long data) {
        XEvent.xcookieData(this.struct, data);
    }

    public void setXcookieData(ByteBuffer data) {
        XEvent.xcookieData(this.struct, data);
    }

    public int getType() {
        return XEvent.type(this.struct);
    }

    public void getXany(ByteBuffer xany) {
        XEvent.xanyGet(this.struct, xany);
    }

    public int getXanyType() {
        return XEvent.xanyType(this.struct);
    }

    public long getXanySerial() {
        return XEvent.xanySerial(this.struct);
    }

    public int getXanySendEvent() {
        return XEvent.xanySend_event(this.struct);
    }

    public long getXanyDisplay() {
        return XEvent.xanyDisplay(this.struct);
    }

    public long getXanyWindow() {
        return XEvent.xanyWindow(this.struct);
    }

    public void getXkey(ByteBuffer xkey) {
        XEvent.xkeyGet(this.struct, xkey);
    }

    public int getXkeyType() {
        return XEvent.xkeyType(this.struct);
    }

    public long getXkeySerial() {
        return XEvent.xkeySerial(this.struct);
    }

    public int getXkeySendEvent() {
        return XEvent.xkeySend_event(this.struct);
    }

    public long getXkeyDisplay() {
        return XEvent.xkeyDisplay(this.struct);
    }

    public long getXkeyWindow() {
        return XEvent.xkeyWindow(this.struct);
    }

    public long getXkeyRoot() {
        return XEvent.xkeyRoot(this.struct);
    }

    public long getXkeySubwindow() {
        return XEvent.xkeySubwindow(this.struct);
    }

    public long getXkeyTime() {
        return XEvent.xkeyTime(this.struct);
    }

    public int getXkeyX() {
        return XEvent.xkeyX(this.struct);
    }

    public int getXkeyY() {
        return XEvent.xkeyY(this.struct);
    }

    public int getXkeyXRoot() {
        return XEvent.xkeyX_root(this.struct);
    }

    public int getXkeyYRoot() {
        return XEvent.xkeyY_root(this.struct);
    }

    public int getXkeyState() {
        return XEvent.xkeyState(this.struct);
    }

    public int getXkeyKeycode() {
        return XEvent.xkeyKeycode(this.struct);
    }

    public int getXkeySameScreen() {
        return XEvent.xkeySame_screen(this.struct);
    }

    public void getXbutton(ByteBuffer xbutton) {
        XEvent.xbuttonGet(this.struct, xbutton);
    }

    public int getXbuttonType() {
        return XEvent.xbuttonType(this.struct);
    }

    public long getXbuttonSerial() {
        return XEvent.xbuttonSerial(this.struct);
    }

    public int getXbuttonSendEvent() {
        return XEvent.xbuttonSend_event(this.struct);
    }

    public long getXbuttonDisplay() {
        return XEvent.xbuttonDisplay(this.struct);
    }

    public long getXbuttonWindow() {
        return XEvent.xbuttonWindow(this.struct);
    }

    public long getXbuttonRoot() {
        return XEvent.xbuttonRoot(this.struct);
    }

    public long getXbuttonSubwindow() {
        return XEvent.xbuttonSubwindow(this.struct);
    }

    public long getXbuttonTime() {
        return XEvent.xbuttonTime(this.struct);
    }

    public int getXbuttonX() {
        return XEvent.xbuttonX(this.struct);
    }

    public int getXbuttonY() {
        return XEvent.xbuttonY(this.struct);
    }

    public int getXbuttonXRoot() {
        return XEvent.xbuttonX_root(this.struct);
    }

    public int getXbuttonYRoot() {
        return XEvent.xbuttonY_root(this.struct);
    }

    public int getXbuttonState() {
        return XEvent.xbuttonState(this.struct);
    }

    public int getXbuttonButton() {
        return XEvent.xbuttonButton(this.struct);
    }

    public int getXbuttonSameScreen() {
        return XEvent.xbuttonSame_screen(this.struct);
    }

    public void getXmotion(ByteBuffer xmotion) {
        XEvent.xmotionGet(this.struct, xmotion);
    }

    public int getXmotionType() {
        return XEvent.xmotionType(this.struct);
    }

    public long getXmotionSerial() {
        return XEvent.xmotionSerial(this.struct);
    }

    public int getXmotionSendEvent() {
        return XEvent.xmotionSend_event(this.struct);
    }

    public long getXmotionDisplay() {
        return XEvent.xmotionDisplay(this.struct);
    }

    public long getXmotionWindow() {
        return XEvent.xmotionWindow(this.struct);
    }

    public long getXmotionRoot() {
        return XEvent.xmotionRoot(this.struct);
    }

    public long getXmotionSubwindow() {
        return XEvent.xmotionSubwindow(this.struct);
    }

    public long getXmotionTime() {
        return XEvent.xmotionTime(this.struct);
    }

    public int getXmotionX() {
        return XEvent.xmotionX(this.struct);
    }

    public int getXmotionY() {
        return XEvent.xmotionY(this.struct);
    }

    public int getXmotionXRoot() {
        return XEvent.xmotionX_root(this.struct);
    }

    public int getXmotionYRoot() {
        return XEvent.xmotionY_root(this.struct);
    }

    public int getXmotionState() {
        return XEvent.xmotionState(this.struct);
    }

    public int getXmotionIsHint() {
        return XEvent.xmotionIs_hint(this.struct);
    }

    public int getXmotionSameScreen() {
        return XEvent.xmotionSame_screen(this.struct);
    }

    public void getXconfigure(ByteBuffer xconfigure) {
        XEvent.xconfigureGet(this.struct, xconfigure);
    }

    public int getXconfigureType() {
        return XEvent.xconfigureType(this.struct);
    }

    public long getXconfigureSerial() {
        return XEvent.xconfigureSerial(this.struct);
    }

    public int getXconfigureSendEvent() {
        return XEvent.xconfigureSend_event(this.struct);
    }

    public long getXconfigureDisplay() {
        return XEvent.xconfigureDisplay(this.struct);
    }

    public long getXconfigureEvent() {
        return XEvent.xconfigureEvent(this.struct);
    }

    public long getXconfigureWindow() {
        return XEvent.xconfigureWindow(this.struct);
    }

    public int getXconfigureX() {
        return XEvent.xconfigureX(this.struct);
    }

    public int getXconfigureY() {
        return XEvent.xconfigureY(this.struct);
    }

    public int getXconfigureWidth() {
        return XEvent.xconfigureWidth(this.struct);
    }

    public int getXconfigureHeight() {
        return XEvent.xconfigureHeight(this.struct);
    }

    public int getXconfigureBorderWidth() {
        return XEvent.xconfigureBorder_width(this.struct);
    }

    public long getXconfigureAbove() {
        return XEvent.xconfigureAbove(this.struct);
    }

    public int getXconfigureOverrideRedirect() {
        return XEvent.xconfigureOverride_redirect(this.struct);
    }

    public void getXproperty(ByteBuffer xproperty) {
        XEvent.xpropertyGet(this.struct, xproperty);
    }

    public int getXpropertyType() {
        return XEvent.xpropertyType(this.struct);
    }

    public long getXpropertySerial() {
        return XEvent.xpropertySerial(this.struct);
    }

    public int getXpropertySendEvent() {
        return XEvent.xpropertySend_event(this.struct);
    }

    public long getXpropertyDisplay() {
        return XEvent.xpropertyDisplay(this.struct);
    }

    public long getXpropertyWindow() {
        return XEvent.xpropertyWindow(this.struct);
    }

    public long getXpropertyAtom() {
        return XEvent.xpropertyAtom(this.struct);
    }

    public long getXpropertyTime() {
        return XEvent.xpropertyTime(this.struct);
    }

    public int getXpropertyState() {
        return XEvent.xpropertyState(this.struct);
    }

    public void getXselectionrequest(ByteBuffer xselectionrequest) {
        XEvent.xselectionrequestGet(this.struct, xselectionrequest);
    }

    public int getXselectionrequestType() {
        return XEvent.xselectionrequestType(this.struct);
    }

    public long getXselectionrequestSerial() {
        return XEvent.xselectionrequestSerial(this.struct);
    }

    public int getXselectionrequestSendEvent() {
        return XEvent.xselectionrequestSend_event(this.struct);
    }

    public long getXselectionrequestDisplay() {
        return XEvent.xselectionrequestDisplay(this.struct);
    }

    public long getXselectionrequestOwner() {
        return XEvent.xselectionrequestOwner(this.struct);
    }

    public long getXselectionrequestRequestor() {
        return XEvent.xselectionrequestRequestor(this.struct);
    }

    public long getXselectionrequestSelection() {
        return XEvent.xselectionrequestSelection(this.struct);
    }

    public long getXselectionrequestTarget() {
        return XEvent.xselectionrequestTarget(this.struct);
    }

    public long getXselectionrequestProperty() {
        return XEvent.xselectionrequestProperty(this.struct);
    }

    public long getXselectionrequestTime() {
        return XEvent.xselectionrequestTime(this.struct);
    }

    public void getXselection(ByteBuffer xselection) {
        XEvent.xselectionGet(this.struct, xselection);
    }

    public int getXselectionType() {
        return XEvent.xselectionType(this.struct);
    }

    public long getXselectionSerial() {
        return XEvent.xselectionSerial(this.struct);
    }

    public int getXselectionSendEvent() {
        return XEvent.xselectionSend_event(this.struct);
    }

    public long getXselectionDisplay() {
        return XEvent.xselectionDisplay(this.struct);
    }

    public long getXselectionRequestor() {
        return XEvent.xselectionRequestor(this.struct);
    }

    public long getXselectionSelection() {
        return XEvent.xselectionSelection(this.struct);
    }

    public long getXselectionTarget() {
        return XEvent.xselectionTarget(this.struct);
    }

    public long getXselectionProperty() {
        return XEvent.xselectionProperty(this.struct);
    }

    public long getXselectionTime() {
        return XEvent.xselectionTime(this.struct);
    }

    public void getXclient(ByteBuffer xclient) {
        XEvent.xclientGet(this.struct, xclient);
    }

    public int getXclientType() {
        return XEvent.xclientType(this.struct);
    }

    public long getXclientSerial() {
        return XEvent.xclientSerial(this.struct);
    }

    public int getXclientSendEvent() {
        return XEvent.xclientSend_event(this.struct);
    }

    public long getXclientDisplay() {
        return XEvent.xclientDisplay(this.struct);
    }

    public long getXclientWindow() {
        return XEvent.xclientWindow(this.struct);
    }

    public long getXclientMessageType() {
        return XEvent.xclientMessage_type(this.struct);
    }

    public int getXclientFormat() {
        return XEvent.xclientFormat(this.struct);
    }

    public void getXclientDataB(ByteBuffer b) {
        XEvent.xclientDataBGet(this.struct, b);
    }

    public void getXclientDataS(ByteBuffer s) {
        XEvent.xclientDataSGet(this.struct, s);
    }

    public void getXclientDataL(ByteBuffer l) {
        XEvent.xclientDataLGet(this.struct, l);
    }

    public void getXerror(ByteBuffer xerror) {
        XEvent.xerrorGet(this.struct, xerror);
    }

    public int getXerrorType() {
        return XEvent.xerrorType(this.struct);
    }

    public long getXerrorDisplay() {
        return XEvent.xerrorDisplay(this.struct);
    }

    public long getXerrorSerial() {
        return XEvent.xerrorSerial(this.struct);
    }

    public int getXerrorErrorCode() {
        return XEvent.xerrorError_code(this.struct);
    }

    public int getXerrorRequestCode() {
        return XEvent.xerrorRequest_code(this.struct);
    }

    public int getXerrorMinorCode() {
        return XEvent.xerrorMinor_code(this.struct);
    }

    public long getXerrorResourceid() {
        return XEvent.xerrorResourceid(this.struct);
    }

    public void getXcookie(ByteBuffer xcookie) {
        XEvent.xcookieGet(this.struct, xcookie);
    }

    public int getXcookieType() {
        return XEvent.xcookieType(this.struct);
    }

    public long getXcookieSerial() {
        return XEvent.xcookieSerial(this.struct);
    }

    public int getXcookieSendEvent() {
        return XEvent.xcookieSend_event(this.struct);
    }

    public long getXcookieDisplay() {
        return XEvent.xcookieDisplay(this.struct);
    }

    public int getXcookieExtension() {
        return XEvent.xcookieExtension(this.struct);
    }

    public int getXcookieEvtype() {
        return XEvent.xcookieEvtype(this.struct);
    }

    public int getXcookieCookie() {
        return XEvent.xcookieCookie(this.struct);
    }

    public long getXcookieData() {
        return XEvent.xcookieData(this.struct);
    }

    public ByteBuffer getXcookieData(int byteLen) {
        return XEvent.xcookieData(this.struct, byteLen);
    }

    private static native int offsets(long var0);

    public static ByteBuffer malloc() {
        return BufferUtils.createByteBuffer(SIZEOF);
    }

    public static ByteBuffer malloc(int type, ByteBuffer xany, ByteBuffer xkey, ByteBuffer xbutton, ByteBuffer xmotion, ByteBuffer xconfigure, ByteBuffer xproperty, ByteBuffer xselectionrequest, ByteBuffer xselection, ByteBuffer xclient, ByteBuffer xerror, ByteBuffer xcookie) {
        ByteBuffer xevent = XEvent.malloc();
        XEvent.type(xevent, type);
        XEvent.xanySet(xevent, xany);
        XEvent.xkeySet(xevent, xkey);
        XEvent.xbuttonSet(xevent, xbutton);
        XEvent.xmotionSet(xevent, xmotion);
        XEvent.xconfigureSet(xevent, xconfigure);
        XEvent.xpropertySet(xevent, xproperty);
        XEvent.xselectionrequestSet(xevent, xselectionrequest);
        XEvent.xselectionSet(xevent, xselection);
        XEvent.xclientSet(xevent, xclient);
        XEvent.xerrorSet(xevent, xerror);
        XEvent.xcookieSet(xevent, xcookie);
        return xevent;
    }

    public static void type(ByteBuffer xevent, int type) {
        xevent.putInt(xevent.position() + TYPE, type);
    }

    public static void xanySet(ByteBuffer xevent, ByteBuffer xany) {
        if (xany != null) {
            MemoryUtil.memCopy(MemoryUtil.memAddress(xany), MemoryUtil.memAddress(xevent) + (long)XANY, XAnyEvent.SIZEOF);
        }
    }

    public static void xanyType(ByteBuffer xevent, int type) {
        xevent.putInt(xevent.position() + XANY + XAnyEvent.TYPE, type);
    }

    public static void xanySerial(ByteBuffer xevent, long serial) {
        PointerBuffer.put(xevent, xevent.position() + XANY + XAnyEvent.SERIAL, serial);
    }

    public static void xanySend_event(ByteBuffer xevent, int send_event) {
        xevent.putInt(xevent.position() + XANY + XAnyEvent.SEND_EVENT, send_event);
    }

    public static void xanyDisplay(ByteBuffer xevent, long display) {
        PointerBuffer.put(xevent, xevent.position() + XANY + XAnyEvent.DISPLAY, display);
    }

    public static void xanyWindow(ByteBuffer xevent, long window) {
        PointerBuffer.put(xevent, xevent.position() + XANY + XAnyEvent.WINDOW, window);
    }

    public static void xkeySet(ByteBuffer xevent, ByteBuffer xkey) {
        if (xkey != null) {
            MemoryUtil.memCopy(MemoryUtil.memAddress(xkey), MemoryUtil.memAddress(xevent) + (long)XKEY, XKeyEvent.SIZEOF);
        }
    }

    public static void xkeyType(ByteBuffer xevent, int type) {
        xevent.putInt(xevent.position() + XKEY + XKeyEvent.TYPE, type);
    }

    public static void xkeySerial(ByteBuffer xevent, long serial) {
        PointerBuffer.put(xevent, xevent.position() + XKEY + XKeyEvent.SERIAL, serial);
    }

    public static void xkeySend_event(ByteBuffer xevent, int send_event) {
        xevent.putInt(xevent.position() + XKEY + XKeyEvent.SEND_EVENT, send_event);
    }

    public static void xkeyDisplay(ByteBuffer xevent, long display) {
        PointerBuffer.put(xevent, xevent.position() + XKEY + XKeyEvent.DISPLAY, display);
    }

    public static void xkeyWindow(ByteBuffer xevent, long window) {
        PointerBuffer.put(xevent, xevent.position() + XKEY + XKeyEvent.WINDOW, window);
    }

    public static void xkeyRoot(ByteBuffer xevent, long root) {
        PointerBuffer.put(xevent, xevent.position() + XKEY + XKeyEvent.ROOT, root);
    }

    public static void xkeySubwindow(ByteBuffer xevent, long subwindow) {
        PointerBuffer.put(xevent, xevent.position() + XKEY + XKeyEvent.SUBWINDOW, subwindow);
    }

    public static void xkeyTime(ByteBuffer xevent, long time) {
        PointerBuffer.put(xevent, xevent.position() + XKEY + XKeyEvent.TIME, time);
    }

    public static void xkeyX(ByteBuffer xevent, int x) {
        xevent.putInt(xevent.position() + XKEY + XKeyEvent.X, x);
    }

    public static void xkeyY(ByteBuffer xevent, int y) {
        xevent.putInt(xevent.position() + XKEY + XKeyEvent.Y, y);
    }

    public static void xkeyX_root(ByteBuffer xevent, int x_root) {
        xevent.putInt(xevent.position() + XKEY + XKeyEvent.X_ROOT, x_root);
    }

    public static void xkeyY_root(ByteBuffer xevent, int y_root) {
        xevent.putInt(xevent.position() + XKEY + XKeyEvent.Y_ROOT, y_root);
    }

    public static void xkeyState(ByteBuffer xevent, int state) {
        xevent.putInt(xevent.position() + XKEY + XKeyEvent.STATE, state);
    }

    public static void xkeyKeycode(ByteBuffer xevent, int keycode) {
        xevent.putInt(xevent.position() + XKEY + XKeyEvent.KEYCODE, keycode);
    }

    public static void xkeySame_screen(ByteBuffer xevent, int same_screen) {
        xevent.putInt(xevent.position() + XKEY + XKeyEvent.SAME_SCREEN, same_screen);
    }

    public static void xbuttonSet(ByteBuffer xevent, ByteBuffer xbutton) {
        if (xbutton != null) {
            MemoryUtil.memCopy(MemoryUtil.memAddress(xbutton), MemoryUtil.memAddress(xevent) + (long)XBUTTON, XButtonEvent.SIZEOF);
        }
    }

    public static void xbuttonType(ByteBuffer xevent, int type) {
        xevent.putInt(xevent.position() + XBUTTON + XButtonEvent.TYPE, type);
    }

    public static void xbuttonSerial(ByteBuffer xevent, long serial) {
        PointerBuffer.put(xevent, xevent.position() + XBUTTON + XButtonEvent.SERIAL, serial);
    }

    public static void xbuttonSend_event(ByteBuffer xevent, int send_event) {
        xevent.putInt(xevent.position() + XBUTTON + XButtonEvent.SEND_EVENT, send_event);
    }

    public static void xbuttonDisplay(ByteBuffer xevent, long display) {
        PointerBuffer.put(xevent, xevent.position() + XBUTTON + XButtonEvent.DISPLAY, display);
    }

    public static void xbuttonWindow(ByteBuffer xevent, long window) {
        PointerBuffer.put(xevent, xevent.position() + XBUTTON + XButtonEvent.WINDOW, window);
    }

    public static void xbuttonRoot(ByteBuffer xevent, long root) {
        PointerBuffer.put(xevent, xevent.position() + XBUTTON + XButtonEvent.ROOT, root);
    }

    public static void xbuttonSubwindow(ByteBuffer xevent, long subwindow) {
        PointerBuffer.put(xevent, xevent.position() + XBUTTON + XButtonEvent.SUBWINDOW, subwindow);
    }

    public static void xbuttonTime(ByteBuffer xevent, long time) {
        PointerBuffer.put(xevent, xevent.position() + XBUTTON + XButtonEvent.TIME, time);
    }

    public static void xbuttonX(ByteBuffer xevent, int x) {
        xevent.putInt(xevent.position() + XBUTTON + XButtonEvent.X, x);
    }

    public static void xbuttonY(ByteBuffer xevent, int y) {
        xevent.putInt(xevent.position() + XBUTTON + XButtonEvent.Y, y);
    }

    public static void xbuttonX_root(ByteBuffer xevent, int x_root) {
        xevent.putInt(xevent.position() + XBUTTON + XButtonEvent.X_ROOT, x_root);
    }

    public static void xbuttonY_root(ByteBuffer xevent, int y_root) {
        xevent.putInt(xevent.position() + XBUTTON + XButtonEvent.Y_ROOT, y_root);
    }

    public static void xbuttonState(ByteBuffer xevent, int state) {
        xevent.putInt(xevent.position() + XBUTTON + XButtonEvent.STATE, state);
    }

    public static void xbuttonButton(ByteBuffer xevent, int button) {
        xevent.putInt(xevent.position() + XBUTTON + XButtonEvent.BUTTON, button);
    }

    public static void xbuttonSame_screen(ByteBuffer xevent, int same_screen) {
        xevent.putInt(xevent.position() + XBUTTON + XButtonEvent.SAME_SCREEN, same_screen);
    }

    public static void xmotionSet(ByteBuffer xevent, ByteBuffer xmotion) {
        if (xmotion != null) {
            MemoryUtil.memCopy(MemoryUtil.memAddress(xmotion), MemoryUtil.memAddress(xevent) + (long)XMOTION, XMotionEvent.SIZEOF);
        }
    }

    public static void xmotionType(ByteBuffer xevent, int type) {
        xevent.putInt(xevent.position() + XMOTION + XMotionEvent.TYPE, type);
    }

    public static void xmotionSerial(ByteBuffer xevent, long serial) {
        PointerBuffer.put(xevent, xevent.position() + XMOTION + XMotionEvent.SERIAL, serial);
    }

    public static void xmotionSend_event(ByteBuffer xevent, int send_event) {
        xevent.putInt(xevent.position() + XMOTION + XMotionEvent.SEND_EVENT, send_event);
    }

    public static void xmotionDisplay(ByteBuffer xevent, long display) {
        PointerBuffer.put(xevent, xevent.position() + XMOTION + XMotionEvent.DISPLAY, display);
    }

    public static void xmotionWindow(ByteBuffer xevent, long window) {
        PointerBuffer.put(xevent, xevent.position() + XMOTION + XMotionEvent.WINDOW, window);
    }

    public static void xmotionRoot(ByteBuffer xevent, long root) {
        PointerBuffer.put(xevent, xevent.position() + XMOTION + XMotionEvent.ROOT, root);
    }

    public static void xmotionSubwindow(ByteBuffer xevent, long subwindow) {
        PointerBuffer.put(xevent, xevent.position() + XMOTION + XMotionEvent.SUBWINDOW, subwindow);
    }

    public static void xmotionTime(ByteBuffer xevent, long time) {
        PointerBuffer.put(xevent, xevent.position() + XMOTION + XMotionEvent.TIME, time);
    }

    public static void xmotionX(ByteBuffer xevent, int x) {
        xevent.putInt(xevent.position() + XMOTION + XMotionEvent.X, x);
    }

    public static void xmotionY(ByteBuffer xevent, int y) {
        xevent.putInt(xevent.position() + XMOTION + XMotionEvent.Y, y);
    }

    public static void xmotionX_root(ByteBuffer xevent, int x_root) {
        xevent.putInt(xevent.position() + XMOTION + XMotionEvent.X_ROOT, x_root);
    }

    public static void xmotionY_root(ByteBuffer xevent, int y_root) {
        xevent.putInt(xevent.position() + XMOTION + XMotionEvent.Y_ROOT, y_root);
    }

    public static void xmotionState(ByteBuffer xevent, int state) {
        xevent.putInt(xevent.position() + XMOTION + XMotionEvent.STATE, state);
    }

    public static void xmotionIs_hint(ByteBuffer xevent, int is_hint) {
        xevent.put(xevent.position() + XMOTION + XMotionEvent.IS_HINT, (byte)is_hint);
    }

    public static void xmotionSame_screen(ByteBuffer xevent, int same_screen) {
        xevent.putInt(xevent.position() + XMOTION + XMotionEvent.SAME_SCREEN, same_screen);
    }

    public static void xconfigureSet(ByteBuffer xevent, ByteBuffer xconfigure) {
        if (xconfigure != null) {
            MemoryUtil.memCopy(MemoryUtil.memAddress(xconfigure), MemoryUtil.memAddress(xevent) + (long)XCONFIGURE, XConfigureEvent.SIZEOF);
        }
    }

    public static void xconfigureType(ByteBuffer xevent, int type) {
        xevent.putInt(xevent.position() + XCONFIGURE + XConfigureEvent.TYPE, type);
    }

    public static void xconfigureSerial(ByteBuffer xevent, long serial) {
        PointerBuffer.put(xevent, xevent.position() + XCONFIGURE + XConfigureEvent.SERIAL, serial);
    }

    public static void xconfigureSend_event(ByteBuffer xevent, int send_event) {
        xevent.putInt(xevent.position() + XCONFIGURE + XConfigureEvent.SEND_EVENT, send_event);
    }

    public static void xconfigureDisplay(ByteBuffer xevent, long display) {
        PointerBuffer.put(xevent, xevent.position() + XCONFIGURE + XConfigureEvent.DISPLAY, display);
    }

    public static void xconfigureEvent(ByteBuffer xevent, long event) {
        PointerBuffer.put(xevent, xevent.position() + XCONFIGURE + XConfigureEvent.EVENT, event);
    }

    public static void xconfigureWindow(ByteBuffer xevent, long window) {
        PointerBuffer.put(xevent, xevent.position() + XCONFIGURE + XConfigureEvent.WINDOW, window);
    }

    public static void xconfigureX(ByteBuffer xevent, int x) {
        xevent.putInt(xevent.position() + XCONFIGURE + XConfigureEvent.X, x);
    }

    public static void xconfigureY(ByteBuffer xevent, int y) {
        xevent.putInt(xevent.position() + XCONFIGURE + XConfigureEvent.Y, y);
    }

    public static void xconfigureWidth(ByteBuffer xevent, int width) {
        xevent.putInt(xevent.position() + XCONFIGURE + XConfigureEvent.WIDTH, width);
    }

    public static void xconfigureHeight(ByteBuffer xevent, int height) {
        xevent.putInt(xevent.position() + XCONFIGURE + XConfigureEvent.HEIGHT, height);
    }

    public static void xconfigureBorder_width(ByteBuffer xevent, int border_width) {
        xevent.putInt(xevent.position() + XCONFIGURE + XConfigureEvent.BORDER_WIDTH, border_width);
    }

    public static void xconfigureAbove(ByteBuffer xevent, long above) {
        PointerBuffer.put(xevent, xevent.position() + XCONFIGURE + XConfigureEvent.ABOVE, above);
    }

    public static void xconfigureOverride_redirect(ByteBuffer xevent, int override_redirect) {
        xevent.putInt(xevent.position() + XCONFIGURE + XConfigureEvent.OVERRIDE_REDIRECT, override_redirect);
    }

    public static void xpropertySet(ByteBuffer xevent, ByteBuffer xproperty) {
        if (xproperty != null) {
            MemoryUtil.memCopy(MemoryUtil.memAddress(xproperty), MemoryUtil.memAddress(xevent) + (long)XPROPERTY, XPropertyEvent.SIZEOF);
        }
    }

    public static void xpropertyType(ByteBuffer xevent, int type) {
        xevent.putInt(xevent.position() + XPROPERTY + XPropertyEvent.TYPE, type);
    }

    public static void xpropertySerial(ByteBuffer xevent, long serial) {
        PointerBuffer.put(xevent, xevent.position() + XPROPERTY + XPropertyEvent.SERIAL, serial);
    }

    public static void xpropertySend_event(ByteBuffer xevent, int send_event) {
        xevent.putInt(xevent.position() + XPROPERTY + XPropertyEvent.SEND_EVENT, send_event);
    }

    public static void xpropertyDisplay(ByteBuffer xevent, long display) {
        PointerBuffer.put(xevent, xevent.position() + XPROPERTY + XPropertyEvent.DISPLAY, display);
    }

    public static void xpropertyWindow(ByteBuffer xevent, long window) {
        PointerBuffer.put(xevent, xevent.position() + XPROPERTY + XPropertyEvent.WINDOW, window);
    }

    public static void xpropertyAtom(ByteBuffer xevent, long atom) {
        PointerBuffer.put(xevent, xevent.position() + XPROPERTY + XPropertyEvent.ATOM, atom);
    }

    public static void xpropertyTime(ByteBuffer xevent, long time) {
        PointerBuffer.put(xevent, xevent.position() + XPROPERTY + XPropertyEvent.TIME, time);
    }

    public static void xpropertyState(ByteBuffer xevent, int state) {
        xevent.putInt(xevent.position() + XPROPERTY + XPropertyEvent.STATE, state);
    }

    public static void xselectionrequestSet(ByteBuffer xevent, ByteBuffer xselectionrequest) {
        if (xselectionrequest != null) {
            MemoryUtil.memCopy(MemoryUtil.memAddress(xselectionrequest), MemoryUtil.memAddress(xevent) + (long)XSELECTIONREQUEST, XSelectionRequestEvent.SIZEOF);
        }
    }

    public static void xselectionrequestType(ByteBuffer xevent, int type) {
        xevent.putInt(xevent.position() + XSELECTIONREQUEST + XSelectionRequestEvent.TYPE, type);
    }

    public static void xselectionrequestSerial(ByteBuffer xevent, long serial) {
        PointerBuffer.put(xevent, xevent.position() + XSELECTIONREQUEST + XSelectionRequestEvent.SERIAL, serial);
    }

    public static void xselectionrequestSend_event(ByteBuffer xevent, int send_event) {
        xevent.putInt(xevent.position() + XSELECTIONREQUEST + XSelectionRequestEvent.SEND_EVENT, send_event);
    }

    public static void xselectionrequestDisplay(ByteBuffer xevent, long display) {
        PointerBuffer.put(xevent, xevent.position() + XSELECTIONREQUEST + XSelectionRequestEvent.DISPLAY, display);
    }

    public static void xselectionrequestOwner(ByteBuffer xevent, long owner) {
        PointerBuffer.put(xevent, xevent.position() + XSELECTIONREQUEST + XSelectionRequestEvent.OWNER, owner);
    }

    public static void xselectionrequestRequestor(ByteBuffer xevent, long requestor) {
        PointerBuffer.put(xevent, xevent.position() + XSELECTIONREQUEST + XSelectionRequestEvent.REQUESTOR, requestor);
    }

    public static void xselectionrequestSelection(ByteBuffer xevent, long selection) {
        PointerBuffer.put(xevent, xevent.position() + XSELECTIONREQUEST + XSelectionRequestEvent.SELECTION, selection);
    }

    public static void xselectionrequestTarget(ByteBuffer xevent, long target) {
        PointerBuffer.put(xevent, xevent.position() + XSELECTIONREQUEST + XSelectionRequestEvent.TARGET, target);
    }

    public static void xselectionrequestProperty(ByteBuffer xevent, long property) {
        PointerBuffer.put(xevent, xevent.position() + XSELECTIONREQUEST + XSelectionRequestEvent.PROPERTY, property);
    }

    public static void xselectionrequestTime(ByteBuffer xevent, long time) {
        PointerBuffer.put(xevent, xevent.position() + XSELECTIONREQUEST + XSelectionRequestEvent.TIME, time);
    }

    public static void xselectionSet(ByteBuffer xevent, ByteBuffer xselection) {
        if (xselection != null) {
            MemoryUtil.memCopy(MemoryUtil.memAddress(xselection), MemoryUtil.memAddress(xevent) + (long)XSELECTION, XSelectionEvent.SIZEOF);
        }
    }

    public static void xselectionType(ByteBuffer xevent, int type) {
        xevent.putInt(xevent.position() + XSELECTION + XSelectionEvent.TYPE, type);
    }

    public static void xselectionSerial(ByteBuffer xevent, long serial) {
        PointerBuffer.put(xevent, xevent.position() + XSELECTION + XSelectionEvent.SERIAL, serial);
    }

    public static void xselectionSend_event(ByteBuffer xevent, int send_event) {
        xevent.putInt(xevent.position() + XSELECTION + XSelectionEvent.SEND_EVENT, send_event);
    }

    public static void xselectionDisplay(ByteBuffer xevent, long display) {
        PointerBuffer.put(xevent, xevent.position() + XSELECTION + XSelectionEvent.DISPLAY, display);
    }

    public static void xselectionRequestor(ByteBuffer xevent, long requestor) {
        PointerBuffer.put(xevent, xevent.position() + XSELECTION + XSelectionEvent.REQUESTOR, requestor);
    }

    public static void xselectionSelection(ByteBuffer xevent, long selection) {
        PointerBuffer.put(xevent, xevent.position() + XSELECTION + XSelectionEvent.SELECTION, selection);
    }

    public static void xselectionTarget(ByteBuffer xevent, long target) {
        PointerBuffer.put(xevent, xevent.position() + XSELECTION + XSelectionEvent.TARGET, target);
    }

    public static void xselectionProperty(ByteBuffer xevent, long property) {
        PointerBuffer.put(xevent, xevent.position() + XSELECTION + XSelectionEvent.PROPERTY, property);
    }

    public static void xselectionTime(ByteBuffer xevent, long time) {
        PointerBuffer.put(xevent, xevent.position() + XSELECTION + XSelectionEvent.TIME, time);
    }

    public static void xclientSet(ByteBuffer xevent, ByteBuffer xclient) {
        if (xclient != null) {
            MemoryUtil.memCopy(MemoryUtil.memAddress(xclient), MemoryUtil.memAddress(xevent) + (long)XCLIENT, XClientMessageEvent.SIZEOF);
        }
    }

    public static void xclientType(ByteBuffer xevent, int type) {
        xevent.putInt(xevent.position() + XCLIENT + XClientMessageEvent.TYPE, type);
    }

    public static void xclientSerial(ByteBuffer xevent, long serial) {
        PointerBuffer.put(xevent, xevent.position() + XCLIENT + XClientMessageEvent.SERIAL, serial);
    }

    public static void xclientSend_event(ByteBuffer xevent, int send_event) {
        xevent.putInt(xevent.position() + XCLIENT + XClientMessageEvent.SEND_EVENT, send_event);
    }

    public static void xclientDisplay(ByteBuffer xevent, long display) {
        PointerBuffer.put(xevent, xevent.position() + XCLIENT + XClientMessageEvent.DISPLAY, display);
    }

    public static void xclientWindow(ByteBuffer xevent, long window) {
        PointerBuffer.put(xevent, xevent.position() + XCLIENT + XClientMessageEvent.WINDOW, window);
    }

    public static void xclientMessage_type(ByteBuffer xevent, long message_type) {
        PointerBuffer.put(xevent, xevent.position() + XCLIENT + XClientMessageEvent.MESSAGE_TYPE, message_type);
    }

    public static void xclientFormat(ByteBuffer xevent, int format) {
        xevent.putInt(xevent.position() + XCLIENT + XClientMessageEvent.FORMAT, format);
    }

    public static void xclientDataBSet(ByteBuffer xevent, ByteBuffer b) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkBufferGT(b, 20);
        }
        MemoryUtil.memCopy(MemoryUtil.memAddress(b), MemoryUtil.memAddress(xevent) + (long)XCLIENT + (long)XClientMessageEvent.DATA_B, b.remaining());
    }

    public static void xclientDataB(ByteBuffer xevent, int index, byte b) {
        xevent.put(XCLIENT + XClientMessageEvent.DATA_B + index, b);
    }

    public static void xclientDataSSet(ByteBuffer xevent, ByteBuffer s) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkBufferGT(s, 20);
        }
        MemoryUtil.memCopy(MemoryUtil.memAddress(s), MemoryUtil.memAddress(xevent) + (long)XCLIENT + (long)XClientMessageEvent.DATA_S, s.remaining());
    }

    public static void xclientDataS(ByteBuffer xevent, int index, short s) {
        xevent.putShort(XCLIENT + XClientMessageEvent.DATA_S + index * 2, s);
    }

    public static void xclientDataLSet(ByteBuffer xevent, ByteBuffer l) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkBufferGT(l, 5 * POINTER_SIZE);
        }
        MemoryUtil.memCopy(MemoryUtil.memAddress(l), MemoryUtil.memAddress(xevent) + (long)XCLIENT + (long)XClientMessageEvent.DATA_L, l.remaining());
    }

    public static void xclientDataL(ByteBuffer xevent, int index, long l) {
        PointerBuffer.put(xevent, XCLIENT + XClientMessageEvent.DATA_L + index * POINTER_SIZE, l);
    }

    public static void xerrorSet(ByteBuffer xevent, ByteBuffer xerror) {
        if (xerror != null) {
            MemoryUtil.memCopy(MemoryUtil.memAddress(xerror), MemoryUtil.memAddress(xevent) + (long)XERROR, XErrorEvent.SIZEOF);
        }
    }

    public static void xerrorType(ByteBuffer xevent, int type) {
        xevent.putInt(xevent.position() + XERROR + XErrorEvent.TYPE, type);
    }

    public static void xerrorDisplay(ByteBuffer xevent, long display) {
        PointerBuffer.put(xevent, xevent.position() + XERROR + XErrorEvent.DISPLAY, display);
    }

    public static void xerrorSerial(ByteBuffer xevent, long serial) {
        PointerBuffer.put(xevent, xevent.position() + XERROR + XErrorEvent.SERIAL, serial);
    }

    public static void xerrorError_code(ByteBuffer xevent, int error_code) {
        xevent.put(xevent.position() + XERROR + XErrorEvent.ERROR_CODE, (byte)error_code);
    }

    public static void xerrorRequest_code(ByteBuffer xevent, int request_code) {
        xevent.put(xevent.position() + XERROR + XErrorEvent.REQUEST_CODE, (byte)request_code);
    }

    public static void xerrorMinor_code(ByteBuffer xevent, int minor_code) {
        xevent.put(xevent.position() + XERROR + XErrorEvent.MINOR_CODE, (byte)minor_code);
    }

    public static void xerrorResourceid(ByteBuffer xevent, long resourceid) {
        PointerBuffer.put(xevent, xevent.position() + XERROR + XErrorEvent.RESOURCEID, resourceid);
    }

    public static void xcookieSet(ByteBuffer xevent, ByteBuffer xcookie) {
        if (xcookie != null) {
            MemoryUtil.memCopy(MemoryUtil.memAddress(xcookie), MemoryUtil.memAddress(xevent) + (long)XCOOKIE, XGenericEventCookie.SIZEOF);
        }
    }

    public static void xcookieType(ByteBuffer xevent, int type) {
        xevent.putInt(xevent.position() + XCOOKIE + XGenericEventCookie.TYPE, type);
    }

    public static void xcookieSerial(ByteBuffer xevent, long serial) {
        PointerBuffer.put(xevent, xevent.position() + XCOOKIE + XGenericEventCookie.SERIAL, serial);
    }

    public static void xcookieSend_event(ByteBuffer xevent, int send_event) {
        xevent.putInt(xevent.position() + XCOOKIE + XGenericEventCookie.SEND_EVENT, send_event);
    }

    public static void xcookieDisplay(ByteBuffer xevent, long display) {
        PointerBuffer.put(xevent, xevent.position() + XCOOKIE + XGenericEventCookie.DISPLAY, display);
    }

    public static void xcookieExtension(ByteBuffer xevent, int extension) {
        xevent.putInt(xevent.position() + XCOOKIE + XGenericEventCookie.EXTENSION, extension);
    }

    public static void xcookieEvtype(ByteBuffer xevent, int evtype) {
        xevent.putInt(xevent.position() + XCOOKIE + XGenericEventCookie.EVTYPE, evtype);
    }

    public static void xcookieCookie(ByteBuffer xevent, int cookie) {
        xevent.putInt(xevent.position() + XCOOKIE + XGenericEventCookie.COOKIE, cookie);
    }

    public static void xcookieData(ByteBuffer xevent, long data) {
        PointerBuffer.put(xevent, xevent.position() + XCOOKIE + XGenericEventCookie.DATA, data);
    }

    public static void xcookieData(ByteBuffer xevent, ByteBuffer data) {
        XEvent.xcookieData(xevent, MemoryUtil.memAddressSafe(data));
    }

    public static int type(ByteBuffer xevent) {
        return xevent.getInt(xevent.position() + TYPE);
    }

    public static void xanyGet(ByteBuffer xevent, ByteBuffer xany) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkBuffer((Buffer)xany, XAnyEvent.SIZEOF);
        }
        MemoryUtil.memCopy(MemoryUtil.memAddress(xevent) + (long)XANY, MemoryUtil.memAddress(xany), XAnyEvent.SIZEOF);
    }

    public static int xanyType(ByteBuffer xevent) {
        return xevent.getInt(xevent.position() + XANY + XAnyEvent.TYPE);
    }

    public static long xanySerial(ByteBuffer xevent) {
        return PointerBuffer.get(xevent, xevent.position() + XANY + XAnyEvent.SERIAL);
    }

    public static int xanySend_event(ByteBuffer xevent) {
        return xevent.getInt(xevent.position() + XANY + XAnyEvent.SEND_EVENT);
    }

    public static long xanyDisplay(ByteBuffer xevent) {
        return PointerBuffer.get(xevent, xevent.position() + XANY + XAnyEvent.DISPLAY);
    }

    public static long xanyWindow(ByteBuffer xevent) {
        return PointerBuffer.get(xevent, xevent.position() + XANY + XAnyEvent.WINDOW);
    }

    public static void xkeyGet(ByteBuffer xevent, ByteBuffer xkey) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkBuffer((Buffer)xkey, XKeyEvent.SIZEOF);
        }
        MemoryUtil.memCopy(MemoryUtil.memAddress(xevent) + (long)XKEY, MemoryUtil.memAddress(xkey), XKeyEvent.SIZEOF);
    }

    public static int xkeyType(ByteBuffer xevent) {
        return xevent.getInt(xevent.position() + XKEY + XKeyEvent.TYPE);
    }

    public static long xkeySerial(ByteBuffer xevent) {
        return PointerBuffer.get(xevent, xevent.position() + XKEY + XKeyEvent.SERIAL);
    }

    public static int xkeySend_event(ByteBuffer xevent) {
        return xevent.getInt(xevent.position() + XKEY + XKeyEvent.SEND_EVENT);
    }

    public static long xkeyDisplay(ByteBuffer xevent) {
        return PointerBuffer.get(xevent, xevent.position() + XKEY + XKeyEvent.DISPLAY);
    }

    public static long xkeyWindow(ByteBuffer xevent) {
        return PointerBuffer.get(xevent, xevent.position() + XKEY + XKeyEvent.WINDOW);
    }

    public static long xkeyRoot(ByteBuffer xevent) {
        return PointerBuffer.get(xevent, xevent.position() + XKEY + XKeyEvent.ROOT);
    }

    public static long xkeySubwindow(ByteBuffer xevent) {
        return PointerBuffer.get(xevent, xevent.position() + XKEY + XKeyEvent.SUBWINDOW);
    }

    public static long xkeyTime(ByteBuffer xevent) {
        return PointerBuffer.get(xevent, xevent.position() + XKEY + XKeyEvent.TIME);
    }

    public static int xkeyX(ByteBuffer xevent) {
        return xevent.getInt(xevent.position() + XKEY + XKeyEvent.X);
    }

    public static int xkeyY(ByteBuffer xevent) {
        return xevent.getInt(xevent.position() + XKEY + XKeyEvent.Y);
    }

    public static int xkeyX_root(ByteBuffer xevent) {
        return xevent.getInt(xevent.position() + XKEY + XKeyEvent.X_ROOT);
    }

    public static int xkeyY_root(ByteBuffer xevent) {
        return xevent.getInt(xevent.position() + XKEY + XKeyEvent.Y_ROOT);
    }

    public static int xkeyState(ByteBuffer xevent) {
        return xevent.getInt(xevent.position() + XKEY + XKeyEvent.STATE);
    }

    public static int xkeyKeycode(ByteBuffer xevent) {
        return xevent.getInt(xevent.position() + XKEY + XKeyEvent.KEYCODE);
    }

    public static int xkeySame_screen(ByteBuffer xevent) {
        return xevent.getInt(xevent.position() + XKEY + XKeyEvent.SAME_SCREEN);
    }

    public static void xbuttonGet(ByteBuffer xevent, ByteBuffer xbutton) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkBuffer((Buffer)xbutton, XButtonEvent.SIZEOF);
        }
        MemoryUtil.memCopy(MemoryUtil.memAddress(xevent) + (long)XBUTTON, MemoryUtil.memAddress(xbutton), XButtonEvent.SIZEOF);
    }

    public static int xbuttonType(ByteBuffer xevent) {
        return xevent.getInt(xevent.position() + XBUTTON + XButtonEvent.TYPE);
    }

    public static long xbuttonSerial(ByteBuffer xevent) {
        return PointerBuffer.get(xevent, xevent.position() + XBUTTON + XButtonEvent.SERIAL);
    }

    public static int xbuttonSend_event(ByteBuffer xevent) {
        return xevent.getInt(xevent.position() + XBUTTON + XButtonEvent.SEND_EVENT);
    }

    public static long xbuttonDisplay(ByteBuffer xevent) {
        return PointerBuffer.get(xevent, xevent.position() + XBUTTON + XButtonEvent.DISPLAY);
    }

    public static long xbuttonWindow(ByteBuffer xevent) {
        return PointerBuffer.get(xevent, xevent.position() + XBUTTON + XButtonEvent.WINDOW);
    }

    public static long xbuttonRoot(ByteBuffer xevent) {
        return PointerBuffer.get(xevent, xevent.position() + XBUTTON + XButtonEvent.ROOT);
    }

    public static long xbuttonSubwindow(ByteBuffer xevent) {
        return PointerBuffer.get(xevent, xevent.position() + XBUTTON + XButtonEvent.SUBWINDOW);
    }

    public static long xbuttonTime(ByteBuffer xevent) {
        return PointerBuffer.get(xevent, xevent.position() + XBUTTON + XButtonEvent.TIME);
    }

    public static int xbuttonX(ByteBuffer xevent) {
        return xevent.getInt(xevent.position() + XBUTTON + XButtonEvent.X);
    }

    public static int xbuttonY(ByteBuffer xevent) {
        return xevent.getInt(xevent.position() + XBUTTON + XButtonEvent.Y);
    }

    public static int xbuttonX_root(ByteBuffer xevent) {
        return xevent.getInt(xevent.position() + XBUTTON + XButtonEvent.X_ROOT);
    }

    public static int xbuttonY_root(ByteBuffer xevent) {
        return xevent.getInt(xevent.position() + XBUTTON + XButtonEvent.Y_ROOT);
    }

    public static int xbuttonState(ByteBuffer xevent) {
        return xevent.getInt(xevent.position() + XBUTTON + XButtonEvent.STATE);
    }

    public static int xbuttonButton(ByteBuffer xevent) {
        return xevent.getInt(xevent.position() + XBUTTON + XButtonEvent.BUTTON);
    }

    public static int xbuttonSame_screen(ByteBuffer xevent) {
        return xevent.getInt(xevent.position() + XBUTTON + XButtonEvent.SAME_SCREEN);
    }

    public static void xmotionGet(ByteBuffer xevent, ByteBuffer xmotion) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkBuffer((Buffer)xmotion, XMotionEvent.SIZEOF);
        }
        MemoryUtil.memCopy(MemoryUtil.memAddress(xevent) + (long)XMOTION, MemoryUtil.memAddress(xmotion), XMotionEvent.SIZEOF);
    }

    public static int xmotionType(ByteBuffer xevent) {
        return xevent.getInt(xevent.position() + XMOTION + XMotionEvent.TYPE);
    }

    public static long xmotionSerial(ByteBuffer xevent) {
        return PointerBuffer.get(xevent, xevent.position() + XMOTION + XMotionEvent.SERIAL);
    }

    public static int xmotionSend_event(ByteBuffer xevent) {
        return xevent.getInt(xevent.position() + XMOTION + XMotionEvent.SEND_EVENT);
    }

    public static long xmotionDisplay(ByteBuffer xevent) {
        return PointerBuffer.get(xevent, xevent.position() + XMOTION + XMotionEvent.DISPLAY);
    }

    public static long xmotionWindow(ByteBuffer xevent) {
        return PointerBuffer.get(xevent, xevent.position() + XMOTION + XMotionEvent.WINDOW);
    }

    public static long xmotionRoot(ByteBuffer xevent) {
        return PointerBuffer.get(xevent, xevent.position() + XMOTION + XMotionEvent.ROOT);
    }

    public static long xmotionSubwindow(ByteBuffer xevent) {
        return PointerBuffer.get(xevent, xevent.position() + XMOTION + XMotionEvent.SUBWINDOW);
    }

    public static long xmotionTime(ByteBuffer xevent) {
        return PointerBuffer.get(xevent, xevent.position() + XMOTION + XMotionEvent.TIME);
    }

    public static int xmotionX(ByteBuffer xevent) {
        return xevent.getInt(xevent.position() + XMOTION + XMotionEvent.X);
    }

    public static int xmotionY(ByteBuffer xevent) {
        return xevent.getInt(xevent.position() + XMOTION + XMotionEvent.Y);
    }

    public static int xmotionX_root(ByteBuffer xevent) {
        return xevent.getInt(xevent.position() + XMOTION + XMotionEvent.X_ROOT);
    }

    public static int xmotionY_root(ByteBuffer xevent) {
        return xevent.getInt(xevent.position() + XMOTION + XMotionEvent.Y_ROOT);
    }

    public static int xmotionState(ByteBuffer xevent) {
        return xevent.getInt(xevent.position() + XMOTION + XMotionEvent.STATE);
    }

    public static int xmotionIs_hint(ByteBuffer xevent) {
        return xevent.get(xevent.position() + XMOTION + XMotionEvent.IS_HINT);
    }

    public static int xmotionSame_screen(ByteBuffer xevent) {
        return xevent.getInt(xevent.position() + XMOTION + XMotionEvent.SAME_SCREEN);
    }

    public static void xconfigureGet(ByteBuffer xevent, ByteBuffer xconfigure) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkBuffer((Buffer)xconfigure, XConfigureEvent.SIZEOF);
        }
        MemoryUtil.memCopy(MemoryUtil.memAddress(xevent) + (long)XCONFIGURE, MemoryUtil.memAddress(xconfigure), XConfigureEvent.SIZEOF);
    }

    public static int xconfigureType(ByteBuffer xevent) {
        return xevent.getInt(xevent.position() + XCONFIGURE + XConfigureEvent.TYPE);
    }

    public static long xconfigureSerial(ByteBuffer xevent) {
        return PointerBuffer.get(xevent, xevent.position() + XCONFIGURE + XConfigureEvent.SERIAL);
    }

    public static int xconfigureSend_event(ByteBuffer xevent) {
        return xevent.getInt(xevent.position() + XCONFIGURE + XConfigureEvent.SEND_EVENT);
    }

    public static long xconfigureDisplay(ByteBuffer xevent) {
        return PointerBuffer.get(xevent, xevent.position() + XCONFIGURE + XConfigureEvent.DISPLAY);
    }

    public static long xconfigureEvent(ByteBuffer xevent) {
        return PointerBuffer.get(xevent, xevent.position() + XCONFIGURE + XConfigureEvent.EVENT);
    }

    public static long xconfigureWindow(ByteBuffer xevent) {
        return PointerBuffer.get(xevent, xevent.position() + XCONFIGURE + XConfigureEvent.WINDOW);
    }

    public static int xconfigureX(ByteBuffer xevent) {
        return xevent.getInt(xevent.position() + XCONFIGURE + XConfigureEvent.X);
    }

    public static int xconfigureY(ByteBuffer xevent) {
        return xevent.getInt(xevent.position() + XCONFIGURE + XConfigureEvent.Y);
    }

    public static int xconfigureWidth(ByteBuffer xevent) {
        return xevent.getInt(xevent.position() + XCONFIGURE + XConfigureEvent.WIDTH);
    }

    public static int xconfigureHeight(ByteBuffer xevent) {
        return xevent.getInt(xevent.position() + XCONFIGURE + XConfigureEvent.HEIGHT);
    }

    public static int xconfigureBorder_width(ByteBuffer xevent) {
        return xevent.getInt(xevent.position() + XCONFIGURE + XConfigureEvent.BORDER_WIDTH);
    }

    public static long xconfigureAbove(ByteBuffer xevent) {
        return PointerBuffer.get(xevent, xevent.position() + XCONFIGURE + XConfigureEvent.ABOVE);
    }

    public static int xconfigureOverride_redirect(ByteBuffer xevent) {
        return xevent.getInt(xevent.position() + XCONFIGURE + XConfigureEvent.OVERRIDE_REDIRECT);
    }

    public static void xpropertyGet(ByteBuffer xevent, ByteBuffer xproperty) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkBuffer((Buffer)xproperty, XPropertyEvent.SIZEOF);
        }
        MemoryUtil.memCopy(MemoryUtil.memAddress(xevent) + (long)XPROPERTY, MemoryUtil.memAddress(xproperty), XPropertyEvent.SIZEOF);
    }

    public static int xpropertyType(ByteBuffer xevent) {
        return xevent.getInt(xevent.position() + XPROPERTY + XPropertyEvent.TYPE);
    }

    public static long xpropertySerial(ByteBuffer xevent) {
        return PointerBuffer.get(xevent, xevent.position() + XPROPERTY + XPropertyEvent.SERIAL);
    }

    public static int xpropertySend_event(ByteBuffer xevent) {
        return xevent.getInt(xevent.position() + XPROPERTY + XPropertyEvent.SEND_EVENT);
    }

    public static long xpropertyDisplay(ByteBuffer xevent) {
        return PointerBuffer.get(xevent, xevent.position() + XPROPERTY + XPropertyEvent.DISPLAY);
    }

    public static long xpropertyWindow(ByteBuffer xevent) {
        return PointerBuffer.get(xevent, xevent.position() + XPROPERTY + XPropertyEvent.WINDOW);
    }

    public static long xpropertyAtom(ByteBuffer xevent) {
        return PointerBuffer.get(xevent, xevent.position() + XPROPERTY + XPropertyEvent.ATOM);
    }

    public static long xpropertyTime(ByteBuffer xevent) {
        return PointerBuffer.get(xevent, xevent.position() + XPROPERTY + XPropertyEvent.TIME);
    }

    public static int xpropertyState(ByteBuffer xevent) {
        return xevent.getInt(xevent.position() + XPROPERTY + XPropertyEvent.STATE);
    }

    public static void xselectionrequestGet(ByteBuffer xevent, ByteBuffer xselectionrequest) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkBuffer((Buffer)xselectionrequest, XSelectionRequestEvent.SIZEOF);
        }
        MemoryUtil.memCopy(MemoryUtil.memAddress(xevent) + (long)XSELECTIONREQUEST, MemoryUtil.memAddress(xselectionrequest), XSelectionRequestEvent.SIZEOF);
    }

    public static int xselectionrequestType(ByteBuffer xevent) {
        return xevent.getInt(xevent.position() + XSELECTIONREQUEST + XSelectionRequestEvent.TYPE);
    }

    public static long xselectionrequestSerial(ByteBuffer xevent) {
        return PointerBuffer.get(xevent, xevent.position() + XSELECTIONREQUEST + XSelectionRequestEvent.SERIAL);
    }

    public static int xselectionrequestSend_event(ByteBuffer xevent) {
        return xevent.getInt(xevent.position() + XSELECTIONREQUEST + XSelectionRequestEvent.SEND_EVENT);
    }

    public static long xselectionrequestDisplay(ByteBuffer xevent) {
        return PointerBuffer.get(xevent, xevent.position() + XSELECTIONREQUEST + XSelectionRequestEvent.DISPLAY);
    }

    public static long xselectionrequestOwner(ByteBuffer xevent) {
        return PointerBuffer.get(xevent, xevent.position() + XSELECTIONREQUEST + XSelectionRequestEvent.OWNER);
    }

    public static long xselectionrequestRequestor(ByteBuffer xevent) {
        return PointerBuffer.get(xevent, xevent.position() + XSELECTIONREQUEST + XSelectionRequestEvent.REQUESTOR);
    }

    public static long xselectionrequestSelection(ByteBuffer xevent) {
        return PointerBuffer.get(xevent, xevent.position() + XSELECTIONREQUEST + XSelectionRequestEvent.SELECTION);
    }

    public static long xselectionrequestTarget(ByteBuffer xevent) {
        return PointerBuffer.get(xevent, xevent.position() + XSELECTIONREQUEST + XSelectionRequestEvent.TARGET);
    }

    public static long xselectionrequestProperty(ByteBuffer xevent) {
        return PointerBuffer.get(xevent, xevent.position() + XSELECTIONREQUEST + XSelectionRequestEvent.PROPERTY);
    }

    public static long xselectionrequestTime(ByteBuffer xevent) {
        return PointerBuffer.get(xevent, xevent.position() + XSELECTIONREQUEST + XSelectionRequestEvent.TIME);
    }

    public static void xselectionGet(ByteBuffer xevent, ByteBuffer xselection) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkBuffer((Buffer)xselection, XSelectionEvent.SIZEOF);
        }
        MemoryUtil.memCopy(MemoryUtil.memAddress(xevent) + (long)XSELECTION, MemoryUtil.memAddress(xselection), XSelectionEvent.SIZEOF);
    }

    public static int xselectionType(ByteBuffer xevent) {
        return xevent.getInt(xevent.position() + XSELECTION + XSelectionEvent.TYPE);
    }

    public static long xselectionSerial(ByteBuffer xevent) {
        return PointerBuffer.get(xevent, xevent.position() + XSELECTION + XSelectionEvent.SERIAL);
    }

    public static int xselectionSend_event(ByteBuffer xevent) {
        return xevent.getInt(xevent.position() + XSELECTION + XSelectionEvent.SEND_EVENT);
    }

    public static long xselectionDisplay(ByteBuffer xevent) {
        return PointerBuffer.get(xevent, xevent.position() + XSELECTION + XSelectionEvent.DISPLAY);
    }

    public static long xselectionRequestor(ByteBuffer xevent) {
        return PointerBuffer.get(xevent, xevent.position() + XSELECTION + XSelectionEvent.REQUESTOR);
    }

    public static long xselectionSelection(ByteBuffer xevent) {
        return PointerBuffer.get(xevent, xevent.position() + XSELECTION + XSelectionEvent.SELECTION);
    }

    public static long xselectionTarget(ByteBuffer xevent) {
        return PointerBuffer.get(xevent, xevent.position() + XSELECTION + XSelectionEvent.TARGET);
    }

    public static long xselectionProperty(ByteBuffer xevent) {
        return PointerBuffer.get(xevent, xevent.position() + XSELECTION + XSelectionEvent.PROPERTY);
    }

    public static long xselectionTime(ByteBuffer xevent) {
        return PointerBuffer.get(xevent, xevent.position() + XSELECTION + XSelectionEvent.TIME);
    }

    public static void xclientGet(ByteBuffer xevent, ByteBuffer xclient) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkBuffer((Buffer)xclient, XClientMessageEvent.SIZEOF);
        }
        MemoryUtil.memCopy(MemoryUtil.memAddress(xevent) + (long)XCLIENT, MemoryUtil.memAddress(xclient), XClientMessageEvent.SIZEOF);
    }

    public static int xclientType(ByteBuffer xevent) {
        return xevent.getInt(xevent.position() + XCLIENT + XClientMessageEvent.TYPE);
    }

    public static long xclientSerial(ByteBuffer xevent) {
        return PointerBuffer.get(xevent, xevent.position() + XCLIENT + XClientMessageEvent.SERIAL);
    }

    public static int xclientSend_event(ByteBuffer xevent) {
        return xevent.getInt(xevent.position() + XCLIENT + XClientMessageEvent.SEND_EVENT);
    }

    public static long xclientDisplay(ByteBuffer xevent) {
        return PointerBuffer.get(xevent, xevent.position() + XCLIENT + XClientMessageEvent.DISPLAY);
    }

    public static long xclientWindow(ByteBuffer xevent) {
        return PointerBuffer.get(xevent, xevent.position() + XCLIENT + XClientMessageEvent.WINDOW);
    }

    public static long xclientMessage_type(ByteBuffer xevent) {
        return PointerBuffer.get(xevent, xevent.position() + XCLIENT + XClientMessageEvent.MESSAGE_TYPE);
    }

    public static int xclientFormat(ByteBuffer xevent) {
        return xevent.getInt(xevent.position() + XCLIENT + XClientMessageEvent.FORMAT);
    }

    public static void xclientDataBGet(ByteBuffer xevent, ByteBuffer b) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkBufferGT(b, 20);
        }
        MemoryUtil.memCopy(MemoryUtil.memAddress(xevent) + (long)XCLIENT + (long)XClientMessageEvent.DATA_B, MemoryUtil.memAddress(b), b.remaining());
    }

    public static byte xclientDataB(ByteBuffer xevent, int index) {
        return xevent.get(XCLIENT + XClientMessageEvent.DATA_B + index * 1);
    }

    public static void xclientDataSGet(ByteBuffer xevent, ByteBuffer s) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkBufferGT(s, 20);
        }
        MemoryUtil.memCopy(MemoryUtil.memAddress(xevent) + (long)XCLIENT + (long)XClientMessageEvent.DATA_S, MemoryUtil.memAddress(s), s.remaining());
    }

    public static short xclientDataS(ByteBuffer xevent, int index) {
        return xevent.getShort(XCLIENT + XClientMessageEvent.DATA_S + index * 2);
    }

    public static void xclientDataLGet(ByteBuffer xevent, ByteBuffer l) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkBufferGT(l, 40);
        }
        MemoryUtil.memCopy(MemoryUtil.memAddress(xevent) + (long)XCLIENT + (long)XClientMessageEvent.DATA_L, MemoryUtil.memAddress(l), l.remaining());
    }

    public static long xclientDataL(ByteBuffer xevent, int index) {
        return xevent.getLong(XCLIENT + XClientMessageEvent.DATA_L + index * 8);
    }

    public static void xerrorGet(ByteBuffer xevent, ByteBuffer xerror) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkBuffer((Buffer)xerror, XErrorEvent.SIZEOF);
        }
        MemoryUtil.memCopy(MemoryUtil.memAddress(xevent) + (long)XERROR, MemoryUtil.memAddress(xerror), XErrorEvent.SIZEOF);
    }

    public static int xerrorType(ByteBuffer xevent) {
        return xevent.getInt(xevent.position() + XERROR + XErrorEvent.TYPE);
    }

    public static long xerrorDisplay(ByteBuffer xevent) {
        return PointerBuffer.get(xevent, xevent.position() + XERROR + XErrorEvent.DISPLAY);
    }

    public static long xerrorSerial(ByteBuffer xevent) {
        return PointerBuffer.get(xevent, xevent.position() + XERROR + XErrorEvent.SERIAL);
    }

    public static int xerrorError_code(ByteBuffer xevent) {
        return xevent.get(xevent.position() + XERROR + XErrorEvent.ERROR_CODE) & 0xFF;
    }

    public static int xerrorRequest_code(ByteBuffer xevent) {
        return xevent.get(xevent.position() + XERROR + XErrorEvent.REQUEST_CODE) & 0xFF;
    }

    public static int xerrorMinor_code(ByteBuffer xevent) {
        return xevent.get(xevent.position() + XERROR + XErrorEvent.MINOR_CODE) & 0xFF;
    }

    public static long xerrorResourceid(ByteBuffer xevent) {
        return PointerBuffer.get(xevent, xevent.position() + XERROR + XErrorEvent.RESOURCEID);
    }

    public static void xcookieGet(ByteBuffer xevent, ByteBuffer xcookie) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkBuffer((Buffer)xcookie, XGenericEventCookie.SIZEOF);
        }
        MemoryUtil.memCopy(MemoryUtil.memAddress(xevent) + (long)XCOOKIE, MemoryUtil.memAddress(xcookie), XGenericEventCookie.SIZEOF);
    }

    public static int xcookieType(ByteBuffer xevent) {
        return xevent.getInt(xevent.position() + XCOOKIE + XGenericEventCookie.TYPE);
    }

    public static long xcookieSerial(ByteBuffer xevent) {
        return PointerBuffer.get(xevent, xevent.position() + XCOOKIE + XGenericEventCookie.SERIAL);
    }

    public static int xcookieSend_event(ByteBuffer xevent) {
        return xevent.getInt(xevent.position() + XCOOKIE + XGenericEventCookie.SEND_EVENT);
    }

    public static long xcookieDisplay(ByteBuffer xevent) {
        return PointerBuffer.get(xevent, xevent.position() + XCOOKIE + XGenericEventCookie.DISPLAY);
    }

    public static int xcookieExtension(ByteBuffer xevent) {
        return xevent.getInt(xevent.position() + XCOOKIE + XGenericEventCookie.EXTENSION);
    }

    public static int xcookieEvtype(ByteBuffer xevent) {
        return xevent.getInt(xevent.position() + XCOOKIE + XGenericEventCookie.EVTYPE);
    }

    public static int xcookieCookie(ByteBuffer xevent) {
        return xevent.getInt(xevent.position() + XCOOKIE + XGenericEventCookie.COOKIE);
    }

    public static long xcookieData(ByteBuffer xevent) {
        return PointerBuffer.get(xevent, xevent.position() + XCOOKIE + XGenericEventCookie.DATA);
    }

    public static ByteBuffer xcookieData(ByteBuffer xevent, int byteLen) {
        return MemoryUtil.memByteBuffer(XEvent.xcookieData(xevent), byteLen);
    }

    static {
        IntBuffer offsets = BufferUtils.createIntBuffer(12);
        SIZEOF = XEvent.offsets(MemoryUtil.memAddress(offsets));
        TYPE = offsets.get(0);
        XANY = offsets.get(1);
        XKEY = offsets.get(2);
        XBUTTON = offsets.get(3);
        XMOTION = offsets.get(4);
        XCONFIGURE = offsets.get(5);
        XPROPERTY = offsets.get(6);
        XSELECTIONREQUEST = offsets.get(7);
        XSELECTION = offsets.get(8);
        XCLIENT = offsets.get(9);
        XERROR = offsets.get(10);
        XCOOKIE = offsets.get(11);
    }
}

