/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.system.linux;

import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import org.lwjgl.BufferUtils;
import org.lwjgl.LWJGLUtil;
import org.lwjgl.Pointer;
import org.lwjgl.PointerBuffer;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryUtil;

public final class XErrorEvent
implements Pointer {
    public static final int SIZEOF;
    public static final int TYPE;
    public static final int DISPLAY;
    public static final int SERIAL;
    public static final int ERROR_CODE;
    public static final int REQUEST_CODE;
    public static final int MINOR_CODE;
    public static final int RESOURCEID;
    private final ByteBuffer struct;

    public XErrorEvent() {
        this(XErrorEvent.malloc());
    }

    public XErrorEvent(ByteBuffer struct) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkBuffer((Buffer)struct, SIZEOF);
        }
        this.struct = struct;
    }

    public ByteBuffer buffer() {
        return this.struct;
    }

    @Override
    public long getPointer() {
        return MemoryUtil.memAddress(this.struct);
    }

    public void setType(int type) {
        XErrorEvent.type(this.struct, type);
    }

    public void setDisplay(long display) {
        XErrorEvent.display(this.struct, display);
    }

    public void setSerial(long serial) {
        XErrorEvent.serial(this.struct, serial);
    }

    public void setErrorCode(int error_code) {
        XErrorEvent.error_code(this.struct, error_code);
    }

    public void setRequestCode(int request_code) {
        XErrorEvent.request_code(this.struct, request_code);
    }

    public void setMinorCode(int minor_code) {
        XErrorEvent.minor_code(this.struct, minor_code);
    }

    public void setResourceid(long resourceid) {
        XErrorEvent.resourceid(this.struct, resourceid);
    }

    public int getType() {
        return XErrorEvent.type(this.struct);
    }

    public long getDisplay() {
        return XErrorEvent.display(this.struct);
    }

    public long getSerial() {
        return XErrorEvent.serial(this.struct);
    }

    public int getErrorCode() {
        return XErrorEvent.error_code(this.struct);
    }

    public int getRequestCode() {
        return XErrorEvent.request_code(this.struct);
    }

    public int getMinorCode() {
        return XErrorEvent.minor_code(this.struct);
    }

    public long getResourceid() {
        return XErrorEvent.resourceid(this.struct);
    }

    private static native int offsets(long var0);

    public static ByteBuffer malloc() {
        return BufferUtils.createByteBuffer(SIZEOF);
    }

    public static ByteBuffer malloc(int type, long display, long serial, int error_code, int request_code, int minor_code, long resourceid) {
        ByteBuffer xerrorevent = XErrorEvent.malloc();
        XErrorEvent.type(xerrorevent, type);
        XErrorEvent.display(xerrorevent, display);
        XErrorEvent.serial(xerrorevent, serial);
        XErrorEvent.error_code(xerrorevent, error_code);
        XErrorEvent.request_code(xerrorevent, request_code);
        XErrorEvent.minor_code(xerrorevent, minor_code);
        XErrorEvent.resourceid(xerrorevent, resourceid);
        return xerrorevent;
    }

    public static void type(ByteBuffer xerrorevent, int type) {
        xerrorevent.putInt(xerrorevent.position() + TYPE, type);
    }

    public static void display(ByteBuffer xerrorevent, long display) {
        PointerBuffer.put(xerrorevent, xerrorevent.position() + DISPLAY, display);
    }

    public static void serial(ByteBuffer xerrorevent, long serial) {
        PointerBuffer.put(xerrorevent, xerrorevent.position() + SERIAL, serial);
    }

    public static void error_code(ByteBuffer xerrorevent, int error_code) {
        xerrorevent.put(xerrorevent.position() + ERROR_CODE, (byte)error_code);
    }

    public static void request_code(ByteBuffer xerrorevent, int request_code) {
        xerrorevent.put(xerrorevent.position() + REQUEST_CODE, (byte)request_code);
    }

    public static void minor_code(ByteBuffer xerrorevent, int minor_code) {
        xerrorevent.put(xerrorevent.position() + MINOR_CODE, (byte)minor_code);
    }

    public static void resourceid(ByteBuffer xerrorevent, long resourceid) {
        PointerBuffer.put(xerrorevent, xerrorevent.position() + RESOURCEID, resourceid);
    }

    public static int type(ByteBuffer xerrorevent) {
        return xerrorevent.getInt(xerrorevent.position() + TYPE);
    }

    public static long display(ByteBuffer xerrorevent) {
        return PointerBuffer.get(xerrorevent, xerrorevent.position() + DISPLAY);
    }

    public static long serial(ByteBuffer xerrorevent) {
        return PointerBuffer.get(xerrorevent, xerrorevent.position() + SERIAL);
    }

    public static int error_code(ByteBuffer xerrorevent) {
        return xerrorevent.get(xerrorevent.position() + ERROR_CODE) & 0xFF;
    }

    public static int request_code(ByteBuffer xerrorevent) {
        return xerrorevent.get(xerrorevent.position() + REQUEST_CODE) & 0xFF;
    }

    public static int minor_code(ByteBuffer xerrorevent) {
        return xerrorevent.get(xerrorevent.position() + MINOR_CODE) & 0xFF;
    }

    public static long resourceid(ByteBuffer xerrorevent) {
        return PointerBuffer.get(xerrorevent, xerrorevent.position() + RESOURCEID);
    }

    static {
        IntBuffer offsets = BufferUtils.createIntBuffer(7);
        SIZEOF = XErrorEvent.offsets(MemoryUtil.memAddress(offsets));
        TYPE = offsets.get(0);
        DISPLAY = offsets.get(1);
        SERIAL = offsets.get(2);
        ERROR_CODE = offsets.get(3);
        REQUEST_CODE = offsets.get(4);
        MINOR_CODE = offsets.get(5);
        RESOURCEID = offsets.get(6);
    }
}

