/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.system.linux;

import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import org.lwjgl.BufferUtils;
import org.lwjgl.LWJGLUtil;
import org.lwjgl.Pointer;
import org.lwjgl.PointerBuffer;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryUtil;

public final class XComposeStatus
implements Pointer {
    public static final int SIZEOF;
    public static final int COMPOSE_PTR;
    public static final int CHARS_MATCHED;
    private final ByteBuffer struct;

    public XComposeStatus() {
        this(XComposeStatus.malloc());
    }

    public XComposeStatus(ByteBuffer struct) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkBuffer((Buffer)struct, SIZEOF);
        }
        this.struct = struct;
    }

    public ByteBuffer buffer() {
        return this.struct;
    }

    @Override
    public long getPointer() {
        return MemoryUtil.memAddress(this.struct);
    }

    public void setComposePtr(long compose_ptr) {
        XComposeStatus.compose_ptr(this.struct, compose_ptr);
    }

    public void setComposePtr(ByteBuffer compose_ptr) {
        XComposeStatus.compose_ptr(this.struct, compose_ptr);
    }

    public void setCharsMatched(int chars_matched) {
        XComposeStatus.chars_matched(this.struct, chars_matched);
    }

    public long getComposePtr() {
        return XComposeStatus.compose_ptr(this.struct);
    }

    public ByteBuffer getComposePtr(int byteLen) {
        return XComposeStatus.compose_ptr(this.struct, byteLen);
    }

    public int getCharsMatched() {
        return XComposeStatus.chars_matched(this.struct);
    }

    private static native int offsets(long var0);

    public static ByteBuffer malloc() {
        return BufferUtils.createByteBuffer(SIZEOF);
    }

    public static ByteBuffer malloc(ByteBuffer compose_ptr, int chars_matched) {
        ByteBuffer xcomposestatus = XComposeStatus.malloc();
        XComposeStatus.compose_ptr(xcomposestatus, compose_ptr);
        XComposeStatus.chars_matched(xcomposestatus, chars_matched);
        return xcomposestatus;
    }

    public static void compose_ptr(ByteBuffer xcomposestatus, long compose_ptr) {
        PointerBuffer.put(xcomposestatus, xcomposestatus.position() + COMPOSE_PTR, compose_ptr);
    }

    public static void compose_ptr(ByteBuffer xcomposestatus, ByteBuffer compose_ptr) {
        XComposeStatus.compose_ptr(xcomposestatus, MemoryUtil.memAddressSafe(compose_ptr));
    }

    public static void chars_matched(ByteBuffer xcomposestatus, int chars_matched) {
        xcomposestatus.putInt(xcomposestatus.position() + CHARS_MATCHED, chars_matched);
    }

    public static long compose_ptr(ByteBuffer xcomposestatus) {
        return PointerBuffer.get(xcomposestatus, xcomposestatus.position() + COMPOSE_PTR);
    }

    public static ByteBuffer compose_ptr(ByteBuffer xcomposestatus, int byteLen) {
        return MemoryUtil.memByteBuffer(XComposeStatus.compose_ptr(xcomposestatus), byteLen);
    }

    public static int chars_matched(ByteBuffer xcomposestatus) {
        return xcomposestatus.getInt(xcomposestatus.position() + CHARS_MATCHED);
    }

    static {
        IntBuffer offsets = BufferUtils.createIntBuffer(2);
        SIZEOF = XComposeStatus.offsets(MemoryUtil.memAddress(offsets));
        COMPOSE_PTR = offsets.get(0);
        CHARS_MATCHED = offsets.get(1);
    }
}

