/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.system.linux;

import java.nio.Buffer;
import java.nio.ByteBuffer;
import org.lwjgl.LWJGLUtil;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.linux.timespec;
import org.lwjgl.system.linux.timeval;
import org.lwjgl.system.linux.timezone;

public final class Time {
    public static final int CLOCK_REALTIME = 0;
    public static final int CLOCK_MONOTONIC = 1;
    public static final int CLOCK_PROCESS_CPUTIME_ID = 2;
    public static final int CLOCK_THREAD_CPUTIME_ID = 3;
    public static final int CLOCK_MONOTONIC_RAW = 4;
    public static final int CLOCK_REALTIME_COARSE = 5;
    public static final int CLOCK_MONOTONIC_COARSE = 6;
    public static final int CLOCK_BOOTTIME = 7;
    public static final int CLOCK_REALTIME_ALARM = 8;
    public static final int CLOCK_BOOTTIME_ALARM = 9;

    private Time() {
    }

    public static native int nclock_getres(int var0, long var1);

    public static int clock_getres(int clk_id, ByteBuffer res) {
        if (LWJGLUtil.CHECKS && res != null) {
            Checks.checkBuffer((Buffer)res, timespec.SIZEOF);
        }
        return Time.nclock_getres(clk_id, MemoryUtil.memAddressSafe(res));
    }

    public static native int nclock_gettime(int var0, long var1);

    public static int clock_gettime(int clk_id, ByteBuffer tp) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkBuffer((Buffer)tp, timespec.SIZEOF);
        }
        return Time.nclock_gettime(clk_id, MemoryUtil.memAddress(tp));
    }

    public static native int ngettimeofday(long var0, long var2);

    public static int gettimeofday(ByteBuffer tv, ByteBuffer tz) {
        if (LWJGLUtil.CHECKS) {
            if (tv != null) {
                Checks.checkBuffer((Buffer)tv, timeval.SIZEOF);
            }
            if (tz != null) {
                Checks.checkBuffer((Buffer)tz, timezone.SIZEOF);
            }
        }
        return Time.ngettimeofday(MemoryUtil.memAddressSafe(tv), MemoryUtil.memAddressSafe(tz));
    }

    static {
        LWJGLUtil.initialize();
    }
}

