/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.system.libffi;

import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import org.lwjgl.BufferUtils;
import org.lwjgl.LWJGLUtil;
import org.lwjgl.Pointer;
import org.lwjgl.PointerBuffer;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryUtil;

public final class FFICIF
implements Pointer {
    public static final int SIZEOF;
    public static final int ABI;
    public static final int NARGS;
    public static final int ARG_TYPES;
    public static final int RTYPE;
    public static final int BYTES;
    public static final int FLAGS;
    private final ByteBuffer struct;

    public FFICIF() {
        this(FFICIF.malloc());
    }

    public FFICIF(ByteBuffer struct) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkBuffer((Buffer)struct, SIZEOF);
        }
        this.struct = struct;
    }

    public ByteBuffer buffer() {
        return this.struct;
    }

    @Override
    public long getPointer() {
        return MemoryUtil.memAddress(this.struct);
    }

    public void setAbi(int abi) {
        FFICIF.abi(this.struct, abi);
    }

    public void setNargs(int nargs) {
        FFICIF.nargs(this.struct, nargs);
    }

    public void setArgTypes(long arg_types) {
        FFICIF.arg_types(this.struct, arg_types);
    }

    public void setArgTypes(ByteBuffer arg_types) {
        FFICIF.arg_types(this.struct, arg_types);
    }

    public void setRtype(long rtype) {
        FFICIF.rtype(this.struct, rtype);
    }

    public void setBytes(int bytes) {
        FFICIF.bytes(this.struct, bytes);
    }

    public void setFlags(int flags) {
        FFICIF.flags(this.struct, flags);
    }

    public int getAbi() {
        return FFICIF.abi(this.struct);
    }

    public int getNargs() {
        return FFICIF.nargs(this.struct);
    }

    public long getArgTypes() {
        return FFICIF.arg_types(this.struct);
    }

    public ByteBuffer getArgTypes(int byteLen) {
        return FFICIF.arg_types(this.struct, byteLen);
    }

    public long getRtype() {
        return FFICIF.rtype(this.struct);
    }

    public int getBytes() {
        return FFICIF.bytes(this.struct);
    }

    public int getFlags() {
        return FFICIF.flags(this.struct);
    }

    private static native int offsets(long var0);

    public static ByteBuffer malloc() {
        return BufferUtils.createByteBuffer(SIZEOF);
    }

    public static ByteBuffer malloc(int abi, int nargs, ByteBuffer arg_types, long rtype, int bytes, int flags) {
        ByteBuffer ffi_cif = FFICIF.malloc();
        FFICIF.abi(ffi_cif, abi);
        FFICIF.nargs(ffi_cif, nargs);
        FFICIF.arg_types(ffi_cif, arg_types);
        FFICIF.rtype(ffi_cif, rtype);
        FFICIF.bytes(ffi_cif, bytes);
        FFICIF.flags(ffi_cif, flags);
        return ffi_cif;
    }

    public static void abi(ByteBuffer ffi_cif, int abi) {
        ffi_cif.putInt(ffi_cif.position() + ABI, abi);
    }

    public static void nargs(ByteBuffer ffi_cif, int nargs) {
        ffi_cif.putInt(ffi_cif.position() + NARGS, nargs);
    }

    public static void arg_types(ByteBuffer ffi_cif, long arg_types) {
        PointerBuffer.put(ffi_cif, ffi_cif.position() + ARG_TYPES, arg_types);
    }

    public static void arg_types(ByteBuffer ffi_cif, ByteBuffer arg_types) {
        FFICIF.arg_types(ffi_cif, MemoryUtil.memAddressSafe(arg_types));
    }

    public static void rtype(ByteBuffer ffi_cif, long rtype) {
        PointerBuffer.put(ffi_cif, ffi_cif.position() + RTYPE, rtype);
    }

    public static void bytes(ByteBuffer ffi_cif, int bytes) {
        ffi_cif.putInt(ffi_cif.position() + BYTES, bytes);
    }

    public static void flags(ByteBuffer ffi_cif, int flags) {
        ffi_cif.putInt(ffi_cif.position() + FLAGS, flags);
    }

    public static int abi(ByteBuffer ffi_cif) {
        return ffi_cif.getInt(ffi_cif.position() + ABI);
    }

    public static int nargs(ByteBuffer ffi_cif) {
        return ffi_cif.getInt(ffi_cif.position() + NARGS);
    }

    public static long arg_types(ByteBuffer ffi_cif) {
        return PointerBuffer.get(ffi_cif, ffi_cif.position() + ARG_TYPES);
    }

    public static ByteBuffer arg_types(ByteBuffer ffi_cif, int byteLen) {
        return MemoryUtil.memByteBuffer(FFICIF.arg_types(ffi_cif), byteLen);
    }

    public static long rtype(ByteBuffer ffi_cif) {
        return PointerBuffer.get(ffi_cif, ffi_cif.position() + RTYPE);
    }

    public static int bytes(ByteBuffer ffi_cif) {
        return ffi_cif.getInt(ffi_cif.position() + BYTES);
    }

    public static int flags(ByteBuffer ffi_cif) {
        return ffi_cif.getInt(ffi_cif.position() + FLAGS);
    }

    static {
        IntBuffer offsets = BufferUtils.createIntBuffer(6);
        SIZEOF = FFICIF.offsets(MemoryUtil.memAddress(offsets));
        ABI = offsets.get(0);
        NARGS = offsets.get(1);
        ARG_TYPES = offsets.get(2);
        RTYPE = offsets.get(3);
        BYTES = offsets.get(4);
        FLAGS = offsets.get(5);
    }
}

