/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.system.libffi;

import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.nio.ByteBuffer;
import org.lwjgl.BufferUtils;
import org.lwjgl.LWJGLUtil;
import org.lwjgl.Pointer;
import org.lwjgl.PointerBuffer;
import org.lwjgl.system.APIBuffer;
import org.lwjgl.system.APIUtil;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.Retainable;
import org.lwjgl.system.libffi.ClosureRegistry;
import org.lwjgl.system.libffi.FFIClosure;
import org.lwjgl.system.libffi.LibFFI;

public abstract class Closure
extends Retainable.Default
implements Pointer {
    protected static final long NATIVE_CALLBACK_VOID;
    protected static final long NATIVE_CALLBACK_BYTE;
    protected static final long NATIVE_CALLBACK_SHORT;
    protected static final long NATIVE_CALLBACK_INT;
    protected static final long NATIVE_CALLBACK_LONG;
    protected static final long NATIVE_CALLBACK_FLOAT;
    protected static final long NATIVE_CALLBACK_DOUBLE;
    protected static final long NATIVE_CALLBACK_PTR;
    protected static final int CALL_CONVENTION_DEFAULT;
    protected static final int CALL_CONVENTION_SYSTEM;
    private static final ClosureRegistry registry;
    private long jweak;
    private final long closure;
    private final long pointer;

    Closure(ByteBuffer cif, long nativeCallback) {
        APIBuffer __buf = APIUtil.apiStack();
        this.closure = LibFFI.nffi_closure_alloc(FFIClosure.SIZEOF, __buf.address(__buf.getOffset()));
        this.pointer = __buf.pointerValue(__buf.getOffset());
        __buf.pop();
        if (this.closure == 0L) {
            throw new OutOfMemoryError("Failed to allocate libffi closure.");
        }
        this.jweak = MemoryUtil.memNewWeakGlobalRef(this);
        int status = LibFFI.nffi_prep_closure_loc(this.closure, MemoryUtil.memAddress(cif), nativeCallback, this.jweak, this.pointer);
        if (status != 0) {
            this.destroy();
            throw new IllegalStateException(String.format("Failed to prepare libffi closure. Status: 0x%X", status));
        }
        if (registry != null) {
            registry.register(this);
        }
    }

    @Override
    public long getPointer() {
        if (this.isDestroyed()) {
            throw new IllegalStateException("This closure instance has been destroyed.");
        }
        return this.pointer;
    }

    @Override
    protected void destroy() {
        if (this.isDestroyed()) {
            throw new IllegalStateException("This closure instance has been destroyed.");
        }
        MemoryUtil.memDeleteWeakGlobalRef(this.jweak);
        this.jweak = 0L;
        LibFFI.nffi_closure_free(this.closure);
    }

    public boolean isDestroyed() {
        return this.jweak == 0L;
    }

    public static <T extends Closure> T create(long functionPointer) {
        if (functionPointer == 0L) {
            return null;
        }
        return (T)((Closure)MemoryUtil.memGlobalRefToObject(MemoryUtil.memGetAddress(functionPointer + (long)FFIClosure.USER_DATA)));
    }

    public static void release(long functionPointer) {
        Object clojure = Closure.create(functionPointer);
        if (clojure != null) {
            ((Retainable.Default)clojure).release();
        }
    }

    private static native long getNativeCallbacks(Method[] var0, long var1);

    static {
        PointerBuffer callbacks = BufferUtils.createPointerBuffer(8);
        try {
            Class[] params = new Class[]{java.lang.Long.TYPE};
            Closure.getNativeCallbacks(new Method[]{Void.class.getDeclaredMethod("callback", params), Byte.class.getDeclaredMethod("callback", params), Short.class.getDeclaredMethod("callback", params), Int.class.getDeclaredMethod("callback", params), Long.class.getDeclaredMethod("callback", params), Float.class.getDeclaredMethod("callback", params), Double.class.getDeclaredMethod("callback", params), Ptr.class.getDeclaredMethod("callback", params)}, MemoryUtil.memAddress(callbacks));
        }
        catch (NoSuchMethodException e) {
            throw new IllegalStateException("Failed to initialize closure callbacks.", e);
        }
        NATIVE_CALLBACK_VOID = callbacks.get(0);
        NATIVE_CALLBACK_BYTE = callbacks.get(1);
        NATIVE_CALLBACK_SHORT = callbacks.get(2);
        NATIVE_CALLBACK_INT = callbacks.get(3);
        NATIVE_CALLBACK_LONG = callbacks.get(4);
        NATIVE_CALLBACK_FLOAT = callbacks.get(5);
        NATIVE_CALLBACK_DOUBLE = callbacks.get(6);
        NATIVE_CALLBACK_PTR = callbacks.get(7);
        CALL_CONVENTION_DEFAULT = LibFFI.FFI_DEFAULT_ABI;
        CALL_CONVENTION_SYSTEM = LWJGLUtil.getPlatform() == LWJGLUtil.Platform.WINDOWS && Pointer.BITS32 ? 2 : LibFFI.FFI_DEFAULT_ABI;
        String factoryClass = System.getProperty("org.lwjgl.system.libffi.ClosureRegistry");
        if (factoryClass == null) {
            registry = null;
        } else {
            try {
                Class<?> factory = Class.forName(factoryClass);
                Method create = factory.getMethod("get", new Class[0]);
                if (!Modifier.isStatic(create.getModifiers()) || !ClosureRegistry.class.isAssignableFrom(create.getReturnType())) {
                    throw new IllegalArgumentException("Invalid ClosureRegistry specified.");
                }
                registry = (ClosureRegistry)create.invoke(null, new Object[0]);
            }
            catch (Exception e) {
                throw new IllegalStateException("Failed to initialize the Closure registry.", e);
            }
        }
    }

    public static abstract class Ptr
    extends Closure {
        protected Ptr(ByteBuffer cif) {
            super(cif, NATIVE_CALLBACK_PTR);
        }

        protected abstract long callback(long var1);
    }

    public static abstract class Double
    extends Closure {
        protected Double(ByteBuffer cif) {
            super(cif, NATIVE_CALLBACK_DOUBLE);
        }

        protected abstract int callback(long var1);
    }

    public static abstract class Float
    extends Closure {
        protected Float(ByteBuffer cif) {
            super(cif, NATIVE_CALLBACK_FLOAT);
        }

        protected abstract int callback(long var1);
    }

    public static abstract class Long
    extends Closure {
        protected Long(ByteBuffer cif) {
            super(cif, NATIVE_CALLBACK_LONG);
        }

        protected abstract int callback(long var1);
    }

    public static abstract class Int
    extends Closure {
        protected Int(ByteBuffer cif) {
            super(cif, NATIVE_CALLBACK_INT);
        }

        protected abstract int callback(long var1);
    }

    public static abstract class Short
    extends Closure {
        protected Short(ByteBuffer cif) {
            super(cif, NATIVE_CALLBACK_SHORT);
        }

        protected abstract short callback(long var1);
    }

    public static abstract class Byte
    extends Closure {
        protected Byte(ByteBuffer cif) {
            super(cif, NATIVE_CALLBACK_BYTE);
        }

        protected abstract byte callback(long var1);
    }

    public static abstract class Void
    extends Closure {
        protected Void(ByteBuffer cif) {
            super(cif, NATIVE_CALLBACK_VOID);
        }

        protected abstract void callback(long var1);
    }
}

