/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.system;

import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import org.lwjgl.PointerBuffer;

public final class Checks {
    private Checks() {
    }

    public static boolean checkFunctions(long ... functions) {
        for (long pointer : functions) {
            if (pointer != 0L) continue;
            return false;
        }
        return true;
    }

    public static long checkFunctionAddress(long pointer) {
        if (pointer == 0L) {
            throw new IllegalStateException("Function is not supported");
        }
        return pointer;
    }

    public static long checkPointer(long pointer) {
        if (pointer == 0L) {
            throw new NullPointerException();
        }
        return pointer;
    }

    public static ByteBuffer checkNT1(ByteBuffer buf) {
        Checks.checkBuffer((Buffer)buf, 1);
        if (buf.get(buf.limit() - 1) != 0) {
            throw new IllegalArgumentException("Missing null termination");
        }
        return buf;
    }

    public static ByteBuffer checkNT2(ByteBuffer buf) {
        Checks.checkBuffer((Buffer)buf, 2);
        if (buf.getShort(buf.limit() - 2) != 0) {
            throw new IllegalArgumentException("Missing null termination");
        }
        return buf;
    }

    public static ByteBuffer checkNT4(ByteBuffer buf) {
        Checks.checkBuffer((Buffer)buf, 4);
        if (buf.getInt(buf.limit() - 4) != 0) {
            throw new IllegalArgumentException("Missing null termination");
        }
        return buf;
    }

    public static ByteBuffer checkNT8(ByteBuffer buf) {
        Checks.checkBuffer((Buffer)buf, 8);
        if (buf.getLong(buf.limit() - 8) != 0L) {
            throw new IllegalArgumentException("Missing null termination");
        }
        return buf;
    }

    public static IntBuffer checkNT(IntBuffer buf) {
        Checks.checkBuffer((Buffer)buf, 1);
        if (buf.get(buf.limit() - 1) != 0) {
            throw new IllegalArgumentException("Missing null termination");
        }
        return buf;
    }

    public static FloatBuffer checkNT(FloatBuffer buf) {
        Checks.checkBuffer((Buffer)buf, 1);
        if (buf.get(buf.limit() - 1) != 0.0f) {
            throw new IllegalArgumentException("Missing null termination");
        }
        return buf;
    }

    public static PointerBuffer checkNT(PointerBuffer buf) {
        Checks.checkBuffer(buf, 1);
        if (buf.get(buf.limit() - 1) != 0L) {
            throw new IllegalArgumentException("Missing null termination");
        }
        return buf;
    }

    public static void checkNTArray(ByteBuffer buf, int count) {
        int nullFound = 0;
        for (int i = buf.position(); i < buf.limit(); ++i) {
            if (buf.get(i) != 0) continue;
            ++nullFound;
        }
        if (nullFound < count) {
            throw new IllegalArgumentException("Missing null termination");
        }
    }

    public static void checkBuffer(Buffer buf, int size) {
        if (buf.remaining() < size) {
            Checks.throwBufferSizeException(buf, size);
        }
    }

    public static void checkBuffer(Buffer buf, long size) {
        Checks.checkBuffer(buf, (int)size);
    }

    public static void checkBuffer(PointerBuffer buf, int size) {
        if (buf.remaining() < size) {
            Checks.throwBufferSizeException(buf, size);
        }
    }

    public static void checkArray(Object[] array, int size) {
        if (array.length < size) {
            Checks.throwArraySizeException(array, size);
        }
    }

    public static void checkArray(long[] array, int size) {
        if (array.length < size) {
            Checks.throwArraySizeException(array, size);
        }
    }

    public static void checkBufferGT(Buffer buf, int size) {
        if (size < buf.remaining()) {
            Checks.throwBufferSizeGTException(buf, size);
        }
    }

    private static void throwBufferSizeException(Buffer buf, int size) {
        throw new IllegalArgumentException("Number of remaining buffer elements is " + buf.remaining() + ", must be at least " + size);
    }

    private static void throwBufferSizeException(PointerBuffer buf, int size) {
        throw new IllegalArgumentException("Number of remaining pointer buffer elements is " + buf.remaining() + ", must be at least " + size);
    }

    private static void throwArraySizeException(Object[] array, int size) {
        throw new IllegalArgumentException("Number of array elements is " + array.length + ", must be at least " + size);
    }

    private static void throwArraySizeException(long[] array, int size) {
        throw new IllegalArgumentException("Number of array elements is " + array.length + ", must be at least " + size);
    }

    private static void throwBufferSizeGTException(Buffer buf, int size) {
        throw new IllegalArgumentException("Number of remaining buffer elements is " + buf.remaining() + ", must be at most " + size + ".");
    }
}

