/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.opengl;

import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import java.util.Set;
import org.lwjgl.LWJGLUtil;
import org.lwjgl.opengl.GL;
import org.lwjgl.system.Checks;
import org.lwjgl.system.FunctionProvider;
import org.lwjgl.system.MemoryUtil;

public final class WGLARBRenderTexture {
    public static final int WGL_BIND_TO_TEXTURE_RGB_ARB = 8304;
    public static final int WGL_BIND_TO_TEXTURE_RGBA_ARB = 8305;
    public static final int WGL_TEXTURE_FORMAT_ARB = 8306;
    public static final int WGL_TEXTURE_TARGET_ARB = 8307;
    public static final int WGL_MIPMAP_TEXTURE_ARB = 8308;
    public static final int WGL_TEXTURE_RGB_ARB = 8309;
    public static final int WGL_TEXTURE_RGBA_ARB = 8310;
    public static final int WGL_NO_TEXTURE_ARB = 8311;
    public static final int WGL_TEXTURE_CUBE_MAP_ARB = 8312;
    public static final int WGL_TEXTURE_1D_ARB = 8313;
    public static final int WGL_TEXTURE_2D_ARB = 8314;
    public static final int WGL_MIPMAP_LEVEL_ARB = 8315;
    public static final int WGL_CUBE_MAP_FACE_ARB = 8316;
    public static final int WGL_TEXTURE_CUBE_MAP_POSITIVE_X_ARB = 8317;
    public static final int WGL_TEXTURE_CUBE_MAP_NEGATIVE_X_ARB = 8318;
    public static final int WGL_TEXTURE_CUBE_MAP_POSITIVE_Y_ARB = 8319;
    public static final int WGL_TEXTURE_CUBE_MAP_NEGATIVE_Y_ARB = 8320;
    public static final int WGL_TEXTURE_CUBE_MAP_POSITIVE_Z_ARB = 8321;
    public static final int WGL_TEXTURE_CUBE_MAP_NEGATIVE_Z_ARB = 8322;
    public static final int WGL_FRONT_LEFT_ARB = 8323;
    public static final int WGL_FRONT_RIGHT_ARB = 8324;
    public static final int WGL_BACK_LEFT_ARB = 8325;
    public static final int WGL_BACK_RIGHT_ARB = 8326;
    public static final int WGL_AUX0_ARB = 8327;
    public static final int WGL_AUX1_ARB = 8328;
    public static final int WGL_AUX2_ARB = 8329;
    public static final int WGL_AUX3_ARB = 8330;
    public static final int WGL_AUX4_ARB = 8331;
    public static final int WGL_AUX5_ARB = 8332;
    public static final int WGL_AUX6_ARB = 8333;
    public static final int WGL_AUX7_ARB = 8334;
    public static final int WGL_AUX8_ARB = 8335;
    public static final int WGL_AUX9_ARB = 8336;
    public final long BindTexImageARB;
    public final long ReleaseTexImageARB;
    public final long SetPbufferAttribARB;

    public WGLARBRenderTexture(FunctionProvider provider) {
        this.BindTexImageARB = provider.getFunctionAddress("wglBindTexImageARB");
        this.ReleaseTexImageARB = provider.getFunctionAddress("wglReleaseTexImageARB");
        this.SetPbufferAttribARB = provider.getFunctionAddress("wglSetPbufferAttribARB");
    }

    public static WGLARBRenderTexture getInstance() {
        return GL.getCapabilities().__WGLARBRenderTexture;
    }

    static WGLARBRenderTexture create(Set<String> ext, FunctionProvider provider) {
        if (!ext.contains("WGL_ARB_render_texture")) {
            return null;
        }
        WGLARBRenderTexture funcs = new WGLARBRenderTexture(provider);
        boolean supported = Checks.checkFunctions(funcs.BindTexImageARB, funcs.ReleaseTexImageARB, funcs.SetPbufferAttribARB);
        return GL.checkExtension("WGL_ARB_render_texture", funcs, supported);
    }

    public static native int nwglBindTexImageARB(long var0, int var2, long var3);

    public static int wglBindTexImageARB(long pbuffer, int buffer) {
        long __functionAddress = WGLARBRenderTexture.getInstance().BindTexImageARB;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
            Checks.checkPointer(pbuffer);
        }
        return WGLARBRenderTexture.nwglBindTexImageARB(pbuffer, buffer, __functionAddress);
    }

    public static native int nwglReleaseTexImageARB(long var0, int var2, long var3);

    public static int wglReleaseTexImageARB(long pbuffer, int buffer) {
        long __functionAddress = WGLARBRenderTexture.getInstance().ReleaseTexImageARB;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
            Checks.checkPointer(pbuffer);
        }
        return WGLARBRenderTexture.nwglReleaseTexImageARB(pbuffer, buffer, __functionAddress);
    }

    public static native int nwglSetPbufferAttribARB(long var0, long var2, long var4);

    public static int nwglSetPbufferAttribARB(long pbuffer, long attribList) {
        long __functionAddress = WGLARBRenderTexture.getInstance().SetPbufferAttribARB;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
            Checks.checkPointer(pbuffer);
        }
        return WGLARBRenderTexture.nwglSetPbufferAttribARB(pbuffer, attribList, __functionAddress);
    }

    public static int wglSetPbufferAttribARB(long pbuffer, ByteBuffer attribList) {
        if (LWJGLUtil.CHECKS && attribList != null) {
            Checks.checkNT4(attribList);
        }
        return WGLARBRenderTexture.nwglSetPbufferAttribARB(pbuffer, MemoryUtil.memAddressSafe(attribList));
    }

    public static int wglSetPbufferAttribARB(long pbuffer, IntBuffer attribList) {
        if (LWJGLUtil.CHECKS && attribList != null) {
            Checks.checkNT(attribList);
        }
        return WGLARBRenderTexture.nwglSetPbufferAttribARB(pbuffer, MemoryUtil.memAddressSafe(attribList));
    }
}

