/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.opengl;

import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.nio.ShortBuffer;
import java.util.Set;
import org.lwjgl.LWJGLUtil;
import org.lwjgl.opengl.GL;
import org.lwjgl.opengl.GL45;
import org.lwjgl.opengl.GLChecks;
import org.lwjgl.system.Checks;
import org.lwjgl.system.FunctionProvider;
import org.lwjgl.system.MemoryUtil;

public final class KHRRobustness {
    public static final int GL_NO_ERROR = 0;
    public static final int GL_GUILTY_CONTEXT_RESET = 33363;
    public static final int GL_INNOCENT_CONTEXT_RESET = 33364;
    public static final int GL_UNKNOWN_CONTEXT_RESET = 33365;
    public static final int GL_CONTEXT_ROBUST_ACCESS = 37107;
    public static final int GL_RESET_NOTIFICATION_STRATEGY = 33366;
    public static final int GL_LOSE_CONTEXT_ON_RESET = 33362;
    public static final int GL_NO_RESET_NOTIFICATION = 33377;
    public static final int GL_CONTEXT_LOST = 1287;
    public final long GetGraphicsResetStatus;
    public final long ReadnPixels;
    public final long GetnUniformfv;
    public final long GetnUniformiv;
    public final long GetnUniformuiv;

    public KHRRobustness(FunctionProvider provider) {
        this.GetGraphicsResetStatus = provider.getFunctionAddress("glGetGraphicsResetStatus");
        this.ReadnPixels = provider.getFunctionAddress("glReadnPixels");
        this.GetnUniformfv = provider.getFunctionAddress("glGetnUniformfv");
        this.GetnUniformiv = provider.getFunctionAddress("glGetnUniformiv");
        this.GetnUniformuiv = provider.getFunctionAddress("glGetnUniformuiv");
    }

    public static KHRRobustness getInstance() {
        return GL.getCapabilities().__KHRRobustness;
    }

    static KHRRobustness create(Set<String> ext, FunctionProvider provider) {
        if (!ext.contains("GL_KHR_robustness")) {
            return null;
        }
        KHRRobustness funcs = new KHRRobustness(provider);
        boolean supported = Checks.checkFunctions(funcs.GetGraphicsResetStatus, funcs.ReadnPixels, funcs.GetnUniformfv, funcs.GetnUniformiv, funcs.GetnUniformuiv);
        return GL.checkExtension("GL_KHR_robustness", funcs, supported);
    }

    public static int glGetGraphicsResetStatus() {
        long __functionAddress = KHRRobustness.getInstance().GetGraphicsResetStatus;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        return GL45.nglGetGraphicsResetStatus(__functionAddress);
    }

    public static void nglReadnPixels(int x, int y, int width, int height, int format, int type, int bufSize, long pixels) {
        long __functionAddress = KHRRobustness.getInstance().ReadnPixels;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        GL45.nglReadnPixels(x, y, width, height, format, type, bufSize, pixels, __functionAddress);
    }

    public static void glReadnPixels(int x, int y, int width, int height, int format, int type, int bufSize, ByteBuffer pixels) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkBuffer((Buffer)pixels, bufSize);
            GLChecks.ensureBufferObject(35053, false);
        }
        KHRRobustness.nglReadnPixels(x, y, width, height, format, type, bufSize, MemoryUtil.memAddress(pixels));
    }

    public static void glReadnPixels(int x, int y, int width, int height, int format, int type, int bufSize, long pixelsOffset) {
        if (LWJGLUtil.CHECKS) {
            GLChecks.ensureBufferObject(35053, true);
        }
        KHRRobustness.nglReadnPixels(x, y, width, height, format, type, bufSize, pixelsOffset);
    }

    public static void glReadnPixels(int x, int y, int width, int height, int format, int type, ShortBuffer pixels) {
        if (LWJGLUtil.CHECKS) {
            GLChecks.ensureBufferObject(35053, false);
        }
        KHRRobustness.nglReadnPixels(x, y, width, height, format, type, pixels.remaining() << 1, MemoryUtil.memAddress(pixels));
    }

    public static void glReadnPixels(int x, int y, int width, int height, int format, int type, IntBuffer pixels) {
        if (LWJGLUtil.CHECKS) {
            GLChecks.ensureBufferObject(35053, false);
        }
        KHRRobustness.nglReadnPixels(x, y, width, height, format, type, pixels.remaining() << 2, MemoryUtil.memAddress(pixels));
    }

    public static void glReadnPixels(int x, int y, int width, int height, int format, int type, FloatBuffer pixels) {
        if (LWJGLUtil.CHECKS) {
            GLChecks.ensureBufferObject(35053, false);
        }
        KHRRobustness.nglReadnPixels(x, y, width, height, format, type, pixels.remaining() << 2, MemoryUtil.memAddress(pixels));
    }

    public static void nglGetnUniformfv(int program, int location, int bufSize, long params) {
        long __functionAddress = KHRRobustness.getInstance().GetnUniformfv;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        GL45.nglGetnUniformfv(program, location, bufSize, params, __functionAddress);
    }

    public static void glGetnUniformfv(int program, int location, int bufSize, ByteBuffer params) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkBuffer((Buffer)params, bufSize << 2);
        }
        KHRRobustness.nglGetnUniformfv(program, location, bufSize, MemoryUtil.memAddress(params));
    }

    public static void glGetnUniformfv(int program, int location, FloatBuffer params) {
        KHRRobustness.nglGetnUniformfv(program, location, params.remaining(), MemoryUtil.memAddress(params));
    }

    public static void nglGetnUniformiv(int program, int location, int bufSize, long params) {
        long __functionAddress = KHRRobustness.getInstance().GetnUniformiv;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        GL45.nglGetnUniformiv(program, location, bufSize, params, __functionAddress);
    }

    public static void glGetnUniformiv(int program, int location, int bufSize, ByteBuffer params) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkBuffer((Buffer)params, bufSize << 2);
        }
        KHRRobustness.nglGetnUniformiv(program, location, bufSize, MemoryUtil.memAddress(params));
    }

    public static void glGetnUniformiv(int program, int location, FloatBuffer params) {
        KHRRobustness.nglGetnUniformiv(program, location, params.remaining(), MemoryUtil.memAddress(params));
    }

    public static void nglGetnUniformuiv(int program, int location, int bufSize, long params) {
        long __functionAddress = KHRRobustness.getInstance().GetnUniformuiv;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        GL45.nglGetnUniformuiv(program, location, bufSize, params, __functionAddress);
    }

    public static void glGetnUniformuiv(int program, int location, int bufSize, ByteBuffer params) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkBuffer((Buffer)params, bufSize << 2);
        }
        KHRRobustness.nglGetnUniformuiv(program, location, bufSize, MemoryUtil.memAddress(params));
    }

    public static void glGetnUniformuiv(int program, int location, FloatBuffer params) {
        KHRRobustness.nglGetnUniformuiv(program, location, params.remaining(), MemoryUtil.memAddress(params));
    }
}

