/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.opengl;

import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import java.util.Set;
import org.lwjgl.LWJGLUtil;
import org.lwjgl.opengl.GL;
import org.lwjgl.opengl.GL11;
import org.lwjgl.opengl.GL43;
import org.lwjgl.opengl.GLDebugMessageCallback;
import org.lwjgl.system.APIBuffer;
import org.lwjgl.system.APIUtil;
import org.lwjgl.system.Checks;
import org.lwjgl.system.FunctionProvider;
import org.lwjgl.system.MemoryUtil;

public final class KHRDebug {
    public static final int GL_DEBUG_OUTPUT = 37600;
    public static final int GL_DEBUG_OUTPUT_SYNCHRONOUS = 33346;
    public static final int GL_CONTEXT_FLAG_DEBUG_BIT = 2;
    public static final int GL_MAX_DEBUG_MESSAGE_LENGTH = 37187;
    public static final int GL_MAX_DEBUG_LOGGED_MESSAGES = 37188;
    public static final int GL_DEBUG_LOGGED_MESSAGES = 37189;
    public static final int GL_DEBUG_NEXT_LOGGED_MESSAGE_LENGTH = 33347;
    public static final int GL_MAX_DEBUG_GROUP_STACK_DEPTH = 33388;
    public static final int GL_DEBUG_GROUP_STACK_DEPTH = 33389;
    public static final int GL_MAX_LABEL_LENGTH = 33512;
    public static final int GL_DEBUG_CALLBACK_FUNCTION = 33348;
    public static final int GL_DEBUG_CALLBACK_USER_PARAM = 33349;
    public static final int GL_DEBUG_SOURCE_API = 33350;
    public static final int GL_DEBUG_SOURCE_WINDOW_SYSTEM = 33351;
    public static final int GL_DEBUG_SOURCE_SHADER_COMPILER = 33352;
    public static final int GL_DEBUG_SOURCE_THIRD_PARTY = 33353;
    public static final int GL_DEBUG_SOURCE_APPLICATION = 33354;
    public static final int GL_DEBUG_SOURCE_OTHER = 33355;
    public static final int GL_DEBUG_TYPE_ERROR = 33356;
    public static final int GL_DEBUG_TYPE_DEPRECATED_BEHAVIOR = 33357;
    public static final int GL_DEBUG_TYPE_UNDEFINED_BEHAVIOR = 33358;
    public static final int GL_DEBUG_TYPE_PORTABILITY = 33359;
    public static final int GL_DEBUG_TYPE_PERFORMANCE = 33360;
    public static final int GL_DEBUG_TYPE_OTHER = 33361;
    public static final int GL_DEBUG_TYPE_MARKER = 33384;
    public static final int GL_DEBUG_TYPE_PUSH_GROUP = 33385;
    public static final int GL_DEBUG_TYPE_POP_GROUP = 33386;
    public static final int GL_DEBUG_SEVERITY_HIGH = 37190;
    public static final int GL_DEBUG_SEVERITY_MEDIUM = 37191;
    public static final int GL_DEBUG_SEVERITY_LOW = 37192;
    public static final int GL_DEBUG_SEVERITY_NOTIFICATION = 33387;
    public static final int GL_BUFFER = 33504;
    public static final int GL_SHADER = 33505;
    public static final int GL_PROGRAM = 33506;
    public static final int GL_QUERY = 33507;
    public static final int GL_PROGRAM_PIPELINE = 33508;
    public static final int GL_SAMPLER = 33510;
    public static final int GL_DISPLAY_LIST = 33511;
    public final long DebugMessageControl;
    public final long DebugMessageInsert;
    public final long DebugMessageCallback;
    public final long GetDebugMessageLog;
    public final long PushDebugGroup;
    public final long PopDebugGroup;
    public final long ObjectLabel;
    public final long GetObjectLabel;
    public final long ObjectPtrLabel;
    public final long GetObjectPtrLabel;

    public KHRDebug(FunctionProvider provider) {
        this.DebugMessageControl = provider.getFunctionAddress("glDebugMessageControl");
        this.DebugMessageInsert = provider.getFunctionAddress("glDebugMessageInsert");
        this.DebugMessageCallback = provider.getFunctionAddress("glDebugMessageCallback");
        this.GetDebugMessageLog = provider.getFunctionAddress("glGetDebugMessageLog");
        this.PushDebugGroup = provider.getFunctionAddress("glPushDebugGroup");
        this.PopDebugGroup = provider.getFunctionAddress("glPopDebugGroup");
        this.ObjectLabel = provider.getFunctionAddress("glObjectLabel");
        this.GetObjectLabel = provider.getFunctionAddress("glGetObjectLabel");
        this.ObjectPtrLabel = provider.getFunctionAddress("glObjectPtrLabel");
        this.GetObjectPtrLabel = provider.getFunctionAddress("glGetObjectPtrLabel");
    }

    public static KHRDebug getInstance() {
        return GL.getCapabilities().__KHRDebug;
    }

    static KHRDebug create(Set<String> ext, FunctionProvider provider) {
        if (!ext.contains("GL_KHR_debug")) {
            return null;
        }
        KHRDebug funcs = new KHRDebug(provider);
        boolean supported = Checks.checkFunctions(funcs.DebugMessageControl, funcs.DebugMessageInsert, funcs.DebugMessageCallback, funcs.GetDebugMessageLog, funcs.PushDebugGroup, funcs.PopDebugGroup, funcs.ObjectLabel, funcs.GetObjectLabel, funcs.ObjectPtrLabel, funcs.GetObjectPtrLabel);
        return GL.checkExtension("GL_KHR_debug", funcs, supported);
    }

    public static void nglDebugMessageControl(int source, int type, int severity, int count, long ids, boolean enabled) {
        long __functionAddress = KHRDebug.getInstance().DebugMessageControl;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        GL43.nglDebugMessageControl(source, type, severity, count, ids, enabled, __functionAddress);
    }

    public static void glDebugMessageControl(int source, int type, int severity, int count, ByteBuffer ids, boolean enabled) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkBuffer((Buffer)ids, count << 2);
        }
        KHRDebug.nglDebugMessageControl(source, type, severity, count, MemoryUtil.memAddress(ids), enabled);
    }

    public static void glDebugMessageControl(int source, int type, int severity, IntBuffer ids, boolean enabled) {
        KHRDebug.nglDebugMessageControl(source, type, severity, ids.remaining(), MemoryUtil.memAddress(ids), enabled);
    }

    public static void glDebugMessageControl(int source, int type, int severity, int id, boolean enabled) {
        APIBuffer __buffer = APIUtil.apiBuffer();
        int ids = __buffer.intParam(id);
        KHRDebug.nglDebugMessageControl(source, type, severity, 1, __buffer.address(ids), enabled);
    }

    public static void nglDebugMessageInsert(int source, int type, int id, int severity, int length, long message) {
        long __functionAddress = KHRDebug.getInstance().DebugMessageInsert;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        GL43.nglDebugMessageInsert(source, type, id, severity, length, message, __functionAddress);
    }

    public static void glDebugMessageInsert(int source, int type, int id, int severity, int length, ByteBuffer message) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkBuffer((Buffer)message, length);
        }
        KHRDebug.nglDebugMessageInsert(source, type, id, severity, length, MemoryUtil.memAddress(message));
    }

    public static void glDebugMessageInsert(int source, int type, int id, int severity, ByteBuffer message) {
        KHRDebug.nglDebugMessageInsert(source, type, id, severity, message.remaining(), MemoryUtil.memAddress(message));
    }

    public static void glDebugMessageInsert(int source, int type, int id, int severity, CharSequence message) {
        APIBuffer __buffer = APIUtil.apiBuffer();
        int messageEncoded = __buffer.stringParamUTF8(message, false);
        int messageEncodedLen = __buffer.getOffset() - messageEncoded;
        KHRDebug.nglDebugMessageInsert(source, type, id, severity, messageEncodedLen, __buffer.address(messageEncoded));
    }

    public static void glDebugMessageCallback(GLDebugMessageCallback callback, long userParam) {
        long __functionAddress = KHRDebug.getInstance().DebugMessageCallback;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        GL43.nglDebugMessageCallback(callback == null ? 0L : callback.getPointer(), userParam, __functionAddress);
    }

    public static int nglGetDebugMessageLog(int count, int bufsize, long sources, long types, long ids, long severities, long lengths, long messageLog) {
        long __functionAddress = KHRDebug.getInstance().GetDebugMessageLog;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        return GL43.nglGetDebugMessageLog(count, bufsize, sources, types, ids, severities, lengths, messageLog, __functionAddress);
    }

    public static int glGetDebugMessageLog(int count, int bufsize, ByteBuffer sources, ByteBuffer types, ByteBuffer ids, ByteBuffer severities, ByteBuffer lengths, ByteBuffer messageLog) {
        if (LWJGLUtil.CHECKS) {
            if (messageLog != null) {
                Checks.checkBuffer((Buffer)messageLog, bufsize);
            }
            if (sources != null) {
                Checks.checkBuffer((Buffer)sources, count << 2);
            }
            if (types != null) {
                Checks.checkBuffer((Buffer)types, count << 2);
            }
            if (ids != null) {
                Checks.checkBuffer((Buffer)ids, count << 2);
            }
            if (severities != null) {
                Checks.checkBuffer((Buffer)severities, count << 2);
            }
            if (lengths != null) {
                Checks.checkBuffer((Buffer)lengths, count << 2);
            }
        }
        return KHRDebug.nglGetDebugMessageLog(count, bufsize, MemoryUtil.memAddressSafe(sources), MemoryUtil.memAddressSafe(types), MemoryUtil.memAddressSafe(ids), MemoryUtil.memAddressSafe(severities), MemoryUtil.memAddressSafe(lengths), MemoryUtil.memAddressSafe(messageLog));
    }

    public static int glGetDebugMessageLog(int count, IntBuffer sources, IntBuffer types, IntBuffer ids, IntBuffer severities, IntBuffer lengths, ByteBuffer messageLog) {
        if (LWJGLUtil.CHECKS) {
            if (sources != null) {
                Checks.checkBuffer((Buffer)sources, count);
            }
            if (types != null) {
                Checks.checkBuffer((Buffer)types, count);
            }
            if (ids != null) {
                Checks.checkBuffer((Buffer)ids, count);
            }
            if (severities != null) {
                Checks.checkBuffer((Buffer)severities, count);
            }
            if (lengths != null) {
                Checks.checkBuffer((Buffer)lengths, count);
            }
        }
        return KHRDebug.nglGetDebugMessageLog(count, messageLog == null ? 0 : messageLog.remaining(), MemoryUtil.memAddressSafe(sources), MemoryUtil.memAddressSafe(types), MemoryUtil.memAddressSafe(ids), MemoryUtil.memAddressSafe(severities), MemoryUtil.memAddressSafe(lengths), MemoryUtil.memAddressSafe(messageLog));
    }

    public static void nglPushDebugGroup(int source, int id, int length, long message) {
        long __functionAddress = KHRDebug.getInstance().PushDebugGroup;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        GL43.nglPushDebugGroup(source, id, length, message, __functionAddress);
    }

    public static void glPushDebugGroup(int source, int id, int length, ByteBuffer message) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkBuffer((Buffer)message, length);
        }
        KHRDebug.nglPushDebugGroup(source, id, length, MemoryUtil.memAddress(message));
    }

    public static void glPushDebugGroup(int source, int id, ByteBuffer message) {
        KHRDebug.nglPushDebugGroup(source, id, message.remaining(), MemoryUtil.memAddress(message));
    }

    public static void glPushDebugGroup(int source, int id, CharSequence message) {
        APIBuffer __buffer = APIUtil.apiBuffer();
        int messageEncoded = __buffer.stringParamUTF8(message, false);
        int messageEncodedLen = __buffer.getOffset() - messageEncoded;
        KHRDebug.nglPushDebugGroup(source, id, messageEncodedLen, __buffer.address(messageEncoded));
    }

    public static void glPopDebugGroup() {
        long __functionAddress = KHRDebug.getInstance().PopDebugGroup;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        GL43.nglPopDebugGroup(__functionAddress);
    }

    public static void nglObjectLabel(int identifier, int name, int length, long label) {
        long __functionAddress = KHRDebug.getInstance().ObjectLabel;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        GL43.nglObjectLabel(identifier, name, length, label, __functionAddress);
    }

    public static void glObjectLabel(int identifier, int name, int length, ByteBuffer label) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkBuffer((Buffer)label, length);
        }
        KHRDebug.nglObjectLabel(identifier, name, length, MemoryUtil.memAddress(label));
    }

    public static void glObjectLabel(int identifier, int name, ByteBuffer label) {
        KHRDebug.nglObjectLabel(identifier, name, label.remaining(), MemoryUtil.memAddress(label));
    }

    public static void glObjectLabel(int identifier, int name, CharSequence label) {
        APIBuffer __buffer = APIUtil.apiBuffer();
        int labelEncoded = __buffer.stringParamUTF8(label, false);
        int labelEncodedLen = __buffer.getOffset() - labelEncoded;
        KHRDebug.nglObjectLabel(identifier, name, labelEncodedLen, __buffer.address(labelEncoded));
    }

    public static void nglGetObjectLabel(int identifier, int name, int bufSize, long length, long label) {
        long __functionAddress = KHRDebug.getInstance().GetObjectLabel;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        GL43.nglGetObjectLabel(identifier, name, bufSize, length, label, __functionAddress);
    }

    public static void glGetObjectLabel(int identifier, int name, int bufSize, ByteBuffer length, ByteBuffer label) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkBuffer((Buffer)label, bufSize);
            if (length != null) {
                Checks.checkBuffer((Buffer)length, 4);
            }
        }
        KHRDebug.nglGetObjectLabel(identifier, name, bufSize, MemoryUtil.memAddressSafe(length), MemoryUtil.memAddress(label));
    }

    public static void glGetObjectLabel(int identifier, int name, IntBuffer length, ByteBuffer label) {
        if (LWJGLUtil.CHECKS && length != null) {
            Checks.checkBuffer((Buffer)length, 1);
        }
        KHRDebug.nglGetObjectLabel(identifier, name, label.remaining(), MemoryUtil.memAddressSafe(length), MemoryUtil.memAddress(label));
    }

    public static String glGetObjectLabel(int identifier, int name, int bufSize) {
        APIBuffer __buffer = APIUtil.apiBuffer();
        int length = __buffer.intParam();
        int label = __buffer.bufferParam(bufSize);
        KHRDebug.nglGetObjectLabel(identifier, name, bufSize, __buffer.address(length), __buffer.address(label));
        return MemoryUtil.memDecodeUTF8(MemoryUtil.memByteBuffer(__buffer.address(label), __buffer.intValue(length)));
    }

    public static String glGetObjectLabel(int identifier, int name) {
        int bufSize = GL11.glGetInteger(33512);
        APIBuffer __buffer = APIUtil.apiBuffer();
        int length = __buffer.intParam();
        int label = __buffer.bufferParam(bufSize);
        KHRDebug.nglGetObjectLabel(identifier, name, bufSize, __buffer.address(length), __buffer.address(label));
        return MemoryUtil.memDecodeUTF8(MemoryUtil.memByteBuffer(__buffer.address(label), __buffer.intValue(length)));
    }

    public static void nglObjectPtrLabel(long ptr, int length, long label) {
        long __functionAddress = KHRDebug.getInstance().ObjectPtrLabel;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
            Checks.checkPointer(ptr);
        }
        GL43.nglObjectPtrLabel(ptr, length, label, __functionAddress);
    }

    public static void glObjectPtrLabel(long ptr, int length, ByteBuffer label) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkBuffer((Buffer)label, length);
        }
        KHRDebug.nglObjectPtrLabel(ptr, length, MemoryUtil.memAddress(label));
    }

    public static void glObjectPtrLabel(long ptr, ByteBuffer label) {
        KHRDebug.nglObjectPtrLabel(ptr, label.remaining(), MemoryUtil.memAddress(label));
    }

    public static void glObjectPtrLabel(long ptr, CharSequence label) {
        APIBuffer __buffer = APIUtil.apiBuffer();
        int labelEncoded = __buffer.stringParamUTF8(label, false);
        int labelEncodedLen = __buffer.getOffset() - labelEncoded;
        KHRDebug.nglObjectPtrLabel(ptr, labelEncodedLen, __buffer.address(labelEncoded));
    }

    public static void nglGetObjectPtrLabel(long ptr, int bufSize, long length, long label) {
        long __functionAddress = KHRDebug.getInstance().GetObjectPtrLabel;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
            Checks.checkPointer(ptr);
        }
        GL43.nglGetObjectPtrLabel(ptr, bufSize, length, label, __functionAddress);
    }

    public static void glGetObjectPtrLabel(long ptr, int bufSize, ByteBuffer length, ByteBuffer label) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkBuffer((Buffer)label, bufSize);
            if (length != null) {
                Checks.checkBuffer((Buffer)length, 4);
            }
        }
        KHRDebug.nglGetObjectPtrLabel(ptr, bufSize, MemoryUtil.memAddressSafe(length), MemoryUtil.memAddress(label));
    }

    public static void glGetObjectPtrLabel(long ptr, IntBuffer length, ByteBuffer label) {
        if (LWJGLUtil.CHECKS && length != null) {
            Checks.checkBuffer((Buffer)length, 1);
        }
        KHRDebug.nglGetObjectPtrLabel(ptr, label.remaining(), MemoryUtil.memAddressSafe(length), MemoryUtil.memAddress(label));
    }

    public static String glGetObjectPtrLabel(long ptr, int bufSize) {
        APIBuffer __buffer = APIUtil.apiBuffer();
        int length = __buffer.intParam();
        int label = __buffer.bufferParam(bufSize);
        KHRDebug.nglGetObjectPtrLabel(ptr, bufSize, __buffer.address(length), __buffer.address(label));
        return MemoryUtil.memDecodeUTF8(MemoryUtil.memByteBuffer(__buffer.address(label), __buffer.intValue(length)));
    }

    public static String glGetObjectPtrLabel(long ptr) {
        int bufSize = GL11.glGetInteger(33512);
        APIBuffer __buffer = APIUtil.apiBuffer();
        int length = __buffer.intParam();
        int label = __buffer.bufferParam(bufSize);
        KHRDebug.nglGetObjectPtrLabel(ptr, bufSize, __buffer.address(length), __buffer.address(label));
        return MemoryUtil.memDecodeUTF8(MemoryUtil.memByteBuffer(__buffer.address(label), __buffer.intValue(length)));
    }

    public static GLDebugMessageCallback GLDebugMessageCallback(final GLDebugMessageCallback.SAM sam) {
        return new GLDebugMessageCallback(){

            @Override
            public void invoke(int source, int type, int id, int severity, int length, long message, long userParam) {
                sam.invoke(source, type, id, severity, length, message, userParam);
            }
        };
    }
}

