/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.opengl;

import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.DoubleBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.util.Set;
import org.lwjgl.LWJGLUtil;
import org.lwjgl.Pointer;
import org.lwjgl.PointerBuffer;
import org.lwjgl.opengl.GL;
import org.lwjgl.opengl.GL41;
import org.lwjgl.system.APIBuffer;
import org.lwjgl.system.APIUtil;
import org.lwjgl.system.Checks;
import org.lwjgl.system.FunctionProvider;
import org.lwjgl.system.MemoryUtil;

public final class ARBSeparateShaderObjects {
    public static final int GL_VERTEX_SHADER_BIT = 1;
    public static final int GL_FRAGMENT_SHADER_BIT = 2;
    public static final int GL_GEOMETRY_SHADER_BIT = 4;
    public static final int GL_TESS_CONTROL_SHADER_BIT = 8;
    public static final int GL_TESS_EVALUATION_SHADER_BIT = 16;
    public static final int GL_ALL_SHADER_BITS = -1;
    public static final int GL_PROGRAM_SEPARABLE = 33368;
    public static final int GL_ACTIVE_PROGRAM = 33369;
    public static final int GL_PROGRAM_PIPELINE_BINDING = 33370;
    public final long UseProgramStages;
    public final long ActiveShaderProgram;
    public final long CreateShaderProgramv;
    public final long BindProgramPipeline;
    public final long DeleteProgramPipelines;
    public final long GenProgramPipelines;
    public final long IsProgramPipeline;
    public final long ProgramParameteri;
    public final long GetProgramPipelineiv;
    public final long ProgramUniform1i;
    public final long ProgramUniform2i;
    public final long ProgramUniform3i;
    public final long ProgramUniform4i;
    public final long ProgramUniform1ui;
    public final long ProgramUniform2ui;
    public final long ProgramUniform3ui;
    public final long ProgramUniform4ui;
    public final long ProgramUniform1f;
    public final long ProgramUniform2f;
    public final long ProgramUniform3f;
    public final long ProgramUniform4f;
    public final long ProgramUniform1d;
    public final long ProgramUniform2d;
    public final long ProgramUniform3d;
    public final long ProgramUniform4d;
    public final long ProgramUniform1iv;
    public final long ProgramUniform2iv;
    public final long ProgramUniform3iv;
    public final long ProgramUniform4iv;
    public final long ProgramUniform1uiv;
    public final long ProgramUniform2uiv;
    public final long ProgramUniform3uiv;
    public final long ProgramUniform4uiv;
    public final long ProgramUniform1fv;
    public final long ProgramUniform2fv;
    public final long ProgramUniform3fv;
    public final long ProgramUniform4fv;
    public final long ProgramUniform1dv;
    public final long ProgramUniform2dv;
    public final long ProgramUniform3dv;
    public final long ProgramUniform4dv;
    public final long ProgramUniformMatrix2fv;
    public final long ProgramUniformMatrix3fv;
    public final long ProgramUniformMatrix4fv;
    public final long ProgramUniformMatrix2dv;
    public final long ProgramUniformMatrix3dv;
    public final long ProgramUniformMatrix4dv;
    public final long ProgramUniformMatrix2x3fv;
    public final long ProgramUniformMatrix3x2fv;
    public final long ProgramUniformMatrix2x4fv;
    public final long ProgramUniformMatrix4x2fv;
    public final long ProgramUniformMatrix3x4fv;
    public final long ProgramUniformMatrix4x3fv;
    public final long ProgramUniformMatrix2x3dv;
    public final long ProgramUniformMatrix3x2dv;
    public final long ProgramUniformMatrix2x4dv;
    public final long ProgramUniformMatrix4x2dv;
    public final long ProgramUniformMatrix3x4dv;
    public final long ProgramUniformMatrix4x3dv;
    public final long ValidateProgramPipeline;
    public final long GetProgramPipelineInfoLog;

    public ARBSeparateShaderObjects(FunctionProvider provider) {
        this.UseProgramStages = provider.getFunctionAddress("glUseProgramStages");
        this.ActiveShaderProgram = provider.getFunctionAddress("glActiveShaderProgram");
        this.CreateShaderProgramv = provider.getFunctionAddress("glCreateShaderProgramv");
        this.BindProgramPipeline = provider.getFunctionAddress("glBindProgramPipeline");
        this.DeleteProgramPipelines = provider.getFunctionAddress("glDeleteProgramPipelines");
        this.GenProgramPipelines = provider.getFunctionAddress("glGenProgramPipelines");
        this.IsProgramPipeline = provider.getFunctionAddress("glIsProgramPipeline");
        this.ProgramParameteri = provider.getFunctionAddress("glProgramParameteri");
        this.GetProgramPipelineiv = provider.getFunctionAddress("glGetProgramPipelineiv");
        this.ProgramUniform1i = provider.getFunctionAddress("glProgramUniform1i");
        this.ProgramUniform2i = provider.getFunctionAddress("glProgramUniform2i");
        this.ProgramUniform3i = provider.getFunctionAddress("glProgramUniform3i");
        this.ProgramUniform4i = provider.getFunctionAddress("glProgramUniform4i");
        this.ProgramUniform1ui = provider.getFunctionAddress("glProgramUniform1ui");
        this.ProgramUniform2ui = provider.getFunctionAddress("glProgramUniform2ui");
        this.ProgramUniform3ui = provider.getFunctionAddress("glProgramUniform3ui");
        this.ProgramUniform4ui = provider.getFunctionAddress("glProgramUniform4ui");
        this.ProgramUniform1f = provider.getFunctionAddress("glProgramUniform1f");
        this.ProgramUniform2f = provider.getFunctionAddress("glProgramUniform2f");
        this.ProgramUniform3f = provider.getFunctionAddress("glProgramUniform3f");
        this.ProgramUniform4f = provider.getFunctionAddress("glProgramUniform4f");
        this.ProgramUniform1d = provider.getFunctionAddress("glProgramUniform1d");
        this.ProgramUniform2d = provider.getFunctionAddress("glProgramUniform2d");
        this.ProgramUniform3d = provider.getFunctionAddress("glProgramUniform3d");
        this.ProgramUniform4d = provider.getFunctionAddress("glProgramUniform4d");
        this.ProgramUniform1iv = provider.getFunctionAddress("glProgramUniform1iv");
        this.ProgramUniform2iv = provider.getFunctionAddress("glProgramUniform2iv");
        this.ProgramUniform3iv = provider.getFunctionAddress("glProgramUniform3iv");
        this.ProgramUniform4iv = provider.getFunctionAddress("glProgramUniform4iv");
        this.ProgramUniform1uiv = provider.getFunctionAddress("glProgramUniform1uiv");
        this.ProgramUniform2uiv = provider.getFunctionAddress("glProgramUniform2uiv");
        this.ProgramUniform3uiv = provider.getFunctionAddress("glProgramUniform3uiv");
        this.ProgramUniform4uiv = provider.getFunctionAddress("glProgramUniform4uiv");
        this.ProgramUniform1fv = provider.getFunctionAddress("glProgramUniform1fv");
        this.ProgramUniform2fv = provider.getFunctionAddress("glProgramUniform2fv");
        this.ProgramUniform3fv = provider.getFunctionAddress("glProgramUniform3fv");
        this.ProgramUniform4fv = provider.getFunctionAddress("glProgramUniform4fv");
        this.ProgramUniform1dv = provider.getFunctionAddress("glProgramUniform1dv");
        this.ProgramUniform2dv = provider.getFunctionAddress("glProgramUniform2dv");
        this.ProgramUniform3dv = provider.getFunctionAddress("glProgramUniform3dv");
        this.ProgramUniform4dv = provider.getFunctionAddress("glProgramUniform4dv");
        this.ProgramUniformMatrix2fv = provider.getFunctionAddress("glProgramUniformMatrix2fv");
        this.ProgramUniformMatrix3fv = provider.getFunctionAddress("glProgramUniformMatrix3fv");
        this.ProgramUniformMatrix4fv = provider.getFunctionAddress("glProgramUniformMatrix4fv");
        this.ProgramUniformMatrix2dv = provider.getFunctionAddress("glProgramUniformMatrix2dv");
        this.ProgramUniformMatrix3dv = provider.getFunctionAddress("glProgramUniformMatrix3dv");
        this.ProgramUniformMatrix4dv = provider.getFunctionAddress("glProgramUniformMatrix4dv");
        this.ProgramUniformMatrix2x3fv = provider.getFunctionAddress("glProgramUniformMatrix2x3fv");
        this.ProgramUniformMatrix3x2fv = provider.getFunctionAddress("glProgramUniformMatrix3x2fv");
        this.ProgramUniformMatrix2x4fv = provider.getFunctionAddress("glProgramUniformMatrix2x4fv");
        this.ProgramUniformMatrix4x2fv = provider.getFunctionAddress("glProgramUniformMatrix4x2fv");
        this.ProgramUniformMatrix3x4fv = provider.getFunctionAddress("glProgramUniformMatrix3x4fv");
        this.ProgramUniformMatrix4x3fv = provider.getFunctionAddress("glProgramUniformMatrix4x3fv");
        this.ProgramUniformMatrix2x3dv = provider.getFunctionAddress("glProgramUniformMatrix2x3dv");
        this.ProgramUniformMatrix3x2dv = provider.getFunctionAddress("glProgramUniformMatrix3x2dv");
        this.ProgramUniformMatrix2x4dv = provider.getFunctionAddress("glProgramUniformMatrix2x4dv");
        this.ProgramUniformMatrix4x2dv = provider.getFunctionAddress("glProgramUniformMatrix4x2dv");
        this.ProgramUniformMatrix3x4dv = provider.getFunctionAddress("glProgramUniformMatrix3x4dv");
        this.ProgramUniformMatrix4x3dv = provider.getFunctionAddress("glProgramUniformMatrix4x3dv");
        this.ValidateProgramPipeline = provider.getFunctionAddress("glValidateProgramPipeline");
        this.GetProgramPipelineInfoLog = provider.getFunctionAddress("glGetProgramPipelineInfoLog");
    }

    public static ARBSeparateShaderObjects getInstance() {
        return GL.getCapabilities().__ARBSeparateShaderObjects;
    }

    static ARBSeparateShaderObjects create(Set<String> ext, FunctionProvider provider) {
        if (!ext.contains("GL_ARB_separate_shader_objects")) {
            return null;
        }
        ARBSeparateShaderObjects funcs = new ARBSeparateShaderObjects(provider);
        boolean supported = Checks.checkFunctions(funcs.UseProgramStages, funcs.ActiveShaderProgram, funcs.CreateShaderProgramv, funcs.BindProgramPipeline, funcs.DeleteProgramPipelines, funcs.GenProgramPipelines, funcs.IsProgramPipeline, funcs.ProgramParameteri, funcs.GetProgramPipelineiv, funcs.ProgramUniform1i, funcs.ProgramUniform2i, funcs.ProgramUniform3i, funcs.ProgramUniform4i, funcs.ProgramUniform1ui, funcs.ProgramUniform2ui, funcs.ProgramUniform3ui, funcs.ProgramUniform4ui, funcs.ProgramUniform1f, funcs.ProgramUniform2f, funcs.ProgramUniform3f, funcs.ProgramUniform4f, funcs.ProgramUniform1d, funcs.ProgramUniform2d, funcs.ProgramUniform3d, funcs.ProgramUniform4d, funcs.ProgramUniform1iv, funcs.ProgramUniform2iv, funcs.ProgramUniform3iv, funcs.ProgramUniform4iv, funcs.ProgramUniform1uiv, funcs.ProgramUniform2uiv, funcs.ProgramUniform3uiv, funcs.ProgramUniform4uiv, funcs.ProgramUniform1fv, funcs.ProgramUniform2fv, funcs.ProgramUniform3fv, funcs.ProgramUniform4fv, funcs.ProgramUniform1dv, funcs.ProgramUniform2dv, funcs.ProgramUniform3dv, funcs.ProgramUniform4dv, funcs.ProgramUniformMatrix2fv, funcs.ProgramUniformMatrix3fv, funcs.ProgramUniformMatrix4fv, funcs.ProgramUniformMatrix2dv, funcs.ProgramUniformMatrix3dv, funcs.ProgramUniformMatrix4dv, funcs.ProgramUniformMatrix2x3fv, funcs.ProgramUniformMatrix3x2fv, funcs.ProgramUniformMatrix2x4fv, funcs.ProgramUniformMatrix4x2fv, funcs.ProgramUniformMatrix3x4fv, funcs.ProgramUniformMatrix4x3fv, funcs.ProgramUniformMatrix2x3dv, funcs.ProgramUniformMatrix3x2dv, funcs.ProgramUniformMatrix2x4dv, funcs.ProgramUniformMatrix4x2dv, funcs.ProgramUniformMatrix3x4dv, funcs.ProgramUniformMatrix4x3dv, funcs.ValidateProgramPipeline, funcs.GetProgramPipelineInfoLog);
        return GL.checkExtension("GL_ARB_separate_shader_objects", funcs, supported);
    }

    public static void glUseProgramStages(int pipeline, int stages, int program) {
        long __functionAddress = ARBSeparateShaderObjects.getInstance().UseProgramStages;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        GL41.nglUseProgramStages(pipeline, stages, program, __functionAddress);
    }

    public static void glActiveShaderProgram(int pipeline, int program) {
        long __functionAddress = ARBSeparateShaderObjects.getInstance().ActiveShaderProgram;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        GL41.nglActiveShaderProgram(pipeline, program, __functionAddress);
    }

    public static int nglCreateShaderProgramv(int type, int count, long strings) {
        long __functionAddress = ARBSeparateShaderObjects.getInstance().CreateShaderProgramv;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        return GL41.nglCreateShaderProgramv(type, count, strings, __functionAddress);
    }

    public static int glCreateShaderProgramv(int type, int count, ByteBuffer strings) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkBuffer((Buffer)strings, count << Pointer.POINTER_SHIFT);
        }
        return ARBSeparateShaderObjects.nglCreateShaderProgramv(type, count, MemoryUtil.memAddress(strings));
    }

    public static int glCreateShaderProgramv(int type, PointerBuffer strings) {
        return ARBSeparateShaderObjects.nglCreateShaderProgramv(type, strings.remaining(), MemoryUtil.memAddress(strings));
    }

    public static int glCreateShaderProgramv(int type, CharSequence ... strings) {
        APIBuffer __buffer = APIUtil.apiBuffer();
        int stringsAddress = __buffer.bufferParam(strings.length << Pointer.POINTER_SHIFT);
        ByteBuffer[] stringsBuffers = new ByteBuffer[strings.length];
        for (int i = 0; i < strings.length; ++i) {
            stringsBuffers[i] = MemoryUtil.memEncodeUTF8(strings[i], true);
            __buffer.pointerParam(stringsAddress, i, MemoryUtil.memAddress(stringsBuffers[i]));
        }
        return ARBSeparateShaderObjects.nglCreateShaderProgramv(type, strings.length, __buffer.address(stringsAddress));
    }

    public static int glCreateShaderProgramv(int type, CharSequence string) {
        APIBuffer __buffer = APIUtil.apiBuffer();
        ByteBuffer stringBuffers = MemoryUtil.memEncodeUTF8(string, true);
        int stringsAddress = __buffer.pointerParam(MemoryUtil.memAddress(stringBuffers));
        return ARBSeparateShaderObjects.nglCreateShaderProgramv(type, 1, __buffer.address(stringsAddress));
    }

    public static void glBindProgramPipeline(int pipeline) {
        long __functionAddress = ARBSeparateShaderObjects.getInstance().BindProgramPipeline;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        GL41.nglBindProgramPipeline(pipeline, __functionAddress);
    }

    public static void nglDeleteProgramPipelines(int n, long pipelines) {
        long __functionAddress = ARBSeparateShaderObjects.getInstance().DeleteProgramPipelines;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        GL41.nglDeleteProgramPipelines(n, pipelines, __functionAddress);
    }

    public static void glDeleteProgramPipelines(int n, ByteBuffer pipelines) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkBuffer((Buffer)pipelines, n << 2);
        }
        ARBSeparateShaderObjects.nglDeleteProgramPipelines(n, MemoryUtil.memAddress(pipelines));
    }

    public static void glDeleteProgramPipelines(IntBuffer pipelines) {
        ARBSeparateShaderObjects.nglDeleteProgramPipelines(pipelines.remaining(), MemoryUtil.memAddress(pipelines));
    }

    public static void glDeleteProgramPipelines(int pipeline) {
        APIBuffer __buffer = APIUtil.apiBuffer();
        int pipelines = __buffer.intParam(pipeline);
        ARBSeparateShaderObjects.nglDeleteProgramPipelines(1, __buffer.address(pipelines));
    }

    public static void nglGenProgramPipelines(int n, long pipelines) {
        long __functionAddress = ARBSeparateShaderObjects.getInstance().GenProgramPipelines;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        GL41.nglGenProgramPipelines(n, pipelines, __functionAddress);
    }

    public static void glGenProgramPipelines(int n, ByteBuffer pipelines) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkBuffer((Buffer)pipelines, n << 2);
        }
        ARBSeparateShaderObjects.nglGenProgramPipelines(n, MemoryUtil.memAddress(pipelines));
    }

    public static void glGenProgramPipelines(IntBuffer pipelines) {
        ARBSeparateShaderObjects.nglGenProgramPipelines(pipelines.remaining(), MemoryUtil.memAddress(pipelines));
    }

    public static int glGenProgramPipelines() {
        APIBuffer __buffer = APIUtil.apiBuffer();
        int pipelines = __buffer.intParam();
        ARBSeparateShaderObjects.nglGenProgramPipelines(1, __buffer.address(pipelines));
        return __buffer.intValue(pipelines);
    }

    public static boolean glIsProgramPipeline(int pipeline) {
        long __functionAddress = ARBSeparateShaderObjects.getInstance().IsProgramPipeline;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        return GL41.nglIsProgramPipeline(pipeline, __functionAddress);
    }

    public static void glProgramParameteri(int program, int pname, int value) {
        long __functionAddress = ARBSeparateShaderObjects.getInstance().ProgramParameteri;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        GL41.nglProgramParameteri(program, pname, value, __functionAddress);
    }

    public static void nglGetProgramPipelineiv(int pipeline, int pname, long params) {
        long __functionAddress = ARBSeparateShaderObjects.getInstance().GetProgramPipelineiv;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        GL41.nglGetProgramPipelineiv(pipeline, pname, params, __functionAddress);
    }

    public static void glGetProgramPipelineiv(int pipeline, int pname, ByteBuffer params) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkBuffer((Buffer)params, 4);
        }
        ARBSeparateShaderObjects.nglGetProgramPipelineiv(pipeline, pname, MemoryUtil.memAddress(params));
    }

    public static void glGetProgramPipelineiv(int pipeline, int pname, IntBuffer params) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkBuffer((Buffer)params, 1);
        }
        ARBSeparateShaderObjects.nglGetProgramPipelineiv(pipeline, pname, MemoryUtil.memAddress(params));
    }

    public static int glGetProgramPipelinei(int pipeline, int pname) {
        APIBuffer __buffer = APIUtil.apiBuffer();
        int params = __buffer.intParam();
        ARBSeparateShaderObjects.nglGetProgramPipelineiv(pipeline, pname, __buffer.address(params));
        return __buffer.intValue(params);
    }

    public static void glProgramUniform1i(int program, int location, int x) {
        long __functionAddress = ARBSeparateShaderObjects.getInstance().ProgramUniform1i;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        GL41.nglProgramUniform1i(program, location, x, __functionAddress);
    }

    public static void glProgramUniform2i(int program, int location, int x, int y) {
        long __functionAddress = ARBSeparateShaderObjects.getInstance().ProgramUniform2i;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        GL41.nglProgramUniform2i(program, location, x, y, __functionAddress);
    }

    public static void glProgramUniform3i(int program, int location, int x, int y, int z) {
        long __functionAddress = ARBSeparateShaderObjects.getInstance().ProgramUniform3i;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        GL41.nglProgramUniform3i(program, location, x, y, z, __functionAddress);
    }

    public static void glProgramUniform4i(int program, int location, int x, int y, int z, int w) {
        long __functionAddress = ARBSeparateShaderObjects.getInstance().ProgramUniform4i;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        GL41.nglProgramUniform4i(program, location, x, y, z, w, __functionAddress);
    }

    public static void glProgramUniform1ui(int program, int location, int x) {
        long __functionAddress = ARBSeparateShaderObjects.getInstance().ProgramUniform1ui;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        GL41.nglProgramUniform1ui(program, location, x, __functionAddress);
    }

    public static void glProgramUniform2ui(int program, int location, int x, int y) {
        long __functionAddress = ARBSeparateShaderObjects.getInstance().ProgramUniform2ui;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        GL41.nglProgramUniform2ui(program, location, x, y, __functionAddress);
    }

    public static void glProgramUniform3ui(int program, int location, int x, int y, int z) {
        long __functionAddress = ARBSeparateShaderObjects.getInstance().ProgramUniform3ui;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        GL41.nglProgramUniform3ui(program, location, x, y, z, __functionAddress);
    }

    public static void glProgramUniform4ui(int program, int location, int x, int y, int z, int w) {
        long __functionAddress = ARBSeparateShaderObjects.getInstance().ProgramUniform4ui;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        GL41.nglProgramUniform4ui(program, location, x, y, z, w, __functionAddress);
    }

    public static void glProgramUniform1f(int program, int location, float x) {
        long __functionAddress = ARBSeparateShaderObjects.getInstance().ProgramUniform1f;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        GL41.nglProgramUniform1f(program, location, x, __functionAddress);
    }

    public static void glProgramUniform2f(int program, int location, float x, float y) {
        long __functionAddress = ARBSeparateShaderObjects.getInstance().ProgramUniform2f;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        GL41.nglProgramUniform2f(program, location, x, y, __functionAddress);
    }

    public static void glProgramUniform3f(int program, int location, float x, float y, float z) {
        long __functionAddress = ARBSeparateShaderObjects.getInstance().ProgramUniform3f;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        GL41.nglProgramUniform3f(program, location, x, y, z, __functionAddress);
    }

    public static void glProgramUniform4f(int program, int location, float x, float y, float z, float w) {
        long __functionAddress = ARBSeparateShaderObjects.getInstance().ProgramUniform4f;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        GL41.nglProgramUniform4f(program, location, x, y, z, w, __functionAddress);
    }

    public static void glProgramUniform1d(int program, int location, double x) {
        long __functionAddress = ARBSeparateShaderObjects.getInstance().ProgramUniform1d;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        GL41.nglProgramUniform1d(program, location, x, __functionAddress);
    }

    public static void glProgramUniform2d(int program, int location, double x, double y) {
        long __functionAddress = ARBSeparateShaderObjects.getInstance().ProgramUniform2d;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        GL41.nglProgramUniform2d(program, location, x, y, __functionAddress);
    }

    public static void glProgramUniform3d(int program, int location, double x, double y, double z) {
        long __functionAddress = ARBSeparateShaderObjects.getInstance().ProgramUniform3d;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        GL41.nglProgramUniform3d(program, location, x, y, z, __functionAddress);
    }

    public static void glProgramUniform4d(int program, int location, double x, double y, double z, double w) {
        long __functionAddress = ARBSeparateShaderObjects.getInstance().ProgramUniform4d;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        GL41.nglProgramUniform4d(program, location, x, y, z, w, __functionAddress);
    }

    public static void nglProgramUniform1iv(int program, int location, int count, long value) {
        long __functionAddress = ARBSeparateShaderObjects.getInstance().ProgramUniform1iv;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        GL41.nglProgramUniform1iv(program, location, count, value, __functionAddress);
    }

    public static void glProgramUniform1iv(int program, int location, int count, ByteBuffer value) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkBuffer((Buffer)value, count << 2);
        }
        ARBSeparateShaderObjects.nglProgramUniform1iv(program, location, count, MemoryUtil.memAddress(value));
    }

    public static void glProgramUniform1iv(int program, int location, IntBuffer value) {
        ARBSeparateShaderObjects.nglProgramUniform1iv(program, location, value.remaining(), MemoryUtil.memAddress(value));
    }

    public static void nglProgramUniform2iv(int program, int location, int count, long value) {
        long __functionAddress = ARBSeparateShaderObjects.getInstance().ProgramUniform2iv;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        GL41.nglProgramUniform2iv(program, location, count, value, __functionAddress);
    }

    public static void glProgramUniform2iv(int program, int location, int count, ByteBuffer value) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkBuffer((Buffer)value, count << 1 << 2);
        }
        ARBSeparateShaderObjects.nglProgramUniform2iv(program, location, count, MemoryUtil.memAddress(value));
    }

    public static void glProgramUniform2iv(int program, int location, IntBuffer value) {
        ARBSeparateShaderObjects.nglProgramUniform2iv(program, location, value.remaining() >> 1, MemoryUtil.memAddress(value));
    }

    public static void nglProgramUniform3iv(int program, int location, int count, long value) {
        long __functionAddress = ARBSeparateShaderObjects.getInstance().ProgramUniform3iv;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        GL41.nglProgramUniform3iv(program, location, count, value, __functionAddress);
    }

    public static void glProgramUniform3iv(int program, int location, int count, ByteBuffer value) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkBuffer((Buffer)value, count * 9 << 2);
        }
        ARBSeparateShaderObjects.nglProgramUniform3iv(program, location, count, MemoryUtil.memAddress(value));
    }

    public static void glProgramUniform3iv(int program, int location, IntBuffer value) {
        ARBSeparateShaderObjects.nglProgramUniform3iv(program, location, value.remaining() / 9, MemoryUtil.memAddress(value));
    }

    public static void nglProgramUniform4iv(int program, int location, int count, long value) {
        long __functionAddress = ARBSeparateShaderObjects.getInstance().ProgramUniform4iv;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        GL41.nglProgramUniform4iv(program, location, count, value, __functionAddress);
    }

    public static void glProgramUniform4iv(int program, int location, int count, ByteBuffer value) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkBuffer((Buffer)value, count << 2 << 2);
        }
        ARBSeparateShaderObjects.nglProgramUniform4iv(program, location, count, MemoryUtil.memAddress(value));
    }

    public static void glProgramUniform4iv(int program, int location, IntBuffer value) {
        ARBSeparateShaderObjects.nglProgramUniform4iv(program, location, value.remaining() >> 2, MemoryUtil.memAddress(value));
    }

    public static void nglProgramUniform1uiv(int program, int location, int count, long value) {
        long __functionAddress = ARBSeparateShaderObjects.getInstance().ProgramUniform1uiv;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        GL41.nglProgramUniform1uiv(program, location, count, value, __functionAddress);
    }

    public static void glProgramUniform1uiv(int program, int location, int count, ByteBuffer value) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkBuffer((Buffer)value, count << 2);
        }
        ARBSeparateShaderObjects.nglProgramUniform1uiv(program, location, count, MemoryUtil.memAddress(value));
    }

    public static void glProgramUniform1uiv(int program, int location, IntBuffer value) {
        ARBSeparateShaderObjects.nglProgramUniform1uiv(program, location, value.remaining(), MemoryUtil.memAddress(value));
    }

    public static void nglProgramUniform2uiv(int program, int location, int count, long value) {
        long __functionAddress = ARBSeparateShaderObjects.getInstance().ProgramUniform2uiv;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        GL41.nglProgramUniform2uiv(program, location, count, value, __functionAddress);
    }

    public static void glProgramUniform2uiv(int program, int location, int count, ByteBuffer value) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkBuffer((Buffer)value, count << 1 << 2);
        }
        ARBSeparateShaderObjects.nglProgramUniform2uiv(program, location, count, MemoryUtil.memAddress(value));
    }

    public static void glProgramUniform2uiv(int program, int location, IntBuffer value) {
        ARBSeparateShaderObjects.nglProgramUniform2uiv(program, location, value.remaining() >> 1, MemoryUtil.memAddress(value));
    }

    public static void nglProgramUniform3uiv(int program, int location, int count, long value) {
        long __functionAddress = ARBSeparateShaderObjects.getInstance().ProgramUniform3uiv;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        GL41.nglProgramUniform3uiv(program, location, count, value, __functionAddress);
    }

    public static void glProgramUniform3uiv(int program, int location, int count, ByteBuffer value) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkBuffer((Buffer)value, count * 9 << 2);
        }
        ARBSeparateShaderObjects.nglProgramUniform3uiv(program, location, count, MemoryUtil.memAddress(value));
    }

    public static void glProgramUniform3uiv(int program, int location, IntBuffer value) {
        ARBSeparateShaderObjects.nglProgramUniform3uiv(program, location, value.remaining() / 9, MemoryUtil.memAddress(value));
    }

    public static void nglProgramUniform4uiv(int program, int location, int count, long value) {
        long __functionAddress = ARBSeparateShaderObjects.getInstance().ProgramUniform4uiv;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        GL41.nglProgramUniform4uiv(program, location, count, value, __functionAddress);
    }

    public static void glProgramUniform4uiv(int program, int location, int count, ByteBuffer value) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkBuffer((Buffer)value, count << 2 << 2);
        }
        ARBSeparateShaderObjects.nglProgramUniform4uiv(program, location, count, MemoryUtil.memAddress(value));
    }

    public static void glProgramUniform4uiv(int program, int location, IntBuffer value) {
        ARBSeparateShaderObjects.nglProgramUniform4uiv(program, location, value.remaining() >> 2, MemoryUtil.memAddress(value));
    }

    public static void nglProgramUniform1fv(int program, int location, int count, long value) {
        long __functionAddress = ARBSeparateShaderObjects.getInstance().ProgramUniform1fv;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        GL41.nglProgramUniform1fv(program, location, count, value, __functionAddress);
    }

    public static void glProgramUniform1fv(int program, int location, int count, ByteBuffer value) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkBuffer((Buffer)value, count << 2);
        }
        ARBSeparateShaderObjects.nglProgramUniform1fv(program, location, count, MemoryUtil.memAddress(value));
    }

    public static void glProgramUniform1fv(int program, int location, FloatBuffer value) {
        ARBSeparateShaderObjects.nglProgramUniform1fv(program, location, value.remaining(), MemoryUtil.memAddress(value));
    }

    public static void nglProgramUniform2fv(int program, int location, int count, long value) {
        long __functionAddress = ARBSeparateShaderObjects.getInstance().ProgramUniform2fv;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        GL41.nglProgramUniform2fv(program, location, count, value, __functionAddress);
    }

    public static void glProgramUniform2fv(int program, int location, int count, ByteBuffer value) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkBuffer((Buffer)value, count << 1 << 2);
        }
        ARBSeparateShaderObjects.nglProgramUniform2fv(program, location, count, MemoryUtil.memAddress(value));
    }

    public static void glProgramUniform2fv(int program, int location, FloatBuffer value) {
        ARBSeparateShaderObjects.nglProgramUniform2fv(program, location, value.remaining() >> 1, MemoryUtil.memAddress(value));
    }

    public static void nglProgramUniform3fv(int program, int location, int count, long value) {
        long __functionAddress = ARBSeparateShaderObjects.getInstance().ProgramUniform3fv;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        GL41.nglProgramUniform3fv(program, location, count, value, __functionAddress);
    }

    public static void glProgramUniform3fv(int program, int location, int count, ByteBuffer value) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkBuffer((Buffer)value, count * 9 << 2);
        }
        ARBSeparateShaderObjects.nglProgramUniform3fv(program, location, count, MemoryUtil.memAddress(value));
    }

    public static void glProgramUniform3fv(int program, int location, FloatBuffer value) {
        ARBSeparateShaderObjects.nglProgramUniform3fv(program, location, value.remaining() / 9, MemoryUtil.memAddress(value));
    }

    public static void nglProgramUniform4fv(int program, int location, int count, long value) {
        long __functionAddress = ARBSeparateShaderObjects.getInstance().ProgramUniform4fv;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        GL41.nglProgramUniform4fv(program, location, count, value, __functionAddress);
    }

    public static void glProgramUniform4fv(int program, int location, int count, ByteBuffer value) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkBuffer((Buffer)value, count << 2 << 2);
        }
        ARBSeparateShaderObjects.nglProgramUniform4fv(program, location, count, MemoryUtil.memAddress(value));
    }

    public static void glProgramUniform4fv(int program, int location, FloatBuffer value) {
        ARBSeparateShaderObjects.nglProgramUniform4fv(program, location, value.remaining() >> 2, MemoryUtil.memAddress(value));
    }

    public static void nglProgramUniform1dv(int program, int location, int count, long value) {
        long __functionAddress = ARBSeparateShaderObjects.getInstance().ProgramUniform1dv;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        GL41.nglProgramUniform1dv(program, location, count, value, __functionAddress);
    }

    public static void glProgramUniform1dv(int program, int location, int count, ByteBuffer value) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkBuffer((Buffer)value, count << 3);
        }
        ARBSeparateShaderObjects.nglProgramUniform1dv(program, location, count, MemoryUtil.memAddress(value));
    }

    public static void glProgramUniform1dv(int program, int location, DoubleBuffer value) {
        ARBSeparateShaderObjects.nglProgramUniform1dv(program, location, value.remaining(), MemoryUtil.memAddress(value));
    }

    public static void nglProgramUniform2dv(int program, int location, int count, long value) {
        long __functionAddress = ARBSeparateShaderObjects.getInstance().ProgramUniform2dv;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        GL41.nglProgramUniform2dv(program, location, count, value, __functionAddress);
    }

    public static void glProgramUniform2dv(int program, int location, int count, ByteBuffer value) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkBuffer((Buffer)value, count << 1 << 3);
        }
        ARBSeparateShaderObjects.nglProgramUniform2dv(program, location, count, MemoryUtil.memAddress(value));
    }

    public static void glProgramUniform2dv(int program, int location, DoubleBuffer value) {
        ARBSeparateShaderObjects.nglProgramUniform2dv(program, location, value.remaining() >> 1, MemoryUtil.memAddress(value));
    }

    public static void nglProgramUniform3dv(int program, int location, int count, long value) {
        long __functionAddress = ARBSeparateShaderObjects.getInstance().ProgramUniform3dv;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        GL41.nglProgramUniform3dv(program, location, count, value, __functionAddress);
    }

    public static void glProgramUniform3dv(int program, int location, int count, ByteBuffer value) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkBuffer((Buffer)value, count * 9 << 3);
        }
        ARBSeparateShaderObjects.nglProgramUniform3dv(program, location, count, MemoryUtil.memAddress(value));
    }

    public static void glProgramUniform3dv(int program, int location, DoubleBuffer value) {
        ARBSeparateShaderObjects.nglProgramUniform3dv(program, location, value.remaining() / 9, MemoryUtil.memAddress(value));
    }

    public static void nglProgramUniform4dv(int program, int location, int count, long value) {
        long __functionAddress = ARBSeparateShaderObjects.getInstance().ProgramUniform4dv;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        GL41.nglProgramUniform4dv(program, location, count, value, __functionAddress);
    }

    public static void glProgramUniform4dv(int program, int location, int count, ByteBuffer value) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkBuffer((Buffer)value, count << 2 << 3);
        }
        ARBSeparateShaderObjects.nglProgramUniform4dv(program, location, count, MemoryUtil.memAddress(value));
    }

    public static void glProgramUniform4dv(int program, int location, DoubleBuffer value) {
        ARBSeparateShaderObjects.nglProgramUniform4dv(program, location, value.remaining() >> 2, MemoryUtil.memAddress(value));
    }

    public static void nglProgramUniformMatrix2fv(int program, int location, int count, boolean transpose, long value) {
        long __functionAddress = ARBSeparateShaderObjects.getInstance().ProgramUniformMatrix2fv;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        GL41.nglProgramUniformMatrix2fv(program, location, count, transpose, value, __functionAddress);
    }

    public static void glProgramUniformMatrix2fv(int program, int location, int count, boolean transpose, ByteBuffer value) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkBuffer((Buffer)value, count << 2 << 2);
        }
        ARBSeparateShaderObjects.nglProgramUniformMatrix2fv(program, location, count, transpose, MemoryUtil.memAddress(value));
    }

    public static void glProgramUniformMatrix2fv(int program, int location, boolean transpose, FloatBuffer value) {
        ARBSeparateShaderObjects.nglProgramUniformMatrix2fv(program, location, value.remaining() >> 2, transpose, MemoryUtil.memAddress(value));
    }

    public static void nglProgramUniformMatrix3fv(int program, int location, int count, boolean transpose, long value) {
        long __functionAddress = ARBSeparateShaderObjects.getInstance().ProgramUniformMatrix3fv;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        GL41.nglProgramUniformMatrix3fv(program, location, count, transpose, value, __functionAddress);
    }

    public static void glProgramUniformMatrix3fv(int program, int location, int count, boolean transpose, ByteBuffer value) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkBuffer((Buffer)value, count * 9 << 2);
        }
        ARBSeparateShaderObjects.nglProgramUniformMatrix3fv(program, location, count, transpose, MemoryUtil.memAddress(value));
    }

    public static void glProgramUniformMatrix3fv(int program, int location, boolean transpose, FloatBuffer value) {
        ARBSeparateShaderObjects.nglProgramUniformMatrix3fv(program, location, value.remaining() / 9, transpose, MemoryUtil.memAddress(value));
    }

    public static void nglProgramUniformMatrix4fv(int program, int location, int count, boolean transpose, long value) {
        long __functionAddress = ARBSeparateShaderObjects.getInstance().ProgramUniformMatrix4fv;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        GL41.nglProgramUniformMatrix4fv(program, location, count, transpose, value, __functionAddress);
    }

    public static void glProgramUniformMatrix4fv(int program, int location, int count, boolean transpose, ByteBuffer value) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkBuffer((Buffer)value, count << 4 << 2);
        }
        ARBSeparateShaderObjects.nglProgramUniformMatrix4fv(program, location, count, transpose, MemoryUtil.memAddress(value));
    }

    public static void glProgramUniformMatrix4fv(int program, int location, boolean transpose, FloatBuffer value) {
        ARBSeparateShaderObjects.nglProgramUniformMatrix4fv(program, location, value.remaining() >> 4, transpose, MemoryUtil.memAddress(value));
    }

    public static void nglProgramUniformMatrix2dv(int program, int location, int count, boolean transpose, long value) {
        long __functionAddress = ARBSeparateShaderObjects.getInstance().ProgramUniformMatrix2dv;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        GL41.nglProgramUniformMatrix2dv(program, location, count, transpose, value, __functionAddress);
    }

    public static void glProgramUniformMatrix2dv(int program, int location, int count, boolean transpose, ByteBuffer value) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkBuffer((Buffer)value, count << 2 << 3);
        }
        ARBSeparateShaderObjects.nglProgramUniformMatrix2dv(program, location, count, transpose, MemoryUtil.memAddress(value));
    }

    public static void glProgramUniformMatrix2dv(int program, int location, boolean transpose, DoubleBuffer value) {
        ARBSeparateShaderObjects.nglProgramUniformMatrix2dv(program, location, value.remaining() >> 2, transpose, MemoryUtil.memAddress(value));
    }

    public static void nglProgramUniformMatrix3dv(int program, int location, int count, boolean transpose, long value) {
        long __functionAddress = ARBSeparateShaderObjects.getInstance().ProgramUniformMatrix3dv;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        GL41.nglProgramUniformMatrix3dv(program, location, count, transpose, value, __functionAddress);
    }

    public static void glProgramUniformMatrix3dv(int program, int location, int count, boolean transpose, ByteBuffer value) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkBuffer((Buffer)value, count * 9 << 3);
        }
        ARBSeparateShaderObjects.nglProgramUniformMatrix3dv(program, location, count, transpose, MemoryUtil.memAddress(value));
    }

    public static void glProgramUniformMatrix3dv(int program, int location, boolean transpose, DoubleBuffer value) {
        ARBSeparateShaderObjects.nglProgramUniformMatrix3dv(program, location, value.remaining() / 9, transpose, MemoryUtil.memAddress(value));
    }

    public static void nglProgramUniformMatrix4dv(int program, int location, int count, boolean transpose, long value) {
        long __functionAddress = ARBSeparateShaderObjects.getInstance().ProgramUniformMatrix4dv;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        GL41.nglProgramUniformMatrix4dv(program, location, count, transpose, value, __functionAddress);
    }

    public static void glProgramUniformMatrix4dv(int program, int location, int count, boolean transpose, ByteBuffer value) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkBuffer((Buffer)value, count << 4 << 3);
        }
        ARBSeparateShaderObjects.nglProgramUniformMatrix4dv(program, location, count, transpose, MemoryUtil.memAddress(value));
    }

    public static void glProgramUniformMatrix4dv(int program, int location, boolean transpose, DoubleBuffer value) {
        ARBSeparateShaderObjects.nglProgramUniformMatrix4dv(program, location, value.remaining() >> 4, transpose, MemoryUtil.memAddress(value));
    }

    public static void nglProgramUniformMatrix2x3fv(int program, int location, int count, boolean transpose, long value) {
        long __functionAddress = ARBSeparateShaderObjects.getInstance().ProgramUniformMatrix2x3fv;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        GL41.nglProgramUniformMatrix2x3fv(program, location, count, transpose, value, __functionAddress);
    }

    public static void glProgramUniformMatrix2x3fv(int program, int location, int count, boolean transpose, ByteBuffer value) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkBuffer((Buffer)value, count * 6 << 2);
        }
        ARBSeparateShaderObjects.nglProgramUniformMatrix2x3fv(program, location, count, transpose, MemoryUtil.memAddress(value));
    }

    public static void glProgramUniformMatrix2x3fv(int program, int location, boolean transpose, FloatBuffer value) {
        ARBSeparateShaderObjects.nglProgramUniformMatrix2x3fv(program, location, value.remaining() / 6, transpose, MemoryUtil.memAddress(value));
    }

    public static void nglProgramUniformMatrix3x2fv(int program, int location, int count, boolean transpose, long value) {
        long __functionAddress = ARBSeparateShaderObjects.getInstance().ProgramUniformMatrix3x2fv;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        GL41.nglProgramUniformMatrix3x2fv(program, location, count, transpose, value, __functionAddress);
    }

    public static void glProgramUniformMatrix3x2fv(int program, int location, int count, boolean transpose, ByteBuffer value) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkBuffer((Buffer)value, count * 6 << 2);
        }
        ARBSeparateShaderObjects.nglProgramUniformMatrix3x2fv(program, location, count, transpose, MemoryUtil.memAddress(value));
    }

    public static void glProgramUniformMatrix3x2fv(int program, int location, boolean transpose, FloatBuffer value) {
        ARBSeparateShaderObjects.nglProgramUniformMatrix3x2fv(program, location, value.remaining() / 6, transpose, MemoryUtil.memAddress(value));
    }

    public static void nglProgramUniformMatrix2x4fv(int program, int location, int count, boolean transpose, long value) {
        long __functionAddress = ARBSeparateShaderObjects.getInstance().ProgramUniformMatrix2x4fv;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        GL41.nglProgramUniformMatrix2x4fv(program, location, count, transpose, value, __functionAddress);
    }

    public static void glProgramUniformMatrix2x4fv(int program, int location, int count, boolean transpose, ByteBuffer value) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkBuffer((Buffer)value, count << 3 << 2);
        }
        ARBSeparateShaderObjects.nglProgramUniformMatrix2x4fv(program, location, count, transpose, MemoryUtil.memAddress(value));
    }

    public static void glProgramUniformMatrix2x4fv(int program, int location, boolean transpose, FloatBuffer value) {
        ARBSeparateShaderObjects.nglProgramUniformMatrix2x4fv(program, location, value.remaining() >> 3, transpose, MemoryUtil.memAddress(value));
    }

    public static void nglProgramUniformMatrix4x2fv(int program, int location, int count, boolean transpose, long value) {
        long __functionAddress = ARBSeparateShaderObjects.getInstance().ProgramUniformMatrix4x2fv;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        GL41.nglProgramUniformMatrix4x2fv(program, location, count, transpose, value, __functionAddress);
    }

    public static void glProgramUniformMatrix4x2fv(int program, int location, int count, boolean transpose, ByteBuffer value) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkBuffer((Buffer)value, count << 3 << 2);
        }
        ARBSeparateShaderObjects.nglProgramUniformMatrix4x2fv(program, location, count, transpose, MemoryUtil.memAddress(value));
    }

    public static void glProgramUniformMatrix4x2fv(int program, int location, boolean transpose, FloatBuffer value) {
        ARBSeparateShaderObjects.nglProgramUniformMatrix4x2fv(program, location, value.remaining() >> 3, transpose, MemoryUtil.memAddress(value));
    }

    public static void nglProgramUniformMatrix3x4fv(int program, int location, int count, boolean transpose, long value) {
        long __functionAddress = ARBSeparateShaderObjects.getInstance().ProgramUniformMatrix3x4fv;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        GL41.nglProgramUniformMatrix3x4fv(program, location, count, transpose, value, __functionAddress);
    }

    public static void glProgramUniformMatrix3x4fv(int program, int location, int count, boolean transpose, ByteBuffer value) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkBuffer((Buffer)value, count * 12 << 2);
        }
        ARBSeparateShaderObjects.nglProgramUniformMatrix3x4fv(program, location, count, transpose, MemoryUtil.memAddress(value));
    }

    public static void glProgramUniformMatrix3x4fv(int program, int location, boolean transpose, FloatBuffer value) {
        ARBSeparateShaderObjects.nglProgramUniformMatrix3x4fv(program, location, value.remaining() / 12, transpose, MemoryUtil.memAddress(value));
    }

    public static void nglProgramUniformMatrix4x3fv(int program, int location, int count, boolean transpose, long value) {
        long __functionAddress = ARBSeparateShaderObjects.getInstance().ProgramUniformMatrix4x3fv;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        GL41.nglProgramUniformMatrix4x3fv(program, location, count, transpose, value, __functionAddress);
    }

    public static void glProgramUniformMatrix4x3fv(int program, int location, int count, boolean transpose, ByteBuffer value) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkBuffer((Buffer)value, count * 12 << 2);
        }
        ARBSeparateShaderObjects.nglProgramUniformMatrix4x3fv(program, location, count, transpose, MemoryUtil.memAddress(value));
    }

    public static void glProgramUniformMatrix4x3fv(int program, int location, boolean transpose, FloatBuffer value) {
        ARBSeparateShaderObjects.nglProgramUniformMatrix4x3fv(program, location, value.remaining() / 12, transpose, MemoryUtil.memAddress(value));
    }

    public static void nglProgramUniformMatrix2x3dv(int program, int location, int count, boolean transpose, long value) {
        long __functionAddress = ARBSeparateShaderObjects.getInstance().ProgramUniformMatrix2x3dv;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        GL41.nglProgramUniformMatrix2x3dv(program, location, count, transpose, value, __functionAddress);
    }

    public static void glProgramUniformMatrix2x3dv(int program, int location, int count, boolean transpose, ByteBuffer value) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkBuffer((Buffer)value, count * 6 << 3);
        }
        ARBSeparateShaderObjects.nglProgramUniformMatrix2x3dv(program, location, count, transpose, MemoryUtil.memAddress(value));
    }

    public static void glProgramUniformMatrix2x3dv(int program, int location, boolean transpose, DoubleBuffer value) {
        ARBSeparateShaderObjects.nglProgramUniformMatrix2x3dv(program, location, value.remaining() / 6, transpose, MemoryUtil.memAddress(value));
    }

    public static void nglProgramUniformMatrix3x2dv(int program, int location, int count, boolean transpose, long value) {
        long __functionAddress = ARBSeparateShaderObjects.getInstance().ProgramUniformMatrix3x2dv;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        GL41.nglProgramUniformMatrix3x2dv(program, location, count, transpose, value, __functionAddress);
    }

    public static void glProgramUniformMatrix3x2dv(int program, int location, int count, boolean transpose, ByteBuffer value) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkBuffer((Buffer)value, count * 6 << 3);
        }
        ARBSeparateShaderObjects.nglProgramUniformMatrix3x2dv(program, location, count, transpose, MemoryUtil.memAddress(value));
    }

    public static void glProgramUniformMatrix3x2dv(int program, int location, boolean transpose, DoubleBuffer value) {
        ARBSeparateShaderObjects.nglProgramUniformMatrix3x2dv(program, location, value.remaining() / 6, transpose, MemoryUtil.memAddress(value));
    }

    public static void nglProgramUniformMatrix2x4dv(int program, int location, int count, boolean transpose, long value) {
        long __functionAddress = ARBSeparateShaderObjects.getInstance().ProgramUniformMatrix2x4dv;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        GL41.nglProgramUniformMatrix2x4dv(program, location, count, transpose, value, __functionAddress);
    }

    public static void glProgramUniformMatrix2x4dv(int program, int location, int count, boolean transpose, ByteBuffer value) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkBuffer((Buffer)value, count << 3 << 3);
        }
        ARBSeparateShaderObjects.nglProgramUniformMatrix2x4dv(program, location, count, transpose, MemoryUtil.memAddress(value));
    }

    public static void glProgramUniformMatrix2x4dv(int program, int location, boolean transpose, DoubleBuffer value) {
        ARBSeparateShaderObjects.nglProgramUniformMatrix2x4dv(program, location, value.remaining() >> 3, transpose, MemoryUtil.memAddress(value));
    }

    public static void nglProgramUniformMatrix4x2dv(int program, int location, int count, boolean transpose, long value) {
        long __functionAddress = ARBSeparateShaderObjects.getInstance().ProgramUniformMatrix4x2dv;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        GL41.nglProgramUniformMatrix4x2dv(program, location, count, transpose, value, __functionAddress);
    }

    public static void glProgramUniformMatrix4x2dv(int program, int location, int count, boolean transpose, ByteBuffer value) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkBuffer((Buffer)value, count << 3 << 3);
        }
        ARBSeparateShaderObjects.nglProgramUniformMatrix4x2dv(program, location, count, transpose, MemoryUtil.memAddress(value));
    }

    public static void glProgramUniformMatrix4x2dv(int program, int location, boolean transpose, DoubleBuffer value) {
        ARBSeparateShaderObjects.nglProgramUniformMatrix4x2dv(program, location, value.remaining() >> 3, transpose, MemoryUtil.memAddress(value));
    }

    public static void nglProgramUniformMatrix3x4dv(int program, int location, int count, boolean transpose, long value) {
        long __functionAddress = ARBSeparateShaderObjects.getInstance().ProgramUniformMatrix3x4dv;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        GL41.nglProgramUniformMatrix3x4dv(program, location, count, transpose, value, __functionAddress);
    }

    public static void glProgramUniformMatrix3x4dv(int program, int location, int count, boolean transpose, ByteBuffer value) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkBuffer((Buffer)value, count * 12 << 3);
        }
        ARBSeparateShaderObjects.nglProgramUniformMatrix3x4dv(program, location, count, transpose, MemoryUtil.memAddress(value));
    }

    public static void glProgramUniformMatrix3x4dv(int program, int location, boolean transpose, DoubleBuffer value) {
        ARBSeparateShaderObjects.nglProgramUniformMatrix3x4dv(program, location, value.remaining() / 12, transpose, MemoryUtil.memAddress(value));
    }

    public static void nglProgramUniformMatrix4x3dv(int program, int location, int count, boolean transpose, long value) {
        long __functionAddress = ARBSeparateShaderObjects.getInstance().ProgramUniformMatrix4x3dv;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        GL41.nglProgramUniformMatrix4x3dv(program, location, count, transpose, value, __functionAddress);
    }

    public static void glProgramUniformMatrix4x3dv(int program, int location, int count, boolean transpose, ByteBuffer value) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkBuffer((Buffer)value, count * 12 << 3);
        }
        ARBSeparateShaderObjects.nglProgramUniformMatrix4x3dv(program, location, count, transpose, MemoryUtil.memAddress(value));
    }

    public static void glProgramUniformMatrix4x3dv(int program, int location, boolean transpose, DoubleBuffer value) {
        ARBSeparateShaderObjects.nglProgramUniformMatrix4x3dv(program, location, value.remaining() / 12, transpose, MemoryUtil.memAddress(value));
    }

    public static void glValidateProgramPipeline(int pipeline) {
        long __functionAddress = ARBSeparateShaderObjects.getInstance().ValidateProgramPipeline;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        GL41.nglValidateProgramPipeline(pipeline, __functionAddress);
    }

    public static void nglGetProgramPipelineInfoLog(int pipeline, int bufSize, long length, long infoLog) {
        long __functionAddress = ARBSeparateShaderObjects.getInstance().GetProgramPipelineInfoLog;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        GL41.nglGetProgramPipelineInfoLog(pipeline, bufSize, length, infoLog, __functionAddress);
    }

    public static void glGetProgramPipelineInfoLog(int pipeline, int bufSize, ByteBuffer length, ByteBuffer infoLog) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkBuffer((Buffer)infoLog, bufSize);
            if (length != null) {
                Checks.checkBuffer((Buffer)length, 4);
            }
        }
        ARBSeparateShaderObjects.nglGetProgramPipelineInfoLog(pipeline, bufSize, MemoryUtil.memAddressSafe(length), MemoryUtil.memAddress(infoLog));
    }

    public static void glGetProgramPipelineInfoLog(int pipeline, IntBuffer length, ByteBuffer infoLog) {
        if (LWJGLUtil.CHECKS && length != null) {
            Checks.checkBuffer((Buffer)length, 1);
        }
        ARBSeparateShaderObjects.nglGetProgramPipelineInfoLog(pipeline, infoLog.remaining(), MemoryUtil.memAddressSafe(length), MemoryUtil.memAddress(infoLog));
    }

    public static String glGetProgramPipelineInfoLog(int pipeline, int bufSize) {
        APIBuffer __buffer = APIUtil.apiBuffer();
        int length = __buffer.intParam();
        int infoLog = __buffer.bufferParam(bufSize);
        ARBSeparateShaderObjects.nglGetProgramPipelineInfoLog(pipeline, bufSize, __buffer.address(length), __buffer.address(infoLog));
        return MemoryUtil.memDecodeUTF8(MemoryUtil.memByteBuffer(__buffer.address(infoLog), __buffer.intValue(length)));
    }

    public static String glGetProgramPipelineInfoLog(int pipeline) {
        int bufSize = ARBSeparateShaderObjects.glGetProgramPipelinei(pipeline, 35716);
        APIBuffer __buffer = APIUtil.apiBuffer();
        int length = __buffer.intParam();
        int infoLog = __buffer.bufferParam(bufSize);
        ARBSeparateShaderObjects.nglGetProgramPipelineInfoLog(pipeline, bufSize, __buffer.address(length), __buffer.address(infoLog));
        return MemoryUtil.memDecodeUTF8(MemoryUtil.memByteBuffer(__buffer.address(infoLog), __buffer.intValue(length)));
    }
}

