/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.opengl;

import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.DoubleBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.nio.ShortBuffer;
import java.util.Set;
import org.lwjgl.LWJGLUtil;
import org.lwjgl.opengl.GL;
import org.lwjgl.opengl.GL45;
import org.lwjgl.opengl.GLChecks;
import org.lwjgl.system.Checks;
import org.lwjgl.system.FunctionProvider;
import org.lwjgl.system.MemoryUtil;

public final class ARBGetTextureSubImage {
    public final long GetTextureSubImage;
    public final long GetCompressedTextureSubImage;

    public ARBGetTextureSubImage(FunctionProvider provider) {
        this.GetTextureSubImage = provider.getFunctionAddress("glGetTextureSubImage");
        this.GetCompressedTextureSubImage = provider.getFunctionAddress("glGetCompressedTextureSubImage");
    }

    public static ARBGetTextureSubImage getInstance() {
        return GL.getCapabilities().__ARBGetTextureSubImage;
    }

    static ARBGetTextureSubImage create(Set<String> ext, FunctionProvider provider) {
        if (!ext.contains("GL_ARB_get_texture_sub_image")) {
            return null;
        }
        ARBGetTextureSubImage funcs = new ARBGetTextureSubImage(provider);
        boolean supported = Checks.checkFunctions(funcs.GetTextureSubImage, funcs.GetCompressedTextureSubImage);
        return GL.checkExtension("GL_ARB_get_texture_sub_image", funcs, supported);
    }

    public static void nglGetTextureSubImage(int texture, int level, int xoffset, int yoffset, int zoffset, int width, int height, int depth, int format, int type, int bufSize, long pixels) {
        long __functionAddress = ARBGetTextureSubImage.getInstance().GetTextureSubImage;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        GL45.nglGetTextureSubImage(texture, level, xoffset, yoffset, zoffset, width, height, depth, format, type, bufSize, pixels, __functionAddress);
    }

    public static void glGetTextureSubImage(int texture, int level, int xoffset, int yoffset, int zoffset, int width, int height, int depth, int format, int type, int bufSize, ByteBuffer pixels) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkBuffer((Buffer)pixels, bufSize);
            GLChecks.ensureBufferObject(35053, false);
        }
        ARBGetTextureSubImage.nglGetTextureSubImage(texture, level, xoffset, yoffset, zoffset, width, height, depth, format, type, bufSize, MemoryUtil.memAddress(pixels));
    }

    public static void glGetTextureSubImage(int texture, int level, int xoffset, int yoffset, int zoffset, int width, int height, int depth, int format, int type, int bufSize, long pixelsOffset) {
        if (LWJGLUtil.CHECKS) {
            GLChecks.ensureBufferObject(35053, true);
        }
        ARBGetTextureSubImage.nglGetTextureSubImage(texture, level, xoffset, yoffset, zoffset, width, height, depth, format, type, bufSize, pixelsOffset);
    }

    public static void glGetTextureSubImage(int texture, int level, int xoffset, int yoffset, int zoffset, int width, int height, int depth, int format, int type, ShortBuffer pixels) {
        if (LWJGLUtil.CHECKS) {
            GLChecks.ensureBufferObject(35053, false);
        }
        ARBGetTextureSubImage.nglGetTextureSubImage(texture, level, xoffset, yoffset, zoffset, width, height, depth, format, type, pixels.remaining() << 1, MemoryUtil.memAddress(pixels));
    }

    public static void glGetTextureSubImage(int texture, int level, int xoffset, int yoffset, int zoffset, int width, int height, int depth, int format, int type, IntBuffer pixels) {
        if (LWJGLUtil.CHECKS) {
            GLChecks.ensureBufferObject(35053, false);
        }
        ARBGetTextureSubImage.nglGetTextureSubImage(texture, level, xoffset, yoffset, zoffset, width, height, depth, format, type, pixels.remaining() << 2, MemoryUtil.memAddress(pixels));
    }

    public static void glGetTextureSubImage(int texture, int level, int xoffset, int yoffset, int zoffset, int width, int height, int depth, int format, int type, FloatBuffer pixels) {
        if (LWJGLUtil.CHECKS) {
            GLChecks.ensureBufferObject(35053, false);
        }
        ARBGetTextureSubImage.nglGetTextureSubImage(texture, level, xoffset, yoffset, zoffset, width, height, depth, format, type, pixels.remaining() << 2, MemoryUtil.memAddress(pixels));
    }

    public static void glGetTextureSubImage(int texture, int level, int xoffset, int yoffset, int zoffset, int width, int height, int depth, int format, int type, DoubleBuffer pixels) {
        if (LWJGLUtil.CHECKS) {
            GLChecks.ensureBufferObject(35053, false);
        }
        ARBGetTextureSubImage.nglGetTextureSubImage(texture, level, xoffset, yoffset, zoffset, width, height, depth, format, type, pixels.remaining() << 3, MemoryUtil.memAddress(pixels));
    }

    public static void nglGetCompressedTextureSubImage(int texture, int level, int xoffset, int yoffset, int zoffset, int width, int height, int depth, int bufSize, long pixels) {
        long __functionAddress = ARBGetTextureSubImage.getInstance().GetCompressedTextureSubImage;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        GL45.nglGetCompressedTextureSubImage(texture, level, xoffset, yoffset, zoffset, width, height, depth, bufSize, pixels, __functionAddress);
    }

    public static void glGetCompressedTextureSubImage(int texture, int level, int xoffset, int yoffset, int zoffset, int width, int height, int depth, int bufSize, ByteBuffer pixels) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkBuffer((Buffer)pixels, bufSize);
            GLChecks.ensureBufferObject(35053, false);
        }
        ARBGetTextureSubImage.nglGetCompressedTextureSubImage(texture, level, xoffset, yoffset, zoffset, width, height, depth, bufSize, MemoryUtil.memAddress(pixels));
    }

    public static void glGetCompressedTextureSubImage(int texture, int level, int xoffset, int yoffset, int zoffset, int width, int height, int depth, int bufSize, long pixelsOffset) {
        if (LWJGLUtil.CHECKS) {
            GLChecks.ensureBufferObject(35053, true);
        }
        ARBGetTextureSubImage.nglGetCompressedTextureSubImage(texture, level, xoffset, yoffset, zoffset, width, height, depth, bufSize, pixelsOffset);
    }

    public static void glGetCompressedTextureSubImage(int texture, int level, int xoffset, int yoffset, int zoffset, int width, int height, int depth, ShortBuffer pixels) {
        if (LWJGLUtil.CHECKS) {
            GLChecks.ensureBufferObject(35053, false);
        }
        ARBGetTextureSubImage.nglGetCompressedTextureSubImage(texture, level, xoffset, yoffset, zoffset, width, height, depth, pixels.remaining() << 1, MemoryUtil.memAddress(pixels));
    }

    public static void glGetCompressedTextureSubImage(int texture, int level, int xoffset, int yoffset, int zoffset, int width, int height, int depth, IntBuffer pixels) {
        if (LWJGLUtil.CHECKS) {
            GLChecks.ensureBufferObject(35053, false);
        }
        ARBGetTextureSubImage.nglGetCompressedTextureSubImage(texture, level, xoffset, yoffset, zoffset, width, height, depth, pixels.remaining() << 2, MemoryUtil.memAddress(pixels));
    }

    public static void glGetCompressedTextureSubImage(int texture, int level, int xoffset, int yoffset, int zoffset, int width, int height, int depth, FloatBuffer pixels) {
        if (LWJGLUtil.CHECKS) {
            GLChecks.ensureBufferObject(35053, false);
        }
        ARBGetTextureSubImage.nglGetCompressedTextureSubImage(texture, level, xoffset, yoffset, zoffset, width, height, depth, pixels.remaining() << 2, MemoryUtil.memAddress(pixels));
    }

    public static void glGetCompressedTextureSubImage(int texture, int level, int xoffset, int yoffset, int zoffset, int width, int height, int depth, DoubleBuffer pixels) {
        if (LWJGLUtil.CHECKS) {
            GLChecks.ensureBufferObject(35053, false);
        }
        ARBGetTextureSubImage.nglGetCompressedTextureSubImage(texture, level, xoffset, yoffset, zoffset, width, height, depth, pixels.remaining() << 3, MemoryUtil.memAddress(pixels));
    }
}

