/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.opengl;

import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import java.util.Set;
import org.lwjgl.LWJGLUtil;
import org.lwjgl.opengl.GL;
import org.lwjgl.opengl.GL41;
import org.lwjgl.system.APIBuffer;
import org.lwjgl.system.APIUtil;
import org.lwjgl.system.Checks;
import org.lwjgl.system.FunctionProvider;
import org.lwjgl.system.MemoryUtil;

public final class ARBES2Compatibility {
    public static final int GL_SHADER_COMPILER = 36346;
    public static final int GL_SHADER_BINARY_FORMATS = 36344;
    public static final int GL_NUM_SHADER_BINARY_FORMATS = 36345;
    public static final int GL_MAX_VERTEX_UNIFORM_VECTORS = 36347;
    public static final int GL_MAX_VARYING_VECTORS = 36348;
    public static final int GL_MAX_FRAGMENT_UNIFORM_VECTORS = 36349;
    public static final int GL_IMPLEMENTATION_COLOR_READ_TYPE = 35738;
    public static final int GL_IMPLEMENTATION_COLOR_READ_FORMAT = 35739;
    public static final int GL_FIXED = 5132;
    public static final int GL_LOW_FLOAT = 36336;
    public static final int GL_MEDIUM_FLOAT = 36337;
    public static final int GL_HIGH_FLOAT = 36338;
    public static final int GL_LOW_INT = 36339;
    public static final int GL_MEDIUM_INT = 36340;
    public static final int GL_HIGH_INT = 36341;
    public static final int GL_RGB565 = 36194;
    public final long ReleaseShaderCompiler;
    public final long ShaderBinary;
    public final long GetShaderPrecisionFormat;
    public final long DepthRangef;
    public final long ClearDepthf;

    public ARBES2Compatibility(FunctionProvider provider) {
        this.ReleaseShaderCompiler = provider.getFunctionAddress("glReleaseShaderCompiler");
        this.ShaderBinary = provider.getFunctionAddress("glShaderBinary");
        this.GetShaderPrecisionFormat = provider.getFunctionAddress("glGetShaderPrecisionFormat");
        this.DepthRangef = provider.getFunctionAddress("glDepthRangef");
        this.ClearDepthf = provider.getFunctionAddress("glClearDepthf");
    }

    public static ARBES2Compatibility getInstance() {
        return GL.getCapabilities().__ARBES2Compatibility;
    }

    static ARBES2Compatibility create(Set<String> ext, FunctionProvider provider) {
        if (!ext.contains("GL_ARB_ES2_compatibility")) {
            return null;
        }
        ARBES2Compatibility funcs = new ARBES2Compatibility(provider);
        boolean supported = Checks.checkFunctions(funcs.ReleaseShaderCompiler, funcs.ShaderBinary, funcs.GetShaderPrecisionFormat, funcs.DepthRangef, funcs.ClearDepthf);
        return GL.checkExtension("GL_ARB_ES2_compatibility", funcs, supported);
    }

    public static void glReleaseShaderCompiler() {
        long __functionAddress = ARBES2Compatibility.getInstance().ReleaseShaderCompiler;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        GL41.nglReleaseShaderCompiler(__functionAddress);
    }

    public static void nglShaderBinary(int count, long shaders, int binaryformat, long binary, int length) {
        long __functionAddress = ARBES2Compatibility.getInstance().ShaderBinary;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        GL41.nglShaderBinary(count, shaders, binaryformat, binary, length, __functionAddress);
    }

    public static void glShaderBinary(int count, ByteBuffer shaders, int binaryformat, ByteBuffer binary, int length) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkBuffer((Buffer)shaders, count << 2);
            Checks.checkBuffer((Buffer)binary, length);
        }
        ARBES2Compatibility.nglShaderBinary(count, MemoryUtil.memAddress(shaders), binaryformat, MemoryUtil.memAddress(binary), length);
    }

    public static void glShaderBinary(IntBuffer shaders, int binaryformat, ByteBuffer binary) {
        ARBES2Compatibility.nglShaderBinary(shaders.remaining(), MemoryUtil.memAddress(shaders), binaryformat, MemoryUtil.memAddress(binary), binary.remaining());
    }

    public static void nglGetShaderPrecisionFormat(int shadertype, int precisiontype, long range, long precision) {
        long __functionAddress = ARBES2Compatibility.getInstance().GetShaderPrecisionFormat;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        GL41.nglGetShaderPrecisionFormat(shadertype, precisiontype, range, precision, __functionAddress);
    }

    public static void glGetShaderPrecisionFormat(int shadertype, int precisiontype, ByteBuffer range, ByteBuffer precision) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkBuffer((Buffer)range, 8);
            Checks.checkBuffer((Buffer)precision, 4);
        }
        ARBES2Compatibility.nglGetShaderPrecisionFormat(shadertype, precisiontype, MemoryUtil.memAddress(range), MemoryUtil.memAddress(precision));
    }

    public static void glGetShaderPrecisionFormat(int shadertype, int precisiontype, IntBuffer range, IntBuffer precision) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkBuffer((Buffer)range, 2);
            Checks.checkBuffer((Buffer)precision, 1);
        }
        ARBES2Compatibility.nglGetShaderPrecisionFormat(shadertype, precisiontype, MemoryUtil.memAddress(range), MemoryUtil.memAddress(precision));
    }

    public static int glGetShaderPrecisionFormat(int shadertype, int precisiontype, IntBuffer range) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkBuffer((Buffer)range, 2);
        }
        APIBuffer __buffer = APIUtil.apiBuffer();
        int precision = __buffer.intParam();
        ARBES2Compatibility.nglGetShaderPrecisionFormat(shadertype, precisiontype, MemoryUtil.memAddress(range), __buffer.address(precision));
        return __buffer.intValue(precision);
    }

    public static void glDepthRangef(float zNear, float zFar) {
        long __functionAddress = ARBES2Compatibility.getInstance().DepthRangef;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        GL41.nglDepthRangef(zNear, zFar, __functionAddress);
    }

    public static void glClearDepthf(float depth) {
        long __functionAddress = ARBES2Compatibility.getInstance().ClearDepthf;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        GL41.nglClearDepthf(depth, __functionAddress);
    }
}

