/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.openal;

import java.util.Set;
import org.lwjgl.LWJGLUtil;
import org.lwjgl.openal.ALC;
import org.lwjgl.system.Checks;
import org.lwjgl.system.FunctionProviderLocal;

public final class EXTThreadLocalContext {
    public final long SetThreadContext;
    public final long GetThreadContext;

    public EXTThreadLocalContext(FunctionProviderLocal provider, long device) {
        this.SetThreadContext = provider.getFunctionAddress(device, "alcSetThreadContext");
        this.GetThreadContext = provider.getFunctionAddress(device, "alcGetThreadContext");
    }

    public static EXTThreadLocalContext getInstance() {
        return ALC.getCapabilities().__EXTThreadLocalContext;
    }

    static EXTThreadLocalContext create(Set<String> ext, FunctionProviderLocal provider, long device) {
        if (!ext.contains("ALC_EXT_thread_local_context")) {
            return null;
        }
        EXTThreadLocalContext funcs = new EXTThreadLocalContext(provider, device);
        boolean supported = Checks.checkFunctions(funcs.SetThreadContext, funcs.GetThreadContext);
        return ALC.checkExtension("ALC_EXT_thread_local_context", funcs, supported);
    }

    public static native boolean nalcSetThreadContext(long var0, long var2);

    public static boolean alcSetThreadContext(long context) {
        long __functionAddress = EXTThreadLocalContext.getInstance().SetThreadContext;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
            Checks.checkPointer(context);
        }
        return EXTThreadLocalContext.nalcSetThreadContext(context, __functionAddress);
    }

    public static native long nalcGetThreadContext(long var0);

    public static long alcGetThreadContext() {
        long __functionAddress = EXTThreadLocalContext.getInstance().GetThreadContext;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        return EXTThreadLocalContext.nalcGetThreadContext(__functionAddress);
    }
}

