/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.openal;

import java.nio.ByteBuffer;
import org.lwjgl.LWJGLUtil;
import org.lwjgl.openal.ALC;
import org.lwjgl.openal.ALC10;
import org.lwjgl.openal.ALCCapabilities;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.PointerWrapper;

public class ALDevice
extends PointerWrapper {
    static ALDevice lastDevice;
    private final ALCCapabilities capabilities;

    public ALDevice(long device) {
        super(device);
        this.capabilities = ALC.createCapabilities(device);
        lastDevice = this;
    }

    public static ALDevice getLastDevice() {
        return lastDevice;
    }

    public ALCCapabilities getCapabilities() {
        return this.capabilities;
    }

    public void destroy() {
        ALC10.alcCloseDevice(this.getPointer());
        if (lastDevice == this) {
            lastDevice = null;
        }
    }

    public static ALDevice create() {
        return ALDevice.create(null);
    }

    public static ALDevice create(String deviceName) {
        ByteBuffer nameBuffer;
        long device;
        long alcOpenDevice = ALC.getFunctionProvider().getFunctionAddress("alcOpenDevice");
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(alcOpenDevice);
        }
        if ((device = ALC10.nalcOpenDevice(MemoryUtil.memAddressSafe(nameBuffer = deviceName == null ? null : MemoryUtil.memEncodeUTF8(deviceName)), alcOpenDevice)) == 0L) {
            throw new RuntimeException("Failed to open the device.");
        }
        return new ALDevice(device);
    }
}

