/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.openal;

import java.nio.IntBuffer;
import org.lwjgl.BufferUtils;
import org.lwjgl.openal.AL;
import org.lwjgl.openal.ALC10;
import org.lwjgl.openal.ALCapabilities;
import org.lwjgl.openal.ALDevice;
import org.lwjgl.openal.EXTThreadLocalContext;
import org.lwjgl.system.PointerWrapper;

public class ALContext
extends PointerWrapper {
    private final ALDevice device;
    private final ALCapabilities capabilities;

    public ALContext(ALDevice device, long handle) {
        super(handle);
        this.device = device;
        this.makeCurrent();
        if (device.getPointer() != ALC10.alcGetContextsDevice(handle)) {
            throw new IllegalArgumentException("The specified device does not match with the context device.");
        }
        this.capabilities = AL.createCapabilities(device.getPointer());
    }

    public ALDevice getDevice() {
        return this.device;
    }

    public ALCapabilities getCapabilities() {
        return this.capabilities;
    }

    public void makeCurrent() {
        if (!ALC10.alcMakeContextCurrent(this.getPointer())) {
            throw new RuntimeException("Failed to make AL context current in process.");
        }
        AL.setCurrentProcess(this);
    }

    public void makeCurrentThread() {
        if (!EXTThreadLocalContext.alcSetThreadContext(this.getPointer())) {
            throw new RuntimeException("Failed to make AL context current in thread.");
        }
        AL.setCurrentThread(this);
    }

    public boolean isCurrent() {
        if (this.device.getCapabilities().ALC_EXT_thread_local_context && EXTThreadLocalContext.alcGetThreadContext() == this.getPointer()) {
            return true;
        }
        return ALC10.alcGetCurrentContext() == this.getPointer();
    }

    public void destroy() {
        if (this.isCurrent()) {
            ALC10.alcMakeContextCurrent(0L);
        }
        ALC10.alcDestroyContext(this.getPointer());
    }

    public static ALContext create() {
        return ALContext.create(null, 44100, 60, false);
    }

    public static ALContext create(String deviceName, int frequency, int refresh, boolean sync) {
        ALDevice device = ALDevice.create(deviceName);
        IntBuffer attribs = BufferUtils.createIntBuffer(16);
        attribs.put(4103);
        attribs.put(frequency);
        attribs.put(4104);
        attribs.put(refresh);
        attribs.put(4105);
        attribs.put(sync ? 1 : 0);
        attribs.put(0);
        attribs.flip();
        long contextHandle = ALC10.alcCreateContext(device.getPointer(), attribs);
        return new ALContext(device, contextHandle);
    }
}

