/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.openal;

import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import java.util.Set;
import org.lwjgl.LWJGLUtil;
import org.lwjgl.openal.ALC;
import org.lwjgl.system.APIBuffer;
import org.lwjgl.system.APIUtil;
import org.lwjgl.system.Checks;
import org.lwjgl.system.FunctionProviderLocal;
import org.lwjgl.system.MemoryUtil;

public final class ALC10 {
    public static final int ALC_INVALID = -1;
    public static final int ALC_FALSE = 0;
    public static final int ALC_TRUE = 1;
    public static final int ALC_FREQUENCY = 4103;
    public static final int ALC_REFRESH = 4104;
    public static final int ALC_SYNC = 4105;
    public static final int ALC_NO_ERROR = 0;
    public static final int ALC_INVALID_DEVICE = 40961;
    public static final int ALC_INVALID_CONTEXT = 40962;
    public static final int ALC_INVALID_ENUM = 40963;
    public static final int ALC_INVALID_VALUE = 40964;
    public static final int ALC_OUT_OF_MEMORY = 40965;
    public static final int ALC_DEFAULT_DEVICE_SPECIFIER = 4100;
    public static final int ALC_DEVICE_SPECIFIER = 4101;
    public static final int ALC_EXTENSIONS = 4102;
    public static final int ALC_MAJOR_VERSION = 4096;
    public static final int ALC_MINOR_VERSION = 4097;
    public static final int ALC_ATTRIBUTES_SIZE = 4098;
    public static final int ALC_ALL_ATTRIBUTES = 4099;
    public final long OpenDevice;
    public final long CloseDevice;
    public final long CreateContext;
    public final long MakeContextCurrent;
    public final long ProcessContext;
    public final long SuspendContext;
    public final long DestroyContext;
    public final long GetCurrentContext;
    public final long GetContextsDevice;
    public final long IsExtensionPresent;
    public final long GetProcAddress;
    public final long GetEnumValue;
    public final long GetError;
    public final long GetString;
    public final long GetIntegerv;

    public ALC10(FunctionProviderLocal provider) {
        this.OpenDevice = provider.getFunctionAddress("alcOpenDevice");
        this.CloseDevice = provider.getFunctionAddress("alcCloseDevice");
        this.CreateContext = provider.getFunctionAddress("alcCreateContext");
        this.MakeContextCurrent = provider.getFunctionAddress("alcMakeContextCurrent");
        this.ProcessContext = provider.getFunctionAddress("alcProcessContext");
        this.SuspendContext = provider.getFunctionAddress("alcSuspendContext");
        this.DestroyContext = provider.getFunctionAddress("alcDestroyContext");
        this.GetCurrentContext = provider.getFunctionAddress("alcGetCurrentContext");
        this.GetContextsDevice = provider.getFunctionAddress("alcGetContextsDevice");
        this.IsExtensionPresent = provider.getFunctionAddress("alcIsExtensionPresent");
        this.GetProcAddress = provider.getFunctionAddress("alcGetProcAddress");
        this.GetEnumValue = provider.getFunctionAddress("alcGetEnumValue");
        this.GetError = provider.getFunctionAddress("alcGetError");
        this.GetString = provider.getFunctionAddress("alcGetString");
        this.GetIntegerv = provider.getFunctionAddress("alcGetIntegerv");
    }

    public static ALC10 getInstance() {
        return ALC.getCapabilities().__ALC10;
    }

    static ALC10 create(Set<String> ext, FunctionProviderLocal provider) {
        if (!ext.contains("OpenALC10")) {
            return null;
        }
        ALC10 funcs = new ALC10(provider);
        boolean supported = Checks.checkFunctions(funcs.OpenDevice, funcs.CloseDevice, funcs.CreateContext, funcs.MakeContextCurrent, funcs.ProcessContext, funcs.SuspendContext, funcs.DestroyContext, funcs.GetCurrentContext, funcs.GetContextsDevice, funcs.IsExtensionPresent, funcs.GetProcAddress, funcs.GetEnumValue, funcs.GetError, funcs.GetString, funcs.GetIntegerv);
        return ALC.checkExtension("OpenALC10", funcs, supported);
    }

    public static native long nalcOpenDevice(long var0, long var2);

    public static long nalcOpenDevice(long deviceSpecifier) {
        long __functionAddress = ALC10.getInstance().OpenDevice;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        return ALC10.nalcOpenDevice(deviceSpecifier, __functionAddress);
    }

    public static long alcOpenDevice(ByteBuffer deviceSpecifier) {
        if (LWJGLUtil.CHECKS && deviceSpecifier != null) {
            Checks.checkNT1(deviceSpecifier);
        }
        return ALC10.nalcOpenDevice(MemoryUtil.memAddressSafe(deviceSpecifier));
    }

    public static long alcOpenDevice(CharSequence deviceSpecifier) {
        APIBuffer __buffer = APIUtil.apiBuffer();
        int deviceSpecifierEncoded = __buffer.stringParamUTF8(deviceSpecifier, true);
        return ALC10.nalcOpenDevice(__buffer.addressSafe(deviceSpecifier, deviceSpecifierEncoded));
    }

    public static native boolean nalcCloseDevice(long var0, long var2);

    public static boolean alcCloseDevice(long deviceHandle) {
        long __functionAddress = ALC10.getInstance().CloseDevice;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
            Checks.checkPointer(deviceHandle);
        }
        return ALC10.nalcCloseDevice(deviceHandle, __functionAddress);
    }

    public static native long nalcCreateContext(long var0, long var2, long var4);

    public static long nalcCreateContext(long deviceHandle, long attrList) {
        long __functionAddress = ALC10.getInstance().CreateContext;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
            Checks.checkPointer(deviceHandle);
        }
        return ALC10.nalcCreateContext(deviceHandle, attrList, __functionAddress);
    }

    public static long alcCreateContext(long deviceHandle, ByteBuffer attrList) {
        if (LWJGLUtil.CHECKS && attrList != null) {
            Checks.checkNT4(attrList);
        }
        return ALC10.nalcCreateContext(deviceHandle, MemoryUtil.memAddressSafe(attrList));
    }

    public static long alcCreateContext(long deviceHandle, IntBuffer attrList) {
        if (LWJGLUtil.CHECKS && attrList != null) {
            Checks.checkNT(attrList);
        }
        return ALC10.nalcCreateContext(deviceHandle, MemoryUtil.memAddressSafe(attrList));
    }

    public static native boolean nalcMakeContextCurrent(long var0, long var2);

    public static boolean alcMakeContextCurrent(long context) {
        long __functionAddress = ALC10.getInstance().MakeContextCurrent;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        return ALC10.nalcMakeContextCurrent(context, __functionAddress);
    }

    public static native void nalcProcessContext(long var0, long var2);

    public static void alcProcessContext(long context) {
        long __functionAddress = ALC10.getInstance().ProcessContext;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
            Checks.checkPointer(context);
        }
        ALC10.nalcProcessContext(context, __functionAddress);
    }

    public static native void nalcSuspendContext(long var0, long var2);

    public static void alcSuspendContext(long context) {
        long __functionAddress = ALC10.getInstance().SuspendContext;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
            Checks.checkPointer(context);
        }
        ALC10.nalcSuspendContext(context, __functionAddress);
    }

    public static native void nalcDestroyContext(long var0, long var2);

    public static void alcDestroyContext(long context) {
        long __functionAddress = ALC10.getInstance().DestroyContext;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
            Checks.checkPointer(context);
        }
        ALC10.nalcDestroyContext(context, __functionAddress);
    }

    public static native long nalcGetCurrentContext(long var0);

    public static long alcGetCurrentContext() {
        long __functionAddress = ALC10.getInstance().GetCurrentContext;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        return ALC10.nalcGetCurrentContext(__functionAddress);
    }

    public static native long nalcGetContextsDevice(long var0, long var2);

    public static long alcGetContextsDevice(long context) {
        long __functionAddress = ALC10.getInstance().GetContextsDevice;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
            Checks.checkPointer(context);
        }
        return ALC10.nalcGetContextsDevice(context, __functionAddress);
    }

    public static native boolean nalcIsExtensionPresent(long var0, long var2, long var4);

    public static boolean nalcIsExtensionPresent(long deviceHandle, long extName) {
        long __functionAddress = ALC10.getInstance().IsExtensionPresent;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        return ALC10.nalcIsExtensionPresent(deviceHandle, extName, __functionAddress);
    }

    public static boolean alcIsExtensionPresent(long deviceHandle, ByteBuffer extName) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkNT1(extName);
        }
        return ALC10.nalcIsExtensionPresent(deviceHandle, MemoryUtil.memAddress(extName));
    }

    public static boolean alcIsExtensionPresent(long deviceHandle, CharSequence extName) {
        APIBuffer __buffer = APIUtil.apiBuffer();
        int extNameEncoded = __buffer.stringParamASCII(extName, true);
        return ALC10.nalcIsExtensionPresent(deviceHandle, __buffer.address(extNameEncoded));
    }

    public static native long nalcGetProcAddress(long var0, long var2, long var4);

    public static long nalcGetProcAddress(long deviceHandle, long funcName) {
        long __functionAddress = ALC10.getInstance().GetProcAddress;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        return ALC10.nalcGetProcAddress(deviceHandle, funcName, __functionAddress);
    }

    public static long alcGetProcAddress(long deviceHandle, ByteBuffer funcName) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkNT1(funcName);
        }
        return ALC10.nalcGetProcAddress(deviceHandle, MemoryUtil.memAddress(funcName));
    }

    public static long alcGetProcAddress(long deviceHandle, CharSequence funcName) {
        APIBuffer __buffer = APIUtil.apiBuffer();
        int funcNameEncoded = __buffer.stringParamASCII(funcName, true);
        return ALC10.nalcGetProcAddress(deviceHandle, __buffer.address(funcNameEncoded));
    }

    public static native int nalcGetEnumValue(long var0, long var2, long var4);

    public static int nalcGetEnumValue(long deviceHandle, long enumName) {
        long __functionAddress = ALC10.getInstance().GetEnumValue;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        return ALC10.nalcGetEnumValue(deviceHandle, enumName, __functionAddress);
    }

    public static int alcGetEnumValue(long deviceHandle, ByteBuffer enumName) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkNT1(enumName);
        }
        return ALC10.nalcGetEnumValue(deviceHandle, MemoryUtil.memAddress(enumName));
    }

    public static int alcGetEnumValue(long deviceHandle, CharSequence enumName) {
        APIBuffer __buffer = APIUtil.apiBuffer();
        int enumNameEncoded = __buffer.stringParamASCII(enumName, true);
        return ALC10.nalcGetEnumValue(deviceHandle, __buffer.address(enumNameEncoded));
    }

    public static native int nalcGetError(long var0, long var2);

    public static int alcGetError(long deviceHandle) {
        long __functionAddress = ALC10.getInstance().GetError;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
            Checks.checkPointer(deviceHandle);
        }
        return ALC10.nalcGetError(deviceHandle, __functionAddress);
    }

    public static native long nalcGetString(long var0, int var2, long var3);

    public static long nalcGetString(long deviceHandle, int token) {
        long __functionAddress = ALC10.getInstance().GetString;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        return ALC10.nalcGetString(deviceHandle, token, __functionAddress);
    }

    public static String alcGetString(long deviceHandle, int token) {
        long __result = ALC10.nalcGetString(deviceHandle, token);
        return MemoryUtil.memDecodeUTF8(__result);
    }

    public static native void nalcGetIntegerv(long var0, int var2, int var3, long var4, long var6);

    public static void nalcGetIntegerv(long deviceHandle, int token, int size, long dest) {
        long __functionAddress = ALC10.getInstance().GetIntegerv;
        if (LWJGLUtil.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        ALC10.nalcGetIntegerv(deviceHandle, token, size, dest, __functionAddress);
    }

    public static void alcGetIntegerv(long deviceHandle, int token, int size, ByteBuffer dest) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkBuffer((Buffer)dest, size << 2);
        }
        ALC10.nalcGetIntegerv(deviceHandle, token, size, MemoryUtil.memAddress(dest));
    }

    public static void alcGetIntegerv(long deviceHandle, int token, IntBuffer dest) {
        ALC10.nalcGetIntegerv(deviceHandle, token, dest.remaining(), MemoryUtil.memAddress(dest));
    }

    public static int alcGetInteger(long deviceHandle, int token) {
        APIBuffer __buffer = APIUtil.apiBuffer();
        int dest = __buffer.intParam();
        ALC10.nalcGetIntegerv(deviceHandle, token, 1, __buffer.address(dest));
        return __buffer.intValue(dest);
    }
}

