/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl;

import java.nio.BufferOverflowException;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.DoubleBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.nio.LongBuffer;
import java.nio.ShortBuffer;
import org.lwjgl.BufferUtils;
import org.lwjgl.LWJGLUtil;
import org.lwjgl.Pointer;
import org.lwjgl.system.MemoryUtil;

public class PointerBuffer
implements Comparable<PointerBuffer> {
    protected final ByteBuffer buffer;

    public PointerBuffer(int capacity) {
        this(BufferUtils.createByteBuffer(capacity * Pointer.POINTER_SIZE), false);
    }

    public PointerBuffer(long address, int capacity) {
        this(MemoryUtil.memByteBuffer(address, capacity * Pointer.POINTER_SIZE), false);
    }

    public PointerBuffer(ByteBuffer source) {
        this(PointerBuffer.checkSource(source).slice().order(source.order()), false);
    }

    private PointerBuffer(ByteBuffer source, boolean dummy) {
        this.buffer = source;
    }

    private static ByteBuffer checkSource(ByteBuffer source) {
        if (!LWJGLUtil.CHECKS) {
            return source;
        }
        if (!source.isDirect()) {
            throw new IllegalArgumentException("The source buffer is not direct.");
        }
        int mask = Pointer.POINTER_SIZE - 1;
        if ((MemoryUtil.memAddress(source) & (long)mask) != 0L || (source.remaining() & mask) != 0) {
            throw new IllegalArgumentException("The source buffer is not aligned to " + Pointer.POINTER_SIZE + " bytes.");
        }
        return source;
    }

    public ByteBuffer getBuffer() {
        return this.buffer;
    }

    public final int capacity() {
        return this.buffer.capacity() >> Pointer.POINTER_SHIFT;
    }

    public final int position() {
        return this.buffer.position() >> Pointer.POINTER_SHIFT;
    }

    public final int positionByte() {
        return this.buffer.position();
    }

    public final PointerBuffer position(int newPosition) {
        this.buffer.position(newPosition << Pointer.POINTER_SHIFT);
        return this;
    }

    public final int limit() {
        return this.buffer.limit() >> Pointer.POINTER_SHIFT;
    }

    public final PointerBuffer limit(int newLimit) {
        this.buffer.limit(newLimit << Pointer.POINTER_SHIFT);
        return this;
    }

    public final PointerBuffer mark() {
        this.buffer.mark();
        return this;
    }

    public final PointerBuffer reset() {
        this.buffer.reset();
        return this;
    }

    public final PointerBuffer clear() {
        this.buffer.clear();
        return this;
    }

    public final PointerBuffer flip() {
        this.buffer.flip();
        return this;
    }

    public final PointerBuffer rewind() {
        this.buffer.rewind();
        return this;
    }

    public final int remaining() {
        return this.buffer.remaining() >> Pointer.POINTER_SHIFT;
    }

    public final int remainingByte() {
        return this.buffer.remaining();
    }

    public final boolean hasRemaining() {
        return this.buffer.hasRemaining();
    }

    public static PointerBuffer allocateDirect(int capacity) {
        return new PointerBuffer(capacity);
    }

    protected static PointerBuffer newInstance(ByteBuffer source) {
        return new PointerBuffer(source, false);
    }

    public PointerBuffer slice() {
        return PointerBuffer.newInstance(this.buffer.slice().order(this.buffer.order()));
    }

    public PointerBuffer duplicate() {
        return PointerBuffer.newInstance(this.buffer.duplicate().order(this.buffer.order()));
    }

    public PointerBuffer asReadOnlyBuffer() {
        return PointerBuffer.newInstance(this.buffer.asReadOnlyBuffer().order(this.buffer.order()));
    }

    public boolean isReadOnly() {
        return this.buffer.isReadOnly();
    }

    public long get() {
        return Pointer.BITS64 ? this.buffer.getLong() : (long)this.buffer.getInt() & 0xFFFFFFFFL;
    }

    public PointerBuffer put(long l) {
        PointerBuffer.put(this.buffer, l);
        return this;
    }

    public static void put(ByteBuffer target, long l) {
        if (Pointer.BITS64) {
            target.putLong(l);
        } else {
            target.putInt((int)l);
        }
    }

    public long get(int index) {
        return PointerBuffer.get(this.buffer, index << Pointer.POINTER_SHIFT);
    }

    public static long get(ByteBuffer target, int index) {
        return Pointer.BITS64 ? target.getLong(index) : (long)target.getInt(index) & 0xFFFFFFFFL;
    }

    public PointerBuffer put(int index, long l) {
        PointerBuffer.put(this.buffer, index << Pointer.POINTER_SHIFT, l);
        return this;
    }

    public static void put(ByteBuffer target, int index, long l) {
        if (Pointer.BITS64) {
            target.putLong(index, l);
        } else {
            target.putInt(index, (int)l);
        }
    }

    public PointerBuffer put(Pointer wrapper) {
        this.put(wrapper.getPointer());
        return this;
    }

    public PointerBuffer put(int index, Pointer wrapper) {
        this.put(index, wrapper.getPointer());
        return this;
    }

    public PointerBuffer put(ByteBuffer buffer) {
        this.put(MemoryUtil.memAddress(buffer));
        return this;
    }

    public PointerBuffer put(ShortBuffer buffer) {
        this.put(MemoryUtil.memAddress(buffer));
        return this;
    }

    public PointerBuffer put(IntBuffer buffer) {
        this.put(MemoryUtil.memAddress(buffer));
        return this;
    }

    public PointerBuffer put(LongBuffer buffer) {
        this.put(MemoryUtil.memAddress(buffer));
        return this;
    }

    public PointerBuffer put(FloatBuffer buffer) {
        this.put(MemoryUtil.memAddress(buffer));
        return this;
    }

    public PointerBuffer put(DoubleBuffer buffer) {
        this.put(MemoryUtil.memAddress(buffer));
        return this;
    }

    public PointerBuffer putAddressOf(PointerBuffer buffer) {
        this.put(MemoryUtil.memAddress(buffer));
        return this;
    }

    public void put(int index, ByteBuffer buffer) {
        this.put(index, MemoryUtil.memAddress(buffer));
    }

    public void put(int index, ShortBuffer buffer) {
        this.put(index, MemoryUtil.memAddress(buffer));
    }

    public void put(int index, IntBuffer buffer) {
        this.put(index, MemoryUtil.memAddress(buffer));
    }

    public void put(int index, LongBuffer buffer) {
        this.put(index, MemoryUtil.memAddress(buffer));
    }

    public void put(int index, FloatBuffer buffer) {
        this.put(index, MemoryUtil.memAddress(buffer));
    }

    public void put(int index, DoubleBuffer buffer) {
        this.put(index, MemoryUtil.memAddress(buffer));
    }

    public void putAddressOf(int index, PointerBuffer buffer) {
        this.put(index, MemoryUtil.memAddress(buffer));
    }

    public ByteBuffer getByteBuffer(int size) {
        return MemoryUtil.memByteBuffer(this.get(), size);
    }

    public ShortBuffer getShortBuffer(int size) {
        return MemoryUtil.memShortBuffer(this.get(), size);
    }

    public IntBuffer getIntBuffer(int size) {
        return MemoryUtil.memIntBuffer(this.get(), size);
    }

    public LongBuffer getLongBuffer(int size) {
        return MemoryUtil.memLongBuffer(this.get(), size);
    }

    public FloatBuffer getFloatBuffer(int size) {
        return MemoryUtil.memFloatBuffer(this.get(), size);
    }

    public DoubleBuffer getDoubleBuffer(int size) {
        return MemoryUtil.memDoubleBuffer(this.get(), size);
    }

    public PointerBuffer getPointerBuffer(int size) {
        return MemoryUtil.memPointerBuffer(this.get(), size);
    }

    public ByteBuffer getByteBuffer(int index, int size) {
        return MemoryUtil.memByteBuffer(this.get(index), size);
    }

    public ShortBuffer getShortBuffer(int index, int size) {
        return MemoryUtil.memShortBuffer(this.get(index), size);
    }

    public IntBuffer getIntBuffer(int index, int size) {
        return MemoryUtil.memIntBuffer(this.get(index), size);
    }

    public LongBuffer getLongBuffer(int index, int size) {
        return MemoryUtil.memLongBuffer(this.get(index), size);
    }

    public FloatBuffer getFloatBuffer(int index, int size) {
        return MemoryUtil.memFloatBuffer(this.get(index), size);
    }

    public DoubleBuffer getDoubleBuffer(int index, int size) {
        return MemoryUtil.memDoubleBuffer(this.get(index), size);
    }

    public PointerBuffer getPointerBuffer(int index, int size) {
        return MemoryUtil.memPointerBuffer(this.get(index), size);
    }

    public PointerBuffer get(long[] dst, int offset, int length) {
        PointerBuffer.checkBounds(offset, length, dst.length);
        if (length > this.remaining()) {
            throw new BufferUnderflowException();
        }
        int end = offset + length;
        for (int i = offset; i < end; ++i) {
            dst[i] = this.get();
        }
        return this;
    }

    public PointerBuffer get(long[] dst) {
        return this.get(dst, 0, dst.length);
    }

    public PointerBuffer put(PointerBuffer src) {
        this.buffer.put(src.buffer);
        return this;
    }

    public PointerBuffer put(long[] src, int offset, int length) {
        PointerBuffer.checkBounds(offset, length, src.length);
        if (length > this.remaining()) {
            throw new BufferOverflowException();
        }
        int end = offset + length;
        for (int i = offset; i < end; ++i) {
            this.put(src[i]);
        }
        return this;
    }

    public final PointerBuffer put(long[] src) {
        return this.put(src, 0, src.length);
    }

    public PointerBuffer compact() {
        this.buffer.compact();
        return this;
    }

    public ByteOrder order() {
        return this.buffer.order();
    }

    public String toString() {
        return this.getClass().getName() + "[pos=" + this.position() + " lim=" + this.limit() + " cap=" + this.capacity() + "]";
    }

    public int hashCode() {
        int h = 1;
        int p = this.position();
        for (int i = this.limit() - 1; i >= p; --i) {
            h = 31 * h + (int)this.get(i);
        }
        return h;
    }

    public boolean equals(Object ob) {
        if (!(ob instanceof PointerBuffer)) {
            return false;
        }
        PointerBuffer that = (PointerBuffer)ob;
        if (this.remaining() != that.remaining()) {
            return false;
        }
        int p = this.position();
        int i = this.limit() - 1;
        int j = that.limit() - 1;
        while (i >= p) {
            long v2;
            long v1 = this.get(i);
            if (v1 != (v2 = that.get(j))) {
                return false;
            }
            --i;
            --j;
        }
        return true;
    }

    @Override
    public int compareTo(PointerBuffer that) {
        int n = this.position() + Math.min(this.remaining(), that.remaining());
        int i = this.position();
        int j = that.position();
        while (i < n) {
            long v2;
            long v1 = this.get(i);
            if (v1 != (v2 = that.get(j))) {
                if (v1 < v2) {
                    return -1;
                }
                return 1;
            }
            ++i;
            ++j;
        }
        return this.remaining() - that.remaining();
    }

    private static void checkBounds(int off, int len, int size) {
        if ((off | len | off + len | size - (off + len)) < 0) {
            throw new IndexOutOfBoundsException();
        }
    }
}

