/*
 * Decompiled with CFR 0.152.
 */
import java.awt.image.BufferedImage;
import java.io.InputStream;
import java.nio.IntBuffer;
import javax.imageio.ImageIO;
import org.lwjgl.BufferUtils;
import org.lwjgl.opengl.GL11;
import org.lwjgl.opengl.GL13;
import org.lwjgl.opengl.GL30;

public class Texture {
    public int width;
    public int height;
    public int textureID;

    public Texture(String path) {
        this.textureID = this.load(path);
    }

    public Texture(BufferedImage img) {
        this.textureID = this.createTexture(img);
    }

    public static Texture getTexture(String path) {
        return new Texture(path);
    }

    private int load(String path) {
        int[] pixels = null;
        try {
            InputStream in = Texture.class.getResourceAsStream("/" + path);
            BufferedImage image = ImageIO.read(in);
            this.width = image.getWidth();
            this.height = image.getHeight();
            pixels = new int[this.width * this.height];
            image.getRGB(0, 0, this.width, this.height, pixels, 0, this.width);
        }
        catch (Exception e) {
            System.out.println("fel med textur: " + path);
            e.printStackTrace();
        }
        int[] data = new int[this.width * this.height];
        int i = 0;
        while (i < this.width * this.height) {
            int a = (pixels[i] & 0xFF000000) >> 24;
            int r = (pixels[i] & 0xFF0000) >> 16;
            int g = (pixels[i] & 0xFF00) >> 8;
            int b = pixels[i] & 0xFF;
            data[i] = a << 24 | b << 16 | g << 8 | r;
            ++i;
        }
        int result = GL11.glGenTextures();
        GL13.glActiveTexture(33984);
        GL11.glBindTexture(3553, result);
        IntBuffer buf = BufferUtils.createIntBuffer(data.length);
        buf.put(data).rewind();
        GL11.glTexImage2D(3553, 0, 6408, this.width, this.height, 0, 6408, 5121, buf);
        GL30.glGenerateMipmap(3553);
        GL11.glTexParameteri(3553, 10242, 10497);
        GL11.glTexParameteri(3553, 10243, 10497);
        GL11.glTexParameteri(3553, 10240, 9729);
        GL11.glTexParameteri(3553, 10241, 9729);
        GL11.glBindTexture(3553, 0);
        return result;
    }

    public void bind() {
        GL11.glBindTexture(3553, this.textureID);
    }

    public void unbind() {
        GL11.glBindTexture(3553, 0);
    }

    public void free() {
        GL11.glDeleteTextures(this.textureID);
    }

    public int createTexture(BufferedImage image) {
        int[] pixels = null;
        this.width = image.getWidth();
        this.height = image.getHeight();
        pixels = new int[this.width * this.height];
        image.getRGB(0, 0, this.width, this.height, pixels, 0, this.width);
        int[] data = new int[this.width * this.height];
        int i = 0;
        while (i < this.width * this.height) {
            int a = (pixels[i] & 0xFF000000) >> 24;
            int r = (pixels[i] & 0xFF0000) >> 16;
            int g = (pixels[i] & 0xFF00) >> 8;
            int b = pixels[i] & 0xFF;
            data[i] = a << 24 | b << 16 | g << 8 | r;
            ++i;
        }
        int result = GL11.glGenTextures();
        GL13.glActiveTexture(33984);
        GL11.glBindTexture(3553, result);
        IntBuffer buf = BufferUtils.createIntBuffer(data.length);
        buf.put(data).rewind();
        GL11.glTexImage2D(3553, 0, 6408, this.width, this.height, 0, 6408, 5121, buf);
        GL30.glGenerateMipmap(3553);
        GL11.glTexParameteri(3553, 10242, 10497);
        GL11.glTexParameteri(3553, 10243, 10497);
        GL11.glTexParameteri(3553, 10240, 9729);
        GL11.glTexParameteri(3553, 10241, 9987);
        GL11.glBindTexture(3553, 0);
        return result;
    }
}

