/*
 * Decompiled with CFR 0.152.
 */
import java.nio.ByteBuffer;
import java.nio.FloatBuffer;
import org.lwjgl.BufferUtils;
import org.lwjgl.glfw.Callbacks;
import org.lwjgl.glfw.GLFW;
import org.lwjgl.glfw.GLFWErrorCallback;
import org.lwjgl.glfw.GLFWKeyCallback;
import org.lwjgl.glfw.GLFWvidmode;
import org.lwjgl.opengl.GL11;
import org.lwjgl.opengl.GL13;
import org.lwjgl.opengl.GL15;
import org.lwjgl.opengl.GL20;
import org.lwjgl.opengl.GL30;
import org.lwjgl.opengl.GLContext;

public class Raytracer {
    private GLFWErrorCallback errorCallback;
    private GLFWKeyCallback keyCallback;
    private long window;
    private int vertexCount;
    private int vaoId;
    private int vboId;
    private GLSLProgram shader;
    private GLSLProgram textureShader;
    private long tick;
    private Texture noise;
    private FBO fbo;
    private int windowWidth = 1920;
    private int windowHeight = 1080;
    private int fboWidth = this.windowWidth;
    private int fboHeight = this.windowHeight;
    private Settings settings;

    public Raytracer(Settings s) {
        this.settings = s;
        this.windowWidth = s.resolution.width;
        this.windowHeight = s.resolution.height;
        this.fboWidth = this.windowWidth;
        this.fboHeight = this.windowHeight;
    }

    public void run() {
        try {
            try {
                this.init();
                this.loop();
                GLFW.glfwDestroyWindow(this.window);
                this.keyCallback.release();
            }
            catch (Exception e) {
                e.printStackTrace();
                this.shader.free();
                this.textureShader.free();
                this.noise.free();
                this.fbo.free();
                GL15.glBindBuffer(34962, 0);
                GL15.glDeleteBuffers(this.vboId);
                GL30.glBindVertexArray(0);
                GL30.glDeleteVertexArrays(this.vaoId);
                GLFW.glfwTerminate();
                this.errorCallback.release();
            }
        }
        finally {
            this.shader.free();
            this.textureShader.free();
            this.noise.free();
            this.fbo.free();
            GL15.glBindBuffer(34962, 0);
            GL15.glDeleteBuffers(this.vboId);
            GL30.glBindVertexArray(0);
            GL30.glDeleteVertexArrays(this.vaoId);
            GLFW.glfwTerminate();
            this.errorCallback.release();
        }
    }

    private void init() {
        this.errorCallback = Callbacks.errorCallbackPrint(System.err);
        GLFW.glfwSetErrorCallback(this.errorCallback);
        if (GLFW.glfwInit() != 1) {
            throw new IllegalStateException("Unable to initialize GLFW");
        }
        GLFW.glfwDefaultWindowHints();
        GLFW.glfwWindowHint(131076, 0);
        GLFW.glfwWindowHint(131075, 1);
        this.window = GLFW.glfwCreateWindow(this.windowWidth, this.windowHeight, "Fibber 28", this.settings.fullscreen ? GLFW.glfwGetPrimaryMonitor() : 0L, 0L);
        if (this.window == 0L) {
            throw new RuntimeException("Failed to create the GLFW window");
        }
        this.keyCallback = new GLFWKeyCallback(){

            @Override
            public void invoke(long window, int key, int scancode, int action, int mods) {
                if (key == 256 && action == 0) {
                    GLFW.glfwSetWindowShouldClose(window, 1);
                }
            }
        };
        GLFW.glfwSetKeyCallback(this.window, this.keyCallback);
        if (this.settings.fullscreen) {
            GLFW.glfwSetInputMode(this.window, 208897, 212994);
        }
        ByteBuffer vidmode = GLFW.glfwGetVideoMode(GLFW.glfwGetPrimaryMonitor());
        if (!this.settings.fullscreen) {
            GLFW.glfwSetWindowPos(this.window, (GLFWvidmode.width(vidmode) - this.windowWidth) / 2, (GLFWvidmode.height(vidmode) - this.windowHeight) / 2);
        }
        GLFW.glfwMakeContextCurrent(this.window);
        GLFW.glfwSwapInterval(0);
        GLFW.glfwShowWindow(this.window);
        GLContext.createFromCurrent();
        System.out.println("Error: " + GL11.glGetError());
        this.setupQuad();
        this.shader = new GLSLProgram("shaders/vertex.vert", "shaders/fragment.frag");
        this.textureShader = new GLSLProgram("shaders/vertex.vert", "shaders/textureRender.frag");
        this.tick = 0L;
        this.noise = Texture.getTexture("noise.png");
        this.fbo = new FBO(this.fboWidth, this.fboHeight, true);
    }

    public void setupQuad() {
        float[] vertices = new float[]{-1.0f, 1.0f, 0.0f, -1.0f, -1.0f, 0.0f, 1.0f, -1.0f, 0.0f, 1.0f, -1.0f, 0.0f, 1.0f, 1.0f, 0.0f, -1.0f, 1.0f, 0.0f};
        FloatBuffer verticesBuffer = BufferUtils.createFloatBuffer(vertices.length);
        verticesBuffer.put(vertices);
        verticesBuffer.flip();
        this.vertexCount = 6;
        this.vaoId = GL30.glGenVertexArrays();
        GL30.glBindVertexArray(this.vaoId);
        GL20.glEnableVertexAttribArray(0);
        this.vboId = GL15.glGenBuffers();
        GL15.glBindBuffer(34962, this.vboId);
        GL15.glBufferData(34962, verticesBuffer, 35044);
        GL20.glVertexAttribPointer(0, 3, 5126, false, 0, 0L);
        GL15.glBindBuffer(34962, 0);
        GL30.glBindVertexArray(0);
    }

    private void loop() {
        GL11.glClearColor(0.0f, 0.0f, 0.0f, 0.0f);
        System.out.println("Before tick 1: " + GL11.glGetError());
        int tickID = GL20.glGetUniformLocation(this.shader.getProgramID(), "tick");
        System.out.println("Error tick 1: " + GL11.glGetError());
        int windowSizeIDFrag = GL20.glGetUniformLocation(this.shader.getProgramID(), "windowSize");
        int tickLoc = GL20.glGetUniformLocation(this.textureShader.getProgramID(), "tick");
        System.out.println("Error tick 2: " + GL11.glGetError());
        long start = System.nanoTime();
        new Sound();
        while (GLFW.glfwWindowShouldClose(this.window) == 0) {
            long t0 = System.nanoTime();
            float elapsed = (float)((double)(System.nanoTime() - start) / 1.0E9);
            float debugStart = 0.0f;
            GL13.glActiveTexture(33984);
            GL11.glBindTexture(3553, this.noise.textureID);
            GL30.glBindFramebuffer(36160, this.fbo.fbo);
            GL11.glViewport(0, 0, this.fbo.width, this.fbo.height);
            GL11.glClear(16640);
            this.shader.enable();
            GL20.glUniform1f(tickID, elapsed + debugStart);
            GL20.glUniform2f(windowSizeIDFrag, this.windowWidth, this.windowHeight);
            GL30.glBindVertexArray(this.vaoId);
            GL11.glDrawArrays(4, 0, this.vertexCount);
            GL30.glBindVertexArray(0);
            this.shader.disable();
            GL13.glActiveTexture(33984);
            GL11.glBindTexture(3553, this.fbo.textureID);
            GL30.glBindFramebuffer(36160, 0);
            GL11.glViewport(0, 0, this.windowWidth, this.windowHeight);
            this.textureShader.enable();
            GL20.glUniform1f(tickLoc, elapsed + debugStart);
            GL30.glBindVertexArray(this.vaoId);
            GL11.glDrawArrays(4, 0, this.vertexCount);
            GL30.glBindVertexArray(0);
            this.textureShader.disable();
            GL11.glBindTexture(3553, 0);
            GLFW.glfwSwapBuffers(this.window);
            GLFW.glfwPollEvents();
            ++this.tick;
            System.out.println(1000.0 / ((double)(System.nanoTime() - t0) / 1000000.0));
            if (!(elapsed + debugStart >= 210.0f)) continue;
            System.exit(0);
        }
        GL11.glBindTexture(3553, 0);
    }
}

