/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.awt.Graphics;
import javax.swing.JFrame;
import javax.swing.JPanel;

public class NavierStokesWater {
    private int N = 100;
    private int size = (this.N + 2) * (this.N + 2);
    private double[] u = new double[this.size];
    private double[] v = new double[this.size];
    private double[] u_prev = new double[this.size];
    private double[] v_prev = new double[this.size];
    private double[] dens = new double[this.size];
    private double[] dens_prev = new double[this.size];

    public NavierStokesWater() {
        JFrame frame = new JFrame();
        frame.setSize(500, 500);
        frame.setDefaultCloseOperation(3);
        JPanel panel = new JPanel();
        frame.add(panel);
        frame.setVisible(true);
        double dt = 1.0;
        double visc = 2.0;
        double diff = 2.0;
        while (true) {
            long t0 = System.currentTimeMillis();
            int n = this.IX(50, 2);
            this.dens_prev[n] = this.dens_prev[n] + 40.0;
            this.v_prev[this.IX((int)50, (int)2)] = 1.0;
            this.vel_step(this.N, this.u, this.v, this.u_prev, this.v_prev, visc, dt);
            this.dens_step(this.N, this.dens, this.dens_prev, this.u, this.v, diff, dt);
            this.draw_dens(panel.getGraphics());
            System.out.println(System.currentTimeMillis() - t0);
            try {
                Thread.sleep(16L);
                continue;
            }
            catch (InterruptedException e) {
                e.printStackTrace();
                continue;
            }
            break;
        }
    }

    private void SWAP(double[] x0, double[] x) {
        double[] tmp = new double[x0.length];
        int i = 0;
        while (i < tmp.length) {
            tmp[i] = x0[i];
            ++i;
        }
        i = 0;
        while (i < tmp.length) {
            x0[i] = x[i];
            ++i;
        }
        i = 0;
        while (i < tmp.length) {
            x[i] = tmp[i];
            ++i;
        }
    }

    private void draw_dens(Graphics g) {
        int s = 5;
        int x = 0;
        while (x < this.N) {
            int y = 0;
            while (y < this.N) {
                double d = this.dens[this.IX(x, y)];
                int gs = (int)Math.min(d * 255.0, 255.0);
                g.setColor(new Color(gs, gs, gs));
                g.fillRect(x * s, y * s, s, s);
                ++y;
            }
            ++x;
        }
    }

    private int IX(int i, int j) {
        return i + (this.N + 2) * j;
    }

    void add_source(int N, double[] x, double[] s, double dt) {
        int size = (N + 2) * (N + 2);
        int i = 0;
        while (i < size) {
            int n = i;
            x[n] = x[n] + dt * s[i];
            ++i;
        }
    }

    void diffuse(int N, int b, double[] x, double[] x0, double diff, double dt) {
        double a = dt * diff * (double)N * (double)N;
        int k = 0;
        while (k < 20) {
            int i = 1;
            while (i <= N) {
                int j = 1;
                while (j <= N) {
                    x[this.IX((int)i, (int)j)] = (x0[this.IX(i, j)] + a * (x[this.IX(i - 1, j)] + x[this.IX(i + 1, j)] + x[this.IX(i, j - 1)] + x[this.IX(i, j + 1)])) / (1.0 + 4.0 * a);
                    ++j;
                }
                ++i;
            }
            this.set_bnd(N, b, x);
            ++k;
        }
    }

    void advect(int N, int b, double[] d, double[] d0, double[] u, double[] v, double dt) {
        double dt0 = dt * (double)N;
        int i = 1;
        while (i <= N) {
            int j = 1;
            while (j <= N) {
                double x = (double)i - dt0 * u[this.IX(i, j)];
                double y = (double)j - dt0 * v[this.IX(i, j)];
                if (x < 0.5) {
                    x = 0.5;
                }
                if (x > (double)N + 0.5) {
                    x = (double)N + 0.5;
                }
                int i0 = (int)x;
                int i1 = i0 + 1;
                if (y < 0.5) {
                    y = 0.5;
                }
                if (y > (double)N + 0.5) {
                    y = (double)N + 0.5;
                }
                int j0 = (int)y;
                int j1 = j0 + 1;
                double s1 = x - (double)i0;
                double s0 = 1.0 - s1;
                double t1 = y - (double)j0;
                double t0 = 1.0 - t1;
                d[this.IX((int)i, (int)j)] = s0 * (t0 * d0[this.IX(i0, j0)] + t1 * d0[this.IX(i0, j1)]) + s1 * (t0 * d0[this.IX(i1, j0)] + t1 * d0[this.IX(i1, j1)]);
                ++j;
            }
            ++i;
        }
        this.set_bnd(N, b, d);
    }

    void dens_step(int N, double[] x, double[] x0, double[] u, double[] v, double diff, double dt) {
        this.add_source(N, x, x0, dt);
        this.SWAP(x0, x);
        this.diffuse(N, 0, x, x0, diff, dt);
        this.SWAP(x0, x);
        this.advect(N, 0, x, x0, u, v, dt);
    }

    void vel_step(int N, double[] u, double[] v, double[] u0, double[] v0, double visc, double dt) {
        this.add_source(N, u, u0, dt);
        this.add_source(N, v, v0, dt);
        this.SWAP(u0, u);
        this.diffuse(N, 1, u, u0, visc, dt);
        this.SWAP(v0, v);
        this.diffuse(N, 2, v, v0, visc, dt);
        this.project(N, u, v, u0, v0);
        this.SWAP(u0, u);
        this.SWAP(v0, v);
        this.advect(N, 1, u, u0, u0, v0, dt);
        this.advect(N, 2, v, v0, u0, v0, dt);
        this.project(N, u, v, u0, v0);
    }

    void project(int N, double[] u, double[] v, double[] p, double[] div) {
        int j;
        double h = 1.0 / (double)N;
        int i = 1;
        while (i <= N) {
            j = 1;
            while (j <= N) {
                div[this.IX((int)i, (int)j)] = -0.5 * h * (u[this.IX(i + 1, j)] - u[this.IX(i - 1, j)] + v[this.IX(i, j + 1)] - v[this.IX(i, j - 1)]);
                p[this.IX((int)i, (int)j)] = 0.0;
                ++j;
            }
            ++i;
        }
        this.set_bnd(N, 0, div);
        this.set_bnd(N, 0, p);
        int k = 0;
        while (k < 20) {
            i = 1;
            while (i <= N) {
                j = 1;
                while (j <= N) {
                    p[this.IX((int)i, (int)j)] = (div[this.IX(i, j)] + p[this.IX(i - 1, j)] + p[this.IX(i + 1, j)] + p[this.IX(i, j - 1)] + p[this.IX(i, j + 1)]) / 4.0;
                    ++j;
                }
                ++i;
            }
            this.set_bnd(N, 0, p);
            ++k;
        }
        i = 1;
        while (i <= N) {
            j = 1;
            while (j <= N) {
                int n = this.IX(i, j);
                u[n] = u[n] - 0.5 * (p[this.IX(i + 1, j)] - p[this.IX(i - 1, j)]) / h;
                int n2 = this.IX(i, j);
                v[n2] = v[n2] - 0.5 * (p[this.IX(i, j + 1)] - p[this.IX(i, j - 1)]) / h;
                ++j;
            }
            ++i;
        }
        this.set_bnd(N, 1, u);
        this.set_bnd(N, 2, v);
    }

    void set_bnd(int N, int b, double[] x) {
        int i = 1;
        while (i <= N) {
            x[this.IX((int)0, (int)i)] = b == 1 ? -x[this.IX(1, i)] : x[this.IX(1, i)];
            x[this.IX((int)(N + 1), (int)i)] = b == 1 ? -x[this.IX(N, i)] : x[this.IX(N, i)];
            x[this.IX((int)i, (int)0)] = b == 2 ? -x[this.IX(i, 1)] : x[this.IX(i, 1)];
            x[this.IX((int)i, (int)(N + 1))] = b == 2 ? -x[this.IX(i, N)] : x[this.IX(i, N)];
            ++i;
        }
        x[this.IX((int)0, (int)0)] = 0.5 * (x[this.IX(1, 0)] + x[this.IX(0, 1)]);
        x[this.IX((int)0, (int)(N + 1))] = 0.5 * (x[this.IX(1, N + 1)] + x[this.IX(0, N)]);
        x[this.IX((int)(N + 1), (int)0)] = 0.5 * (x[this.IX(N, 0)] + x[this.IX(N + 1, 1)]);
        x[this.IX((int)(N + 1), (int)(N + 1))] = 0.5 * (x[this.IX(N, N + 1)] + x[this.IX(N + 1, N)]);
        int n = 45;
        i = 1;
        while (i <= n) {
            x[this.IX((int)0, (int)i)] = b == 1 ? -x[this.IX(1, i)] : x[this.IX(1, i)];
            x[this.IX((int)(n + 1), (int)i)] = b == 1 ? -x[this.IX(n, i)] : x[this.IX(n, i)];
            x[this.IX((int)i, (int)0)] = b == 2 ? -x[this.IX(i, 1)] : x[this.IX(i, 1)];
            x[this.IX((int)i, (int)(n + 1))] = b == 2 ? -x[this.IX(i, n)] : x[this.IX(i, n)];
            ++i;
        }
        x[this.IX((int)0, (int)0)] = 0.5 * (x[this.IX(1, 0)] + x[this.IX(0, 1)]);
        x[this.IX((int)0, (int)(n + 1))] = 0.5 * (x[this.IX(1, n + 1)] + x[this.IX(0, n)]);
        x[this.IX((int)(n + 1), (int)0)] = 0.5 * (x[this.IX(n, 0)] + x[this.IX(n + 1, 1)]);
        x[this.IX((int)(n + 1), (int)(n + 1))] = 0.5 * (x[this.IX(n, n + 1)] + x[this.IX(n + 1, n)]);
    }

    public static void main(String[] args) {
        new NavierStokesWater();
    }
}

