uniform sampler2D iChannel0;
uniform sampler2D tex0;
uniform sampler2D tex1;
uniform vec2 iResolution;
uniform float contour_adf;
uniform float modval;
float contourSample(vec2 uv){
    float val = texture2D(iChannel0, uv).r;
    val = mod(val*90.0, modval);
    val = pow(val, 64.0);
    return clamp(0.0, 1.0, val);
}

void mainImage( out vec4 fragColor, in vec2 fragCoord )
{
    vec2 uv = fragCoord / iResolution.xy;
    float val = contourSample(uv);
    
    val += contourSample(uv+vec2(0.0, contour_adf/iResolution.y));
    val += contourSample(uv+vec2(contour_adf/iResolution.x, 0.0));
    val += contourSample(uv+vec2(contour_adf/iResolution.xy));
    val /= 4.0;
    
    //if(val < 0.1) discard;
    fragColor = vec4(vec3(val), 1.0);
}

void main() {
    vec4 fragColor = vec4( 0.);
    vec2 fragCoord = gl_FragCoord.xy;
    mainImage( fragColor, fragCoord);
    gl_FragColor = fragColor;
}