uniform sampler2D iChannel0;
uniform sampler2D tex0;
uniform sampler2D tex1;
uniform vec2 iResolution;
uniform float iGlobalTime;
uniform float cameraRotation_x;
uniform float cameraRotation_y;
uniform float cameraRotation_z;
uniform float cameraPosition_x;
uniform float cameraPosition_y;
uniform float cameraPosition_z;
uniform float obj_rot_x;
uniform float obj_rot_y;
uniform float obj_rot_z;
uniform float logo_width;
uniform float logo_height;
uniform float fft;
uniform float fstr_val;
uniform float fft_mult;
uniform float prism_weight;
uniform float tunnel_wrip0;
uniform float tunnel_wrip1;

float t = iGlobalTime;
vec2 r = iResolution;

const int MAX_ITER = 128;
const float MAX_DIST = 32.0;
const float EPSILON = 0.0001;
const int MAX_RECURSE = 1; // Reflections

// Rotations

mat3 rotateX(float v){return mat3(1,0,0,0,cos(v),-sin(v),0,sin(v),cos(v));}
mat3 rotateY(float v){return mat3(cos(v),0,sin(v),0,1,0,-sin(v),0,cos(v));}
mat3 rotateZ(float v){return mat3(cos(v),-sin(v),0,sin(v),cos(v),0,0,0,1);}

// Hash without Sine
// Created by David Hoskins.


//----------------------------------------------------------------------------------------
//  1 out, 2 in...
float hash12(vec2 p)
{
  vec3 p3  = fract(vec3(p.xyx) * .1031);
    p3 += dot(p3, p3.yzx + 19.19);
    return fract((p3.x + p3.y) * p3.z);
}

// END Hash without Sine

// HG_SDF, SEE README
// Maximum/minumum elements of a vector
float vmax(vec3 v) {
  return max(max(v.x, v.y), v.z);
}

// Repeat in two dimensions
vec2 pMod2(inout vec2 p, vec2 size) {
  vec2 c = floor((p + size*0.5)/size);
  p = mod(p + size*0.5,size) - size*0.5;
  return c;
}

// Repeat in three dimensions
vec3 pMod3(inout vec3 p, vec3 size) {
  vec3 c = floor((p + size*0.5)/size);
  p = mod(p + size*0.5, size) - size*0.5;
  return c;
}

// copypasta from branch

vec2 hash( vec2 p )
{
  p = vec2( dot(p,vec2(127.1,311.7)),
        dot(p,vec2(269.5,183.3)) );

  return -1.0 + 2.0*fract(sin(p)*43758.5453123);
}

float noise( in vec2 p )
{
    const float K1 = 0.366025404; // (sqrt(3)-1)/2;
    const float K2 = 0.211324865; // (3-sqrt(3))/6;

  vec2 i = floor( p + (p.x+p.y)*K1 );

    vec2 a = p - i + (i.x+i.y)*K2;
    vec2 o = (a.x>a.y) ? vec2(1.0,0.0) : vec2(0.0,1.0); //vec2 of = 0.5 + 0.5*vec2(sign(a.x-a.y), sign(a.y-a.x));
    vec2 b = a - o + K2;
  vec2 c = a - 1.0 + 2.0*K2;

    vec3 h = max( 0.5-vec3(dot(a,a), dot(b,b), dot(c,c) ), 0.0 );

  vec3 n = h*h*h*h*vec3( dot(a,hash(i+0.0)), dot(b,hash(i+o)), dot(c,hash(i+1.0)));

    return dot( n, vec3(70.0) );

}
// end copypasta

// Repeat the domain only in positive direction. Everything in the negative half-space is unchanged.
float pModSingle1(inout float p, float size) {
  float halfsize = size*0.5;
  float c = floor((p + halfsize)/size);
  if (p >= 0.0) {
    p = mod(p + halfsize, size) - halfsize;
  }
  return c;
}

// The "Round" variant uses a quarter-circle to join the two objects smoothly:
float fOpUnionRound(float a, float b, float r) {
  vec2 u = max(vec2(r - a,r - b), vec2(0));
  return max(r, min (a, b)) - length(u);
}

// The "Chamfer" flavour makes a 45-degree chamfered edge (the diagonal of a square of size <r>):
float fOpUnionChamfer(float a, float b, float r) {
  return min(min(a, b), (a - r + b)*sqrt(0.5));
}

// Intersection has to deal with what is normally the inside of the resulting object
// when using union, which we normally don't care about too much. Thus, intersection
// implementations somets differ from union implementations.
float fOpIntersectionChamfer(float a, float b, float r) {
  return max(max(a, b), (a + r + b)*sqrt(0.5));
}

// Difference can be built from Intersection or Union:
float fOpDifferenceChamfer (float a, float b, float r) {
  return fOpIntersectionChamfer(a, -b, r);
}

// Primitives

float fSphere(vec3 p, float r) {
  return length(p) - r;
}

// Box: correct distance to corners
float fBox(vec3 p, vec3 b) {
  vec3 d = abs(p) - b;
  return length(max(d, vec3(0))) + vmax(min(d, vec3(0)));
}

// END HG_SDF, SEE README


float opDisplace( vec3 p, float obj )
{
    float d1 = obj;
    float d2 = sin(t*p.x)*sin(t*p.y)*sin(t*p.z);
    return d1+d2;
}

float distfunc(vec3 pos)
{
  float field = 1.0;
  // re-center camera to make rotation centered
  pos += vec3(0.0, 0.0, -1.0);

  // rotations
  pos *= rotateY(0.3*sin(cameraRotation_y));
  pos *= rotateZ(0.2*sin(0.8*cameraRotation_z) + obj_rot_z * pos.z + 0.01*cameraRotation_z);
  pos *= rotateX(0.5*sin(0.9*cameraRotation_x));

  // Move the camera a bit
  pos.y -= 1.0;
  // Zoom!
  pos.z -= 5.0*cameraPosition_z;
  // Camera movements
  pos.x -= cameraPosition_x;

  float cubesize = 0.4;

  vec3 neutral = pos;
  pMod3(neutral, vec3(14.0, 10.0, 4.0));

  vec3 fourPos = neutral + vec3(2.0, 0.0, 0.0);

  // 4, horizontal bar
  for (int i=0; i<2; i++) {
    vec3 cubepos = fourPos;
    cubepos.x += float(i+1);
    float cube = fBox(cubepos, vec3(cubesize));
    field = min(field, cube);
  }

  // 4, vertical bar
  for (int i=0; i<4; i++) {
    vec3 cubepos = fourPos;
    cubepos.y += float(i);
    float cube = fBox(cubepos, vec3(cubesize));
    field = min(field, cube);
  }

  // 4, diagonal
  field = min(field, fBox(fourPos + vec3(1., 2., 0.), vec3(cubesize)));
  field = min(field, fBox(fourPos + vec3(2., 1., 0.), vec3(cubesize)));
  // 4, bottom and right side
  field = min(field, fBox(fourPos + vec3(-1., 0., 0.), vec3(cubesize)));
  field = min(field, fBox(fourPos + vec3(0., -1., 0.), vec3(cubesize)));


  vec3 kPos = neutral + vec3(-2.0, -1.0, 0.0);

  // K, vertical bar
  for (int i=0; i<5; i++) {
    vec3 cubepos = kPos;
    cubepos.y += float(i);
    float cube = fBox(cubepos, vec3(cubesize));
    field = min(field, cube);
  }

  // K, diagonals
  field = min(field, fBox(kPos + vec3(-1., 2., 0.), vec3(cubesize)));
  field = min(field, fBox(kPos + vec3(-2., 1., 0.), vec3(cubesize)));
  field = min(field, fBox(kPos + vec3(-3., 0., 0.), vec3(cubesize)));

  field = min(field, fBox(kPos + vec3(-2., 3., 0.), vec3(cubesize)));
  field = min(field, fBox(kPos + vec3(-3., 4., 0.), vec3(cubesize)));

  return field;
}

// Raymarch
// returns pos ended up at + normal
void rayMarch(inout vec3 pos, vec3 rayDir, out vec3 normal) {
  float totalDist = 0.0;
  float dist = EPSILON;
  for (int i = 0; i < MAX_ITER; i++)
  {
    dist = distfunc(pos);
    totalDist += dist;
    pos += dist * rayDir;

    if (dist < EPSILON || totalDist > MAX_DIST)
    break;
  }

  // Calculate normals
  if (dist < EPSILON)
  {
    vec2 eps = vec2(0.0, EPSILON);
    normal = normalize(vec3(
      distfunc(pos + eps.yxx) - distfunc(pos - eps.yxx),
      distfunc(pos + eps.xyx) - distfunc(pos - eps.xyx),
      distfunc(pos + eps.xxy) - distfunc(pos - eps.xxy)));
  }
  else {
    normal = vec3(0.0);
  }

}

// Main drawing loop
void main(){
  // Camera setup
  vec3 cameraOrigin = vec3(0.0, 0.0, 1.0);
  vec3 cameraTarget = vec3(0.0, 0.0, 0.0);
  vec3 upDirection = vec3(0.0, 1.0, 0.0);
  vec3 cameraDir = normalize(cameraTarget - cameraOrigin);
  vec3 cameraRight = normalize(cross(upDirection, cameraOrigin));
  vec3 cameraUp = cross(cameraDir, cameraRight);
  vec2 screenPos = -1.0 + 2.0 * gl_FragCoord.xy / r.xy; // screenPos can range from -1 to 1
  screenPos.x *= r.x / r.y;                   // Correct aspect ratio
  //pMod2(screenPos.xy, vec2(1.69*0.1*t, 0.1*t)); // SPLITSCREEN
  vec3 rayDir = normalize(cameraRight * screenPos.x + cameraUp * screenPos.y + cameraDir);

  // Call raymarch from camera origin
  vec3 pos = cameraOrigin;
  vec3 normal, color, defaultColor;
  float dist;
  defaultColor = vec3(0.153, 0.157, 0.133); // dark warm grey
  //defaultColor = vec3(0.0); // black

  // Iterate
  for (int i = 0; i < MAX_RECURSE; i++) {
    // March from camera
    rayMarch(pos, rayDir, normal);

    float diffuse, specular, distDarken;
    dist = distance(cameraOrigin, pos);

    // Lighting, from camera
    diffuse = max(0.0, dot(-rayDir, normal));
    specular = 0.1*pow(diffuse, 32.0);
    distDarken = 0.001*dist*dist;

    if (i==0) {
      // first, primary iteration
      color = defaultColor + vec3(max(0.0, diffuse + specular - distDarken));
    } else {
    // latter iterations; reflections
      color -= 0.2*vec3(max(0.0, diffuse + specular - distDarken));
    }

    // Change direction for re-march.
    pos -= rayDir*0.1;
    // Remember to step out a bit, to not hit the object we bounced off!
    rayDir = reflect(rayDir, normal);
  }

  // POST PROCESSING

  // vignette
  vec2 uv = gl_FragCoord.xy / r.xy-vec2(.5);
  float vignette = exp(-4.0*(uv.x*uv.x+uv.y*uv.y));
  // grain
  vec2 position = gl_FragCoord.xy;
  float a = 0.0, b = a;
    for (int o = 0; o < 4; o++) {
        float v = float(o+1)*.152;
        vec2 pos = (position * v + t * 500.);
        a += hash12(pos);
    }
  vec3 noisecol = vec3(mix(b, a, step(uv.x, .5))) / float(4);
  float grain = noisecol.x + 0.5;
  grain *= 0.6;
  vec4 finalcolor1 = vec4(color * vignette * grain, 1.0);
  finalcolor1.r = min(max(finalcolor1.r, 0.0), 1.0);
  finalcolor1 = vec4(texture2D(tex0, vec2(finalcolor1.r,0.0)).rgb,1.);
  vec4 finalcolor2 = vec4(color * vignette * grain, 1.0);
  finalcolor2.r = min(max(finalcolor2.r, 0.0), 1.0);
  finalcolor2 = vec4(texture2D(tex1, vec2(finalcolor2.r,0.0)).rgb,1.);
  gl_FragColor = obj_rot_x * finalcolor1 + (1.0 - obj_rot_x) * finalcolor1.rrra;
}