// Created by inigo quilez - iq/2013
// License Creative Commons Attribution-NonCommercial-ShareAlike 3.0 Unported License.

#version 330

uniform float uTime;
uniform sampler2D uTex0;

vec2 uRes = vec2(1024.0, 768.0);

vec3 deform( in vec2 p )
{
    vec2 q = sin( vec2(1.1,1.2)*uTime + p );

    float a = atan( q.y, q.x );
    float r = sqrt( dot(q,q) );

    vec2 uv = p*sqrt(1.0+r*r);
    uv = uv + sin( vec2(0.0,0.6) + vec2(1.0,1.1)*uTime);
         
    return texture2D( uTex0, uv*0.3).yxx;
}

out vec4 fragColor;

void main ( void )
{
    vec2 p = -1.0 + 2.0*gl_FragCoord.xy/uRes.xy;

    vec3  col = vec3(0.0);
    vec2  d = (vec2(0.0,0.0)-p)/64.0;
    float w = 1.0;
    vec2  s = p;
    for( int i=0; i<64; i++ )
    {
        vec3 res = deform( s );
        col = col + w*smoothstep( 0.0, 1.0, res );
        w = w * .99;
        s = s + d;
    }
    col = col * 3.5 / 64.0;

fragColor = vec4( col, 1.0 );
}