var Stereo = (function () {

    "use strict";

    var _model,
        _duration = 0,
        _sync,
        _width,
        _height,
        _ctx,
        _preflightCallback;

    var _hctx, _bctx, _k, _b, _hopalong;

    var _color = {
        blot: "#000",
        background: "#fff",
        redLine: '#f11',
        hopa: '#000'
    };

    var _blot = [],
        _redLineCoords = [],
        _lineNoiseCoords = [],
        _hopa = 0,
        _lineRepeatY;

    var _hopaMul = 1;

    var _sync_enableBlot,
        _sync_enableHopa,
        _sync_enableRedLine,
        _sync_enableLineNoise,
        _sync_enableLineRepeat,
        _sync_enableInvert,
        _sync_enableFlippedY,

        _sync_scale,
        _sync_kAngle,
        _sync_kParts,

        _sync_randomBlot,
        _sync_randomHopalong,
        _sync_randomLineRepeat,
        _sync_randomLineNoise,
        _sync_randomRedLine,
        _sync_randomColor,
        _sync_refresh;

    var _startX,
        _startY;

    //sync
    var _blackFade,
        _glow;

    function refreshColours(row) {
        var value = _sync_randomColor.getValue(row),
            r = NonRandom(value);

        if (value === 0) {
            _color = {
                blot: "#000",
                background: "#fff",
                redLine: '#f11',
                hopa: '#000'
            }
        } else {
            _color = {
                blot: r.color(),
                background: r.color(),
                redLine: r.color(),
                hopa: r.color()
            };
        }
    }

    function drawBlot(t) {
        _bctx.beginPath();
        _bctx.moveTo(_startX, _startY);

        for (var i = 0, len = _blot.length; i < len; i++) {

            var offsetSin = Math.sin((t / 100) + (i * 100)) * _width / 20,
                offsetCos = Math.cos((t / 100) + (i * 100)) * _height / 20;

            var offsetX = (i % 2) ? offsetSin : offsetCos,
                offsetY = (i % 2) ? offsetCos : offsetSin;
            _bctx.bezierCurveTo(
                _blot[i].cp1x + offsetX, _blot[i].cp1y + offsetY,
                _blot[i].cp2x + offsetX, _blot[i].cp2y + offsetY,
                _blot[i].x + offsetX, _blot[i].y + offsetY
            );
        }
        _bctx.closePath();
        _bctx.fill();
    }

    function scale(amount) {

        var w = _width * amount,
            h = _height * amount,
            x = (_width - w) / 2,
            y = (_height - h) / 2;

        _ctx.drawImage(_bctx.canvas, x, y, w, h);
    }

    function invert(amount) {

        var color = Math.round(255 * amount);

        _ctx.save();

        _ctx.globalCompositeOperation = "exclusion";
        _ctx.fillStyle = "rgba(" + color + "," + color + "," + color + ",1)";
        _ctx.fillRect(0, 0, _width, _height);
        _ctx.restore();
    }

    function pullLine() {

        var y = _lineRepeatY,
            h = _height - y;

        _ctx.drawImage(_ctx.canvas,
            0, y, _width, 1,
            0, y, _width, h);
    }

    function lineNoise() {

        for (var i = 0, len = _lineNoiseCoords.length; i < len; i++) {

            _ctx.drawImage(_bctx.canvas,
                0, _lineNoiseCoords[i].sY, _width, _lineNoiseCoords[i].h,
                _lineNoiseCoords[i].dX, _lineNoiseCoords[i].dY, _width, _lineNoiseCoords[i].h);
        }
    }

    function addRedLine() {

        for (var i = 0, len = _redLineCoords.length; i < len; i++) {
            _ctx.save();
            _ctx.fillStyle = _color.redLine;
            _ctx.fillRect(_redLineCoords[i].x, 0, _redLineCoords[i].w, _height);
            _ctx.restore();
        }
    }

    function refreshAll(row){
        refreshBlot(row || 0);
        refreshHopalong(row || 0);
        refreshRedline(row || 0);
        refreshLineNoise(row || 0);
        refreshLineRepeat(row || 0);
        refreshColours(row || 0);
    }

    function refreshCoords(blot, hopa, red, noise, line, row) {

        if (blot === true) {
            refreshBlot(row || 0);
        }

        if (hopa === true) {
            refreshHopalong(row || 0);
        }

        //redLine
        if (red === true) {
            refreshRedline(row || 0);
        }

        //lineNoise
        if (noise === true) {
            refreshLineNoise(row || 0);
        }

        if (line === true) {
            refreshLineRepeat(row || 0);
        }

        //if (line === true)
            refreshColours(row || 0);
    }

    function refreshBlot(row) {
        _blot = [];
        var r = NonRandom(_sync_randomBlot.getValue(row));
        for (var i = 0; i < 50; i++) {
            _blot.push({
                cp1x: r.range(_width / 2.3, _width / 1.3), cp1y: r.range(_height / 5, _height / 1.3),
                cp2x: r.range(_width / 2.3, _width / 1.3), cp2y: r.range(_height / 5, _height / 1.3),
                x: r.range(_width / 2.3, _width / 1.3), y: r.range(_height / 5, _height / 1.3)
            });
        }
    }

    function refreshHopalong(row) {
        var r = NonRandom(_sync_randomHopalong.getValue(row));
        _hopa = r.range(0, 9001);
    }

    function refreshLineRepeat(row) {
        var r = NonRandom(_sync_randomLineRepeat.getValue(row));

        _lineRepeatY = r.range(_height/5, _height);
    }

    function refreshLineNoise(row) {
        _lineNoiseCoords = [];
        var r = NonRandom(_sync_randomLineNoise.getValue(row));
        for (var i = 0; i < 20; i++) {
            var h = r.range(_height / 100, _height / 20);

            _lineNoiseCoords.push({
                h: r.range(_height / 100, _height / 20),
                sY: r.range(0, _height - h),
                dY: r.range(0, _height - h),
                dX: r.range(0, _width / 10)
            });
        }
    }

    function refreshRedline(row) {
        _redLineCoords = [];
        var value = _sync_randomRedLine.getValue(row),
            r = NonRandom(value);
        var l = r.range(3, 5);

        for (var i = 0; i < l; i++) {
            var w = r.range(_width / (_width - 2), _width / 40);

            _redLineCoords.push({
                x: r.range(0, _width),
                w: w//r.range(_width / (_width - 2), _width / 40)
            });
        }
    }


    function preflight(callbackFn, duration, model) {
        _preflightCallback = callbackFn;

        _duration = duration;
        _model = model;

        _sync = _model.sync;
        _width = _model.width();
        _height = _model.height();

        _startX = _width / 2;
        _startY = _height / 2;


        //backbuffer
        _bctx = document.createElement('canvas').getContext('2d');
        _bctx.canvas.width = _width;
        _bctx.canvas.height = _height;

        //ctx for hopalong, as scaling causes mayor problems
        _hctx = document.createElement('canvas').getContext('2d');
        _hctx.canvas.width = 1920;//_width;
        _hctx.canvas.height = 1080;//_height;

        initSync();

        _ctx = _model.twoDeeRenderer;


        _hopalong = new Hopalong();
        _hopalong.setContext(_hctx);//, _width, _height);

        _k = new Kaleidoscope();
        _k.setContext(_bctx);

        _b = new SuperFastBlur();
        _b.setContext(_bctx);

        _k.setContext(_bctx);

        _preflightCallback();
    }

    function init() {
        _model.on("resize", resize);

        Random.seed(243234234, 456456234, 456456546, 3446534435);
        refreshAll(0);

    }

    function initSync() {

        _blackFade = _sync.getTrack('blackFade');
        _glow = _sync.getTrack('glow');

        _sync_enableBlot = _sync.getTrack('enableBlot');
        _sync_enableHopa = _sync.getTrack('enableHopa');
        _sync_enableRedLine = _sync.getTrack('enableRed');
        _sync_enableLineNoise = _sync.getTrack('enableLineNoise');
        _sync_enableLineRepeat = _sync.getTrack('enableRepeat');
        _sync_enableInvert = _sync.getTrack('enableInvert');
        _sync_enableFlippedY = _sync.getTrack('enableFlipY');
        _sync_scale = _sync.getTrack('scale');

        _sync_randomBlot = _sync.getTrack('refreshBlot');
        _sync_randomHopalong = _sync.getTrack('refreshHopalong');
        _sync_randomLineRepeat = _sync.getTrack('refreshLineRepeat');
        _sync_randomLineNoise = _sync.getTrack('refreshLineNoise');
        _sync_randomRedLine = _sync.getTrack('refreshRedLine');
        _sync_randomColor = _sync.getTrack('refreshColor');
        _sync_refresh = _sync.getTrack('refresh');

        _sync_kParts = _sync.getTrack('kParts');
        _sync_kAngle = _sync.getTrack('kAngle');
    }

    function render(row, sceneTime, frameDelta) {

        var glow = _glow.getValue(row),
            bF = _blackFade.getValue(row),
            _enableBlot = !!_sync_enableBlot.getValue(row),
            _enableHopa = !!_sync_enableHopa.getValue(row),
            _enableRedLine = !!_sync_enableRedLine.getValue(row),
            _enableLineNoise = !!_sync_enableLineNoise.getValue(row),
            _enableLineRepeat = !!_sync_enableLineRepeat.getValue(row),
            _enableInvert = _sync_enableInvert.getValue(row),
            _enableFlippedY = !!_sync_enableFlippedY.getValue(row),
            _scale = _sync_scale.getValue(row),

            _refresh = !!_sync_refresh.getValue(row),
            _kParts = _sync_kParts.getValue(row),
            _kAngle = _sync_kAngle.getValue(row);

        if (_refresh)
            refreshAll(row);

        _bctx.fillStyle = _color.background;
        _bctx.fillRect(0, 0, _width, _height);

        _bctx.fillStyle = _color.blot;
        if (_enableBlot) {
            drawBlot(row);
        }


        _bctx.fillStyle = _color.hopa;
        if (_enableHopa) {
            _hctx.clearRect(0, 0, 1920, 1080);
            _hopalong.render(_hopa + _hopaMul);
            _bctx.drawImage(_hctx.canvas, 0, 0, _width, _height);
        }

        _k.setParts(_kParts-1);
        _k.setAngle(_kAngle);
        _k.render();

        //fill buffer
        _ctx.clearRect(0, 0, _width, _height);
        scale(_scale);

        if (_enableLineNoise)
            lineNoise(row);

        if (_enableLineRepeat)
            pullLine(row);

        if (_enableInvert)
            invert(_enableInvert);

        if (_enableRedLine)
            addRedLine(row);

        if (_enableFlippedY) {
            _ctx.save();
            _ctx.translate(0, _height);
            _ctx.scale(1, -1);
            _ctx.drawImage(_ctx.canvas, 0, 0);
            _ctx.restore();
        }

        //start glow
        if (glow > 0) {
            var glowScale = 1;

            for (var i = 0; i < 4; i++) {
                glowScale += .01;
                var sW = _width * glowScale,
                    sH = _height * glowScale;
                _ctx.save();
                _ctx.globalCompositeOperation = 'lighter';
                _ctx.globalAlpha = glow;
                _ctx.drawImage(_ctx.canvas, (_width - sW) / 2, (_height - sH) / 2, sW, sH);
                _ctx.restore();
            }
        }
        //end glow

        blur();

        if (bF > 0) {
            _ctx.fillStyle = "rgba(0,0,0," + bF + ")";
            _ctx.fillRect(0, 0, _width, _height);
        }
    }

    function clear() {
        _model.on("resize", function () {
        });
    }

    function resize(width, height) {
        _width = width;
        _height = height;
    }

    return {
        preflight: preflight,
        init: init,
        render: render,
        clear: clear,
        resize: resize
    };
}());