local MOUSE_DOWN = 1025
local MOUSE_UP = 1026
local TOUCH_DOWN = 1792
local TOUCH_UP = 1793
local TOUCH_MOVE = 1794

_G.inputAccelerationKeys = {}
_G.inputAccelerationKeys[_G.UP] = { vertical = 1 }
_G.inputAccelerationKeys[_G.DOWN] = { vertical = -1}
_G.inputAccelerationKeys[_G.LEFT] = { horizontal = -1 }
_G.inputAccelerationKeys[_G.RIGHT] = { horizontal = 1 }
_G.inputAccelerationKeys[_G.KEY_A] = { horizontal = -1 }
_G.inputAccelerationKeys[_G.KEY_D] = { horizontal = 1 }
_G.inputAccelerationKeys[_G.KEY_W] = { vertical = 1 }
_G.inputAccelerationKeys[_G.KEY_S] = { vertical = -1 }

_G.inputAccelerationTouches = {}
_G.inputAccelerationTouches["left"] = { horizontal = -1 }
_G.inputAccelerationTouches["right"] = { horizontal = 1 }
_G.isTouching = false


_G.inputAcceleration = { horizontal = 0, vertical = 0 }
_G.keysDown = {}
local touchesDown = {}

function _G.onTouchEvent(eventType, finger, x, y, entity)
	--print("Touch event")
	if entity == nil then
		entity = _G.world
		if eventType == TOUCH_DOWN or eventType == TOUCH_MOVE then
			touchesDown[finger] = { x = x, y = y }
		elseif eventType == TOUCH_UP then
			touchesDown[finger] = nil
		end
	end
	for k,v in pairs(entity) do
		if type(v) == "table" then
			_G.onTouchEvent(eventType, finger, x, y, v)
		else
			if ((eventType == TOUCH_DOWN and k == "onTouchDown") or (eventType == TOUCH_UP and k == "onTouchUp")) and type(v) == "function" then
				v(entity, finger, x, y)
			end
		end
	end
end

function _G.onMouseButtonEvent(eventType, entity)
	if entity == nil then entity = _G.world end
	for k,v in pairs(entity) do
		if type(v) == "table" then
			_G.onMouseButtonEvent(eventType, v)
		else
			if ((eventType == MOUSE_DOWN and k == "onMouseDown") or (eventType == MOUSE_UP and k == "onMouseUp")) and type(v) == "function" then
				v(entity)
			end
		end
		--if ((eventType == MOUSE_DOWN and k == "onPress") or (eventType == MOUSE_UP and k == "onRelease")) and type(v) == "function" then
		--end
	end
end

function _G.onKeyboardEvent(down, key, entity)
	if entity == nil then
		entity = _G.world
		_G.keysDown[key] = down or nil
	end
	for k,v in pairs(entity) do
		if type(v) == "table" then
			_G.onKeyboardEvent(down, key, v)
		elseif ((down == true and k == "onKeyDown") or (down == false and k == "onKeyUp")) and type(v) == "function" then
			--setmetatable(_G, {__index = entity, __newindex = entity })
			v(entity, key)
		end
	end
end


function _G.updateInputAcceleration()
	_G.inputAcceleration.horizontal = 0
	_G.inputAcceleration.vertical = 0
	for key,_ in pairs(_G.keysDown) do
		if _G.inputAccelerationKeys[key] ~= nil and _G.inputAccelerationKeys[key].horizontal ~= nil then
			_G.inputAcceleration.horizontal = _G.inputAccelerationKeys[key].horizontal
		end
		if _G.inputAccelerationKeys[key] ~= nil and _G.inputAccelerationKeys[key].vertical ~= nil then
			_G.inputAcceleration.vertical = _G.inputAccelerationKeys[key].vertical
		end
	end
	_G.isTouching = false
	for _,touch in pairs(touchesDown) do
		_G.isTouching = true
		local direction = touch.x < 0.5 and "left" or "right"
		if _G.inputAccelerationTouches[direction] ~= nil then
			_G.inputAcceleration.horizontal = _G.inputAccelerationTouches[direction].horizontal or 0
			_G.inputAcceleration.vertical = _G.inputAccelerationTouches[direction].vertical or 0
		end
	end
end
