filemanager = {}

local lfs = require "lfs"
local lastModifications = {}
local dirs = { "assets/scripts/" }
for _,dir in ipairs(dirs) do
	for file in lfs.dir(dir) do
		if string.find(file, ".lua") then
			f = loadfile(dir .. file)
			if f then f() end
			lastModifications[file] = lfs.attributes(dir .. file).modification
		end
	end
end

local lastUpdate = os.clock()
function filemanager.update()
	if os.clock() > lastUpdate then
		lastUpdate = os.clock()
		for _,dir in ipairs(dirs) do
			for file in lfs.dir(dir) do
				if string.find(file, ".lua", 0) and not string.find(file, ".TMP", 0) then
					if lastModifications[file] ~= lfs.attributes(dir .. file).modification then
						lastModifications[file] = lfs.attributes(dir .. file).modification
						f = loadfile(dir .. file)
						if f then 
							table.insert(_G.coroutines, coroutine.create(f))
						end
					end
				end
			end
		end
	end
end


return filemanager