#version 330 core

precision highp float;

in vec2 uv;
out vec4 color;

uniform float u_strength;
uniform sampler2D textureSampler;

void main() {
	vec2 cuv = (uv - 0.5) * 2.0; // [-1, 1]
	float r = sqrt(cuv.x*cuv.x + cuv.y*cuv.y);
	float a = atan(cuv.y, cuv.x);

	a += r * u_strength;
	//a += 3.141;
	//vec4 multiplier = vec4(vec3(1.0, 1.0, 1.0) * ((sin(r * 1000.0) + 1.0) / 2.0), 1.0);
	vec2 spiraled_uv = (vec2(r * cos(a), r * sin(a)) + 1.0) / 2.0;
	//vec2 spiraled_uv = vec2(r * cos(a), r * sin(a));
	color = texture(textureSampler, spiraled_uv).rgba;
}