#version 330 core

precision highp float;

in vec2 uv;
out vec4 color;

uniform sampler2D textureSampler;
uniform float u_frequency;
uniform float u_offset;
uniform float u_strength;

void main() {
	vec4 multiplier = vec4(vec3(1.0, 1.0, 1.0) * (1.0 - u_strength * (sin((uv.y + u_offset) * u_frequency) + 1.0) / 2.0), 1);
	color = texture(textureSampler, uv).rgba * multiplier;
}