#version 330 core

precision highp float;

in vec2 uv;
out vec4 color;

uniform float u_spread;
uniform float u_strength;
uniform float u_size;
uniform vec4 u_color;
uniform sampler2D textureSampler;

void main() {
	float samples = 5.0;
	vec4 texColor = texture(textureSampler, uv).rgba / samples;// * 0.2270270270;
	texColor = texColor + texture(textureSampler, uv - vec2(4.0/u_size * u_spread, 0)) / samples;// * 0.1945945946;
	texColor = texColor + texture(textureSampler, uv - vec2(2.0/u_size * u_spread, 0)) / samples;// * 0.0540540541;
	texColor = texColor + texture(textureSampler, uv + vec2(2.0/u_size * u_spread, 0)) / samples;// * 0.0540540541;
	texColor = texColor + texture(textureSampler, uv + vec2(4.0/u_size * u_spread, 0)) / samples;// * 0.1945945946;
	texColor = texColor * u_strength;
	vec4 multiplier = vec4(u_color.rgb * u_color.a, u_color.a);
	color = texColor * multiplier;
}