#version 330 core

precision highp float;

in vec2 uv;
out vec4 color;

uniform float u_strength;
uniform float u_size;
uniform vec4 u_color;
uniform sampler2D textureSampler;

void main() {
	float a = texture(textureSampler, uv).a * 0.204164;
	a += texture(textureSampler, uv + vec2(1.0/u_size * 1.407333, 0)).a * 0.304005;
	a += texture(textureSampler, uv - vec2(1.0/u_size * 1.407333, 0)).a * 0.304005;
	a += texture(textureSampler, uv + vec2(1.0/u_size * 3.294215, 0)).a * 0.093913;
	a += texture(textureSampler, uv - vec2(1.0/u_size * 3.294215, 0)).a * 0.093913;
	a *= u_strength;
	color = vec4(u_color.rgb * a, a);
}