#version 330 core

precision highp float;

in vec2 uv;
out vec4 out_color;

uniform vec4 color;
uniform sampler2D textureSampler;

void main() {
	vec4 texColor = texture(textureSampler, uv).rgba;
	vec4 multiplier = vec4(color.rgb * color.a, color.a);
	out_color = texColor * multiplier;
}