#version 120
//varying float light;
varying float z;
varying vec2 uv;

uniform vec4 color;
uniform vec3 fogColor;
uniform float ambientLight;
uniform float intensity;
uniform float fogMinDistance;
uniform float fogDensity;
uniform float screenWidth;
uniform float screenHeight;
uniform sampler2D textureSampler;
uniform sampler2D translucentTextureSampler;
uniform sampler2D lightsTextureSampler;
uniform float translucentStrength;

void main() {
	//float lightValue = min(1.0, ambientLight + max(0.0, intensity * light));
	//float backLightValue = max(0.0, light * -1.0);
	//vec4 color = vec4(color.r * lightValue * color.a, color.g * lightValue * color.a, color.b * lightValue * color.a, color.a);
	vec4 texColor = texture2D(textureSampler, uv);
	texColor.rgb *= color.rgb;
	vec4 translucentColor = texture2D(translucentTextureSampler, uv);
	translucentColor.rgb *= color.rgb;
	float translucentValue = texture2D(lightsTextureSampler, vec2(gl_FragCoord.x / screenWidth, gl_FragCoord.y / screenHeight)).r;
	texColor.rgb = mix(texColor.rgb, translucentColor.rgb, min(1.0, translucentValue * translucentStrength));
	//texColor.rgb *= ambientLight;
	texColor.rgb = mix(texColor.rgb, fogColor, min(1.0, max(0.0, z - fogMinDistance) * fogDensity));
	gl_FragColor = texColor;
}