#version 120
varying float light;
varying vec3 normal;
varying vec4 pos;

uniform vec4 color;
uniform float ambientLight;
uniform float intensity;
uniform vec3 forward;
uniform float rimDist;
uniform float rimIntensity;

void main() {
	float lightValue = min(1.0, ambientLight + max(0.0, intensity * light) + pow(1.0 - abs(dot(normal, forward)), 2.0) * rimIntensity);
	lightValue *= 1.0 - abs(pos.x) / rimDist;
	gl_FragColor = vec4(color.r * lightValue * color.a, color.g * lightValue * color.a, color.b * lightValue * color.a, color.a);
}