#version 120
varying vec2 uv;
uniform sampler2D textureSampler;
uniform vec2 source;
uniform float density;
uniform float samples;
uniform float decay;
uniform float strength;
uniform float width;
uniform float height;

void main() {
	//vec2 pixelSize = vec2(1.0 / width, 1.0 / height);
	vec2 dist = uv - source;
//	dist.y /= width / height;
	vec2 delta = dist / samples * density;
	vec4 color = vec4(0.0);
	for (int i = 0; i < int(samples); ++i) {
		vec2 sampleUv = source + float(i) * delta;
		color.rgb += texture2D(textureSampler, sampleUv).rgb;
	}
	color = color / samples / max(1.0, length(dist * decay)) * strength;
	gl_FragColor = vec4(color.rgb, 0.0);
}