#version 120
varying float light;
varying float z;
varying vec2 uv;

uniform vec4 color;
uniform vec3 fogColor;
uniform float ambientLight;
uniform float intensity;
uniform float fogMinDistance;
uniform float fogDensity;
uniform float cellThreshold;
uniform sampler2D textureSampler;

void main() {
	float lightValue = min(1.0, ambientLight + max(0.0, intensity * light));
	//vec4 color = vec4(color.r * lightValue * color.a, color.g * lightValue * color.a, color.b * lightValue * color.a, color.a);
	vec4 color = texture2D(textureSampler, uv);
	color.rgb *= lightValue;
	color.rgb = floor(color.rgb * cellThreshold + 0.5) / cellThreshold;
	color.rgb = mix(color.rgb, fogColor, min(1.0, max(0.0, z - fogMinDistance) * fogDensity));
	gl_FragColor = color;
}