#version 120
varying vec2 uv;

uniform vec4 color;
uniform sampler2D textureSampler;
uniform float textureWidth;
uniform float textureHeight;
uniform float sampleDistance;

void main() {
	vec3 sample0 = texture2D(textureSampler, uv).rgb;
	float diff1 = ceil(length(sample0 - texture2D(textureSampler, uv + vec2(sampleDistance / textureWidth, -sampleDistance / textureHeight)).rgb));
	float diff2 = ceil(length(sample0 - texture2D(textureSampler, uv + vec2(-sampleDistance / textureWidth, -sampleDistance / textureHeight)).rgb));
	float diff3 = ceil(length(sample0 - texture2D(textureSampler, uv + vec2(-sampleDistance / textureWidth, sampleDistance / textureHeight)).rgb));
	float diff4 = ceil(length(sample0 - texture2D(textureSampler, uv + vec2(sampleDistance / textureWidth, sampleDistance / textureHeight)).rgb));
	float dist = ceil((diff1 + diff2 + diff3 + diff4));
	gl_FragColor = color * min(1.0, dist);
}