#version 120
attribute vec3 in_position1;
attribute vec3 in_normal1;
attribute vec3 in_position2;
attribute vec3 in_normal2;

uniform mat4 projection;
uniform mat4 transform;
uniform mat4 normalTransform;
uniform vec3 directionalLight;
uniform float morphFactor;

varying float light;

void main() {
	vec3 position = mix(in_position1, in_position2, morphFactor);
	vec3 normal = mix(in_normal1, in_normal2, morphFactor);
	light = dot(normalTransform * vec4(normal, 0), vec4(normalize(directionalLight),0));
	gl_Position = projection * transform * vec4(position, 1);
}