#version 120
varying vec2 uv;
varying float light;

uniform vec4 color;
uniform float ambientLight;
uniform float intensity;
uniform float cellThreshold;
uniform sampler2D textureSampler;

void main() {
	vec4 texColor = texture2D(textureSampler, uv).rgba;
	float lightValue = min(1.0, ambientLight + max(0.0, intensity * light));
	vec4 multiplier = vec4(lightValue * color.rgb * color.a, color.a);
	vec4 color = texColor * multiplier;
	color.rgb = floor(color.rgb * cellThreshold) / cellThreshold;
	gl_FragColor = color;
}