#version 120
varying vec2 uv;
uniform sampler2D x;    // x vector (Ax = b)
uniform sampler2D b;    // b vector (Ax = b)
uniform float alpha;
uniform float rBeta;
uniform float texelSize;

void main()
{
  // left, right, bottom, and top x samples
  
  vec4 xL = texture2D(x, uv - vec2(texelSize, 0));
  vec4 xR = texture2D(x, uv + vec2(texelSize, 0));
  vec4 xB = texture2D(x, uv - vec2(0, texelSize));
  vec4 xT = texture2D(x, uv + vec2(0, texelSize));

  // b sample, from center
  
   vec4 bC = texture2D(b, uv);

  // evaluate Jacobi iteration
  gl_FragColor = (xL + xR + xB + xT + alpha * bC) * rBeta;
}