#version 120
varying vec2 uv;

uniform vec4 color;
uniform sampler2D textureSampler;
uniform vec2 offset;
uniform float threshold;

void main() {
	float red = max(0.0, texture2D(textureSampler, uv + offset).r - threshold);
	red += ceil(red) * threshold;
	vec4 multiplier = vec4(color.rgb * color.a, color.a);
	gl_FragColor = vec4(red, red, red, red) * multiplier;
}