#version 120
attribute vec3 in_position;
attribute vec3 in_normal;
attribute vec2 in_uv;

uniform mat4 projection;
uniform mat4 transform;
uniform mat4 normalTransform;
uniform vec3 directionalLight;
uniform float cameraZ;
uniform float power;
uniform float divider;
uniform vec2 offset;
uniform mat4 indices;
uniform float depthPerOffsetIndex;

//varying float light;
varying float z;
varying vec2 uv;


void main() {
	//light = dot(normalize(normalTransform * vec4(in_normal, 0)), (vec4(normalize(directionalLight), 0)));
	vec4 pos = transform * vec4(in_position.x, in_position.y, in_position.z, 1.0);
	float dist = max(0.0, pow((cameraZ - pos.z) / divider, power));
	pos.xy += offset * dist;
	pos = projection * pos;
	z = pos.z;
	uv = in_uv;
	gl_Position = pos;
}