local bgColor = { 0.0, 0.0, 0.0 }

_G.clearColor = { red = bgColor[1], green = bgColor[2], blue = bgColor[3] }
--_G.clearColor = { red = 0.0, green = 0.0, blue = 0.0 }

_G.time = 0

local model = {
	layer = "3d",
	fs = "pn_fog",
	vs = "pn",
	scale = tunnelScale,
	uniforms = {
		directionalLight = { 1, 1, 0 },
		intensity = 0.8,
		ambientLight = 0.7,
		--color = { 1, 1, 1, 1 },
	}
}

renderTextureTargets = {
	effect1 = { width = config.width / 2, height = config.height / 2 },
	effect2 = { width = config.width, height = config.height },
	effect3 = { width = config.width / 2, height = config.height / 2 },
	effect4 = { width = config.width / 2, height = config.height / 2 },
}

local getPosition = function(channel, offset, t)

	t = t or time * 20 + offset
	local t2 = t - math.floor(t)
	local pixel0 = resources.getColorFromTexture("perlin_noise", math.abs(t) % (512 * 512), channel) / 255
	local pixel1 = resources.getColorFromTexture("perlin_noise", math.abs(t + 1) % (512 * 512), channel) / 255
	return _G.lerp(pixel0, pixel1, t2)
end

local makeLight = function(i)
	return { texture = "light", uniforms = { color = { 0.9, 0.9, 0.7, 0 } }, fs = "pt-pre", layer = "lights", x = function() return getPosition(0, i * 50) * 300 end, y = function() return getPosition(1, i * 10) * 400 end }
end

local particles = {
	layer = "lights",
	uniforms = { color = { 1, 0, 0, 1 } },
	particles = {
		sprite = "light",
		frequency = 80,
		emit = function(self, index) 
			r = math.random() * 500 + 100
			rScale = 1000
			speed = math.random() * 1.5 + 2
			speedY = math.random() * 0.5 + 1
			return {
				x = function(i) return (r + math.pow(i, 1.5) * rScale) * math.cos(i * speed + index) + getPosition(0, 0, i * 512*512*7) * 100 end,
				z = function(i) return (r + math.pow(i, 1.5) * rScale) * math.sin(i * speed + index) + getPosition(1, 0, i * 512*512*7) * 100 - 200 end,
				y = function(i) return i * 3000 * speedY + getPosition(2, 0, i * 512*512*7) * 100 end,
				scale = function(i) return math.min(1, math.log(i * 20 + 1)) end,
				lifeTime = 3,
				sprite = "light",
			} 
		end,
	},
	scale = 0.01,
}


_G.world = {
	instance{particles, uniforms_color = { 1, 0.5, 0.5, 1}, y = -10, x = 15, z = -25 },
	instance{particles, uniforms_color = { 1, 1, 0.5, 1}, y = -10, x = -12, z = -20 },
	instance{particles, uniforms_color = { 1, 1, 1, 1}, y = -10, x = 3, z = -15 },
	--take(10, makeLight),
	{ camera = { layer = "lights", fov = 65 }, z = 9 },

}